/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.testutils.LocalAlluxioClusterResource;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
public class LoadCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();
    @ClassRule
    public static LocalAlluxioClusterResource sResource = new LocalAlluxioClusterResource.Builder().setNumWorkers(1).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, "16MB").setProperty(PropertyKey.WORKER_TIERED_STORE_LEVELS, 1).setProperty(PropertyKey.WORKER_TIERED_STORE_LEVEL0_ALIAS, "HDD").setProperty(PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_MEDIUMTYPE, "HDD").setProperty(PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_QUOTA, "2GB").build();

    @Test
    public void testCommand() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileB", (WritePType)WritePType.THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDirectory/testFileC", (WritePType)WritePType.THROUGH, (int)0x100000);
        AlluxioURI uriA = new AlluxioURI("/testRoot/testFileA");
        AlluxioURI uriB = new AlluxioURI("/testRoot/testFileB");
        AlluxioURI uriC = new AlluxioURI("/testRoot/testDirectory/testFileC");
        Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(uriA).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(uriB).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(uriC).getInAlluxioPercentage());
        sFsShell.run(new String[]{"loadMetadata", "/testRoot"});
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--submit", "--verify"}));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--progress"}));
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriA, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriB, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriC, (int)100);
        while (!this.mOutput.toString().contains("SUCCEEDED")) {
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--progress"}));
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Files Processed: 3"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Bytes Loaded: 3072.00KB out of 3072.00KB"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Files Failed: 0"));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--stop"}));
        Assert.assertEquals((long)-2L, (long)sFsShell.run(new String[]{"load", "/testRootNotExists", "--progress"}));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Load for path '/testRootNotExists' cannot be found."));
        sFsShell.run(new String[]{"load", "/testRoot", "--progress", "--format", "JSON"});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("\"mJobState\":\"SUCCEEDED\""));
        sFsShell.run(new String[]{"load", "/testRoot", "--progress", "--format", "JSON", "--verbose"});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("\"mVerbose\":true"));
    }

    @Test
    public void testPartialListing() throws Exception {
        int numFiles = 500;
        for (int i = 0; i < numFiles; ++i) {
            String fileName = "/testRoot/testFile" + i;
            String fileName2 = "/testRoot/testDirectory/testFile" + i;
            FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName, (WritePType)WritePType.THROUGH, (int)0x100000);
            FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName2, (WritePType)WritePType.THROUGH, (int)0x100000);
            Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(new AlluxioURI(fileName)).getInAlluxioPercentage());
            Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(new AlluxioURI(fileName2)).getInAlluxioPercentage());
        }
        sFsShell.run(new String[]{"loadMetadata", "/testRoot"});
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--submit", "--partial-listing"}));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--progress"}));
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)new AlluxioURI("/testRoot/testDirectory/testFile" + (numFiles - 1)), (int)100);
        while (!this.mOutput.toString().contains("SUCCEEDED")) {
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRoot", "--progress"}));
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testPartlyLoaded() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootPartial/testFileA", (WritePType)WritePType.THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootPartial/testFileB", (WritePType)WritePType.CACHE_THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootPartial/testDirectory/testFileC", (WritePType)WritePType.CACHE_THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootPartial/testDirectory/testFileD", (WritePType)WritePType.THROUGH, (int)0x6400000);
        AlluxioURI uriA = new AlluxioURI("/testRootPartial/testFileA");
        AlluxioURI uriB = new AlluxioURI("/testRootPartial/testFileB");
        AlluxioURI uriC = new AlluxioURI("/testRootPartial/testDirectory/testFileC");
        AlluxioURI uriD = new AlluxioURI("/testRootPartial/testDirectory/testFileD");
        Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(uriA).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(uriB).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(uriC).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(uriD).getInAlluxioPercentage());
        sFsShell.run(new String[]{"loadMetadata", "/testRootLoaded"});
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRootPartial", "--submit"}));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRootPartial", "--progress"}));
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriA, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriB, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriC, (int)100);
        while (!this.mOutput.toString().contains("SUCCEEDED")) {
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRootPartial", "--progress"}));
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testAlreadyLoaded() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootLoaded/testFileA", (WritePType)WritePType.CACHE_THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootLoaded/testFileB", (WritePType)WritePType.CACHE_THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootLoaded/testDirectory/testFileC", (WritePType)WritePType.CACHE_THROUGH, (int)0x100000);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRootLoaded/testDirectory/testFileD", (WritePType)WritePType.CACHE_THROUGH, (int)0x6400000);
        AlluxioURI uriA = new AlluxioURI("/testRootLoaded/testFileA");
        AlluxioURI uriB = new AlluxioURI("/testRootLoaded/testFileB");
        AlluxioURI uriC = new AlluxioURI("/testRootLoaded/testDirectory/testFileC");
        AlluxioURI uriD = new AlluxioURI("/testRootLoaded/testDirectory/testFileD");
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(uriA).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(uriB).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(uriC).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(uriD).getInAlluxioPercentage());
        sFsShell.run(new String[]{"loadMetadata", "/testRootLoaded"});
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRootLoaded", "--submit"}));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRootLoaded", "--progress"}));
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriA, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriB, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriC, (int)100);
        while (!this.mOutput.toString().contains("SUCCEEDED")) {
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"load", "/testRootLoaded", "--progress"}));
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Files Processed: 0"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Bytes Loaded: 0B out of 0B"));
    }
}

