/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.WritePType;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check how to apply to the new use case in dora")
public final class LoadMetadataCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void loadMetadataDir() throws IOException, AlluxioException {
        String dirPath = "/testRoot/layer1/layer2/layer3/";
        String filePathA = PathUtils.concatPath((Object)dirPath, (Object)"testFileA");
        String filePathB = PathUtils.concatPath((Object)dirPath, (Object)"testFileB");
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePathA, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePathB, (WritePType)WritePType.CACHE_THROUGH, (int)30);
        AlluxioURI uriDir = new AlluxioURI(dirPath);
        AlluxioURI uriA = new AlluxioURI(filePathA);
        AlluxioURI uriB = new AlluxioURI(filePathB);
        URIStatus statusBeforeA = sFileSystem.getStatus(uriA);
        URIStatus statusBeforeB = sFileSystem.getStatus(uriB);
        DeletePOptions deletePOptions = DeletePOptions.newBuilder().setAlluxioOnly(true).setRecursive(true).build();
        sFileSystem.delete(uriDir, deletePOptions);
        sFsShell.run(new String[]{"loadMetadata", dirPath});
        GetStatusPOptions getStatusPOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build();
        URIStatus statusAfterA = sFileSystem.getStatus(uriA, getStatusPOptions);
        Assert.assertEquals((Object)statusBeforeA.getFileInfo().getName(), (Object)statusAfterA.getFileInfo().getName());
        Assert.assertEquals((long)statusBeforeA.getFileInfo().getLength(), (long)statusAfterA.getFileInfo().getLength());
        URIStatus statusAfterB = sFileSystem.getStatus(uriB, getStatusPOptions);
        Assert.assertEquals((Object)statusBeforeB.getFileInfo().getName(), (Object)statusAfterB.getFileInfo().getName());
        Assert.assertEquals((long)statusBeforeB.getFileInfo().getLength(), (long)statusAfterB.getFileInfo().getLength());
    }

    @Test
    public void loadMetadataFile() throws IOException, AlluxioException {
        String filePath = "/testRoot/layer1/layer2/layer3/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        AlluxioURI uri = new AlluxioURI(filePath);
        URIStatus statusBefore = sFileSystem.getStatus(uri);
        DeletePOptions deletePOptions = DeletePOptions.newBuilder().setAlluxioOnly(true).setRecursive(true).build();
        sFileSystem.delete(uri, deletePOptions);
        sFsShell.run(new String[]{"loadMetadata", filePath});
        GetStatusPOptions getStatusPOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build();
        URIStatus statusAfter = sFileSystem.getStatus(uri, getStatusPOptions);
        Assert.assertEquals((Object)statusBefore.getFileInfo().getName(), (Object)statusAfter.getFileInfo().getName());
        Assert.assertEquals((long)statusBefore.getFileInfo().getLength(), (long)statusAfter.getFileInfo().getLength());
    }

    @Test
    public void loadMetadataFileRecursive() throws IOException, AlluxioException {
        String filePath = "/testRoot/layer1/layer2/layer3/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        AlluxioURI uri = new AlluxioURI(filePath);
        URIStatus statusBefore = sFileSystem.getStatus(uri);
        DeletePOptions deletePOptions = DeletePOptions.newBuilder().setAlluxioOnly(true).setRecursive(true).build();
        sFileSystem.delete(uri, deletePOptions);
        sFsShell.run(new String[]{"loadMetadata", "-R", "/testRoot"});
        GetStatusPOptions getStatusPOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build();
        URIStatus statusAfter = sFileSystem.getStatus(uri, getStatusPOptions);
        Assert.assertEquals((Object)statusBefore.getFileInfo().getName(), (Object)statusAfter.getFileInfo().getName());
        Assert.assertEquals((long)statusBefore.getFileInfo().getLength(), (long)statusAfter.getFileInfo().getLength());
    }

    @Test
    public void loadMetadataFileWithWildcard() throws IOException, AlluxioException {
        String dirPath = "/testRoot/layer1/layer2/layer3/";
        String filePathA = PathUtils.concatPath((Object)dirPath, (Object)"testFileA");
        String filePathB = PathUtils.concatPath((Object)dirPath, (Object)"testFileB");
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePathA, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePathB, (WritePType)WritePType.THROUGH, (int)30);
        AlluxioURI uriA = new AlluxioURI(filePathA);
        AlluxioURI uriB = new AlluxioURI(filePathB);
        URIStatus statusBeforeA = sFileSystem.getStatus(uriA);
        URIStatus statusBeforeB = sFileSystem.getStatus(uriB);
        DeletePOptions deletePOptions = DeletePOptions.newBuilder().setAlluxioOnly(true).setRecursive(true).build();
        sFileSystem.delete(uriA, deletePOptions);
        sFileSystem.delete(uriB, deletePOptions);
        sFsShell.run(new String[]{"loadMetadata", "/*/*/*/*/testFile*"});
        GetStatusPOptions getStatusPOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build();
        URIStatus statusAfterA = sFileSystem.getStatus(uriA, getStatusPOptions);
        Assert.assertEquals((Object)statusBeforeA.getFileInfo().getName(), (Object)statusAfterA.getFileInfo().getName());
        Assert.assertEquals((long)statusBeforeA.getFileInfo().getLength(), (long)statusAfterA.getFileInfo().getLength());
        URIStatus statusAfterB = sFileSystem.getStatus(uriB, getStatusPOptions);
        Assert.assertEquals((Object)statusBeforeB.getFileInfo().getName(), (Object)statusAfterB.getFileInfo().getName());
        Assert.assertEquals((long)statusBeforeB.getFileInfo().getLength(), (long)statusAfterB.getFileInfo().getLength());
    }
}

