/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.security.user.TestUserState;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.security.auth.Subject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.security.authorization.permission.enabled", "false", "alluxio.security.authentication.type", "NOSASL", "alluxio.master.file.access.time.update.precision", "0"})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="the command is still relevant")
public final class LsCommandIntegrationTest
extends AbstractFileSystemShellTest {
    private static final String FILE_NEW_CONTENT = "testfoobarlongerthantheoriginalfile";

    private void createFiles(String user) throws Exception {
        FileSystem fs = sFileSystem;
        if (user != null) {
            fs = sLocalAlluxioCluster.getClient(FileSystemContext.create((Subject)new TestUserState(user, Configuration.global()).getSubject(), (AlluxioConfiguration)Configuration.global()));
        }
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileC", (WritePType)WritePType.THROUGH, (int)30);
    }

    @Test
    public void lsNoAcl() throws Exception {
        this.createFiles(null);
        sFsShell.run(new String[]{"ls", "--sort", "path", "/testRoot"});
        this.checkOutput("              1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "             30       PERSISTED .+ .+   0% /testRoot/testFileC");
    }

    @Test
    public void lsMultipleDirs() throws Exception {
        this.createFiles(null);
        sFsShell.run(new String[]{"ls", "--sort", "path", "/testRoot", "/testRoot/testDir/"});
        this.checkOutput("              1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "             30       PERSISTED .+ .+   0% /testRoot/testFileC", "             20   NOT_PERSISTED .+ .+ 100% /testRoot/testDir/testFileB");
    }

    @Test
    public void lsHumanReadable() throws Exception {
        this.createFiles(null);
        sFsShell.run(new String[]{"ls", "-h", "--sort", "path", "/testRoot"});
        this.checkOutput("              1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "            10B   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "            30B       PERSISTED .+ .+   0% /testRoot/testFileC");
    }

    @Test
    public void lsPinned() throws Exception {
        this.createFiles(null);
        AlluxioURI fileURI1 = new AlluxioURI("/testRoot/testDir/testFileB");
        AlluxioURI fileURI2 = new AlluxioURI("/testRoot/testFileA");
        sFileSystem.setAttribute(fileURI1, SetAttributePOptions.newBuilder().setPinned(true).build());
        sFileSystem.setAttribute(fileURI2, SetAttributePOptions.newBuilder().setPinned(true).build());
        sFsShell.run(new String[]{"ls", "-pR", "--sort", "path", "/testRoot"});
        this.checkOutput("             20   NOT_PERSISTED .+ .+ 100% /testRoot/testDir/testFileB", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA");
    }

    @Test
    public void lsDirectoryAsPlainFileNoAcl() throws Exception {
        this.createFiles(null);
        sFsShell.run(new String[]{"ls", "-d", "/testRoot"});
        this.checkOutput("              3       PERSISTED .+ .+  DIR /testRoot");
    }

    @Test
    public void lsRootNoAcl() throws Exception {
        sFsShell.run(new String[]{"ls", "-d", "/"});
        this.checkOutput("              0       PERSISTED .+ .+  DIR /    ");
    }

    @Test
    public void lsWildcardNoAcl() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        sFsShell.run(new String[]{"ls", "--sort", "path", testDir + "/*/foo*"});
        this.checkOutput("             30   NOT_PERSISTED .+ .+ 100% /testDir/bar/foobar3", "             10   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar1", "             20   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar2");
        this.mOutput.reset();
        sFsShell.run(new String[]{"ls", "--sort", "path", testDir + "/*"});
        this.checkOutput("             30   NOT_PERSISTED .+ .+ 100% /testDir/bar/foobar3", "             10   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar1", "             20   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar2", "             40   NOT_PERSISTED .+ .+ 100% /testDir/foobar4");
    }

    @Test
    public void lsrNoAcl() throws Exception {
        this.createFiles(null);
        sFsShell.run(new String[]{"ls", "-R", "--sort", "path", "/testRoot"});
        this.checkOutput("              1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "             20   NOT_PERSISTED .+ .+ 100% /testRoot/testDir/testFileB", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "             30       PERSISTED .+ .+   0% /testRoot/testFileC");
    }

    @Test
    public void lsWithFormatSpecifierCharacter() throws IOException, AlluxioException {
        String fileName = "/localhost%2C61764%2C1476207067267..meta.1476207073442.meta";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName, (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"ls", "/"});
        this.checkOutput("             10   NOT_PERSISTED .+ .+ 100% /localhost%2C61764%2C1476207067267..meta.1476207073442.meta");
    }

    @Test
    public void lsWithSortByPath() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testLongFile", (WritePType)WritePType.MUST_CACHE, (int)100);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileZ", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)50);
        sFsShell.run(new String[]{"ls", "--sort", "path", "/testRoot"});
        this.checkOutput("             50   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileZ", "            100   NOT_PERSISTED .+ .+ 100% /testRoot/testLongFile");
    }

    @Test
    public void lsWithSortByAccessTime() throws IOException, AlluxioException {
        String oldFileRecentlyAccessed = "/testRoot/testFileRecent";
        String oldFileName = "/testRoot/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)oldFileRecentlyAccessed, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)oldFileName, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.loadFile((FileSystem)sFileSystem, (String)oldFileRecentlyAccessed);
        sFsShell.run(new String[]{"ls", "--sort", "lastAccessTime", "/testRoot"});
        this.checkOutput("             10   NOT_PERSISTED .+ .+ 100% " + oldFileName, "             10   NOT_PERSISTED .+ .+ 100% " + oldFileRecentlyAccessed);
    }

    @Test
    public void lsWithSortByCreationTime() throws IOException, AlluxioException {
        String oldFileRecentlyAccessed = "/testRoot/testFileRecent";
        String oldFileName = "/testRoot/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)oldFileRecentlyAccessed, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)oldFileName, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.loadFile((FileSystem)sFileSystem, (String)oldFileRecentlyAccessed);
        sFsShell.run(new String[]{"ls", "--sort", "creationTime", "/testRoot"});
        this.checkOutput("             10   NOT_PERSISTED .+ .+ 100% " + oldFileRecentlyAccessed, "             10   NOT_PERSISTED .+ .+ 100% " + oldFileName);
    }

    @Test
    public void lsWithSortBySize() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)50, (long)50L);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileZ", (WritePType)WritePType.MUST_CACHE, (int)10, (long)10L);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testLongFile", (WritePType)WritePType.MUST_CACHE, (int)100, (long)100L);
        sFsShell.run(new String[]{"ls", "--sort", "size", "/testRoot"});
        this.checkOutput("             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileZ", "             50   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "            100   NOT_PERSISTED .+ .+ /testRoot/testLongFile");
    }

    @Test
    public void lsWithSortBySizeAndReverse() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)50, (long)50L);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileZ", (WritePType)WritePType.MUST_CACHE, (int)10, (long)10L);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testLongFile", (WritePType)WritePType.MUST_CACHE, (int)100, (long)100L);
        sFsShell.run(new String[]{"ls", "--sort", "size", "-r", "/testRoot"});
        this.checkOutput("            100   NOT_PERSISTED .+ .+ 100% /testRoot/testLongFile", "             50   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileZ");
    }

    @Test
    public void lsWithInvalidSortOption() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)50, (long)50L);
        sFsShell.run(new String[]{"ls", "--sort", "unknownfield", "/testRoot"});
        String expected = "Invalid sort option `unknownfield` for --sort\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void lsReverseWithoutSort() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)50, (long)50L);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileZ", (WritePType)WritePType.MUST_CACHE, (int)10, (long)10L);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testLongFile", (WritePType)WritePType.MUST_CACHE, (int)100, (long)100L);
        sFsShell.run(new String[]{"ls", "-r", "--sort", "path", "/testRoot"});
        this.checkOutput("            100   NOT_PERSISTED .+ .+ 100% /testRoot/testLongFile", "             10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileZ", "             50   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA");
    }

    @Test
    public void lsAfterForceMasterSync() throws Exception {
        String testFilePath = "/testPersist/testFile";
        int size = 100;
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)testFilePath, (WritePType)WritePType.THROUGH, (int)size);
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testFilePath)).isPersisted());
        String rootUfsDir = sLocalAlluxioCluster.getClient().getConf().get(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS).toString();
        File ufsFile = new File(rootUfsDir + testFilePath);
        ufsFile.delete();
        PrintWriter out = new PrintWriter(ufsFile);
        String newContent = FILE_NEW_CONTENT;
        out.print(newContent);
        out.close();
        AlluxioURI uri = new AlluxioURI(testFilePath);
        URIStatus uriStatus = sFileSystem.getStatus(uri);
        long length = uriStatus.getLength();
        Assert.assertEquals((long)size, (long)length);
        int ret = sFsShell.run(new String[]{"cat", testFilePath});
        Assert.assertEquals((long)-1L, (long)ret);
        String errMsg = String.format("expected to be %s bytes, but only %s bytes are available", size, newContent.getBytes().length);
        Assert.assertTrue((boolean)this.mOutput.toString().contains(errMsg));
        this.mOutput.reset();
        sFsShell.run(new String[]{"ls", "/testPersist/"});
        this.checkOutput("\\s+" + newContent.getBytes().length + "\\s+PERSISTED (.*) 0% " + testFilePath);
    }

    @Test
    public void recursiveLsAfterForceMasterSync() throws Exception {
        String testFilePath = "/testPersist/testFile";
        int size = 100;
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)testFilePath, (WritePType)WritePType.THROUGH, (int)size);
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testFilePath)).isPersisted());
        String rootUfsDir = sLocalAlluxioCluster.getClient().getConf().get(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS).toString();
        File ufsFile = new File(rootUfsDir + testFilePath);
        ufsFile.delete();
        PrintWriter out = new PrintWriter(ufsFile);
        String newContent = FILE_NEW_CONTENT;
        out.print(newContent);
        out.close();
        AlluxioURI uri = new AlluxioURI(testFilePath);
        URIStatus uriStatus = sFileSystem.getStatus(uri);
        long length = uriStatus.getLength();
        Assert.assertEquals((long)size, (long)length);
        int ret = sFsShell.run(new String[]{"cat", testFilePath});
        Assert.assertEquals((long)-1L, (long)ret);
        String errMsg = String.format("expected to be %s bytes, but only %s bytes are available", size, newContent.getBytes().length);
        Assert.assertTrue((boolean)this.mOutput.toString().contains(errMsg));
        this.mOutput.reset();
        sFsShell.run(new String[]{"ls", "-R", "/"});
        this.checkOutput("\\s+1\\s+ PERSISTED (.*) DIR /testPersist", "\\s+" + newContent.getBytes().length + "\\s+PERSISTED (.*) 0% " + testFilePath);
    }

    private void checkOutput(String ... linePatterns) {
        String[] actualLines = this.mOutput.toString().split("\n");
        Assert.assertEquals((String)("Output: " + this.mOutput.toString()), (long)linePatterns.length, (long)actualLines.length);
        for (int i = 0; i < linePatterns.length; ++i) {
            Assert.assertThat((String)("mOutput: " + this.mOutput.toString()), (Object)actualLines[i], (Matcher)Matchers.matchesPattern((String)linePatterns[i]));
        }
    }
}

