/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.WritePType;
import alluxio.security.authorization.AclEntry;
import alluxio.security.user.TestUserState;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.security.authorization.permission.enabled", "true", "alluxio.security.authentication.type", "SIMPLE", "alluxio.security.group.mapping.class", "alluxio.security.group.provider.IdentityUserGroupsMapping", "alluxio.security.authorization.permission.supergroup", "test_user_ls", "alluxio.master.file.access.time.update.precision", "0"})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="pending on security related meta in dora")
public final class LsCommandSecurityIntegrationTest
extends AbstractFileSystemShellTest {
    private void createFiles() throws Exception {
        FileSystem fs = sLocalAlluxioCluster.getClient(FileSystemContext.create((Subject)new TestUserState("test_user_ls", Configuration.global()).getSubject(), (AlluxioConfiguration)Configuration.global()));
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileC", (WritePType)WritePType.THROUGH, (int)30);
    }

    @Test
    public void ls() throws Exception {
        this.createFiles();
        sFsShell.run(new String[]{"ls", "--sort", "path", "/testRoot"});
        this.checkOutput("drwxr-xr-x  test_user_ls   test_user_ls                 1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "-rw-r--r--  test_user_ls   test_user_ls                10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "-rw-r--r--  test_user_ls   test_user_ls                30       PERSISTED .+ .+   0% /testRoot/testFileC");
    }

    @Test
    public void lsWildcard() throws Exception {
        FileSystem fs = sLocalAlluxioCluster.getClient(FileSystemContext.create((Subject)new TestUserState("test_user_ls", Configuration.global()).getSubject(), (AlluxioConfiguration)Configuration.global()));
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(fs);
        sFsShell.run(new String[]{"ls", testDir + "/*/foo*"});
        this.checkOutput("-rw-r--r--  test_user_ls   test_user_ls                30   NOT_PERSISTED .+ .+ 100% /testDir/bar/foobar3", "-rw-r--r--  test_user_ls   test_user_ls                10   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar1", "-rw-r--r--  test_user_ls   test_user_ls                20   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar2");
        this.mOutput.reset();
        sFsShell.run(new String[]{"ls", "--sort", "path", testDir + "/*"});
        this.checkOutput("-rw-r--r--  test_user_ls   test_user_ls                30   NOT_PERSISTED .+ .+ 100% /testDir/bar/foobar3", "-rw-r--r--  test_user_ls   test_user_ls                10   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar1", "-rw-r--r--  test_user_ls   test_user_ls                20   NOT_PERSISTED .+ .+ 100% /testDir/foo/foobar2", "-rw-r--r--  test_user_ls   test_user_ls                40   NOT_PERSISTED .+ .+ 100% /testDir/foobar4");
    }

    @Test
    public void lsr() throws Exception {
        this.createFiles();
        sFsShell.run(new String[]{"ls", "-R", "--sort", "path", "/testRoot"});
        this.checkOutput("drwxr-xr-x  test_user_ls   test_user_ls                 1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "-rw-r--r--  test_user_ls   test_user_ls                20   NOT_PERSISTED .+ .+ 100% /testRoot/testDir/testFileB", "-rw-r--r--  test_user_ls   test_user_ls                10   NOT_PERSISTED .+ .+ 100% /testRoot/testFileA", "-rw-r--r--  test_user_ls   test_user_ls                30       PERSISTED .+ .+   0% /testRoot/testFileC");
    }

    private String getDisplayTime(long timestamp) {
        String formatString = Configuration.getString((PropertyKey)PropertyKey.USER_DATE_FORMAT_PATTERN);
        return CommonUtils.convertMsToDate((long)timestamp, (String)formatString);
    }

    @Test
    public void lsWithCreationTime() throws Exception {
        this.checkLsWithTimestamp("creationTime", URIStatus::getCreationTimeMs);
    }

    @Test
    public void lsWithModificationTime() throws Exception {
        this.checkLsWithTimestamp("lastModificationTime", URIStatus::getLastModificationTimeMs);
    }

    @Test
    public void lsWithAccessTime() throws Exception {
        this.checkLsWithTimestamp("lastAccessTime", URIStatus::getLastAccessTimeMs);
    }

    private void checkLsWithTimestamp(String parameter, Function<URIStatus, Long> timestampFunc) throws Exception {
        this.createFiles();
        String testDir = "/testRoot/testDir";
        String testFileA = "/testRoot/testFileA";
        String testFileC = "/testRoot/testFileC";
        sFileSystem.listStatus(new AlluxioURI(testDir));
        FileSystemTestUtils.loadFile((FileSystem)sFileSystem, (String)testFileA);
        FileSystemTestUtils.loadFile((FileSystem)sFileSystem, (String)testFileC);
        sFsShell.run(new String[]{"ls", "--timestamp", parameter, "--sort", "path", "/testRoot"});
        long time1 = timestampFunc.apply(sFileSystem.getStatus(new AlluxioURI(testDir)));
        long time2 = timestampFunc.apply(sFileSystem.getStatus(new AlluxioURI(testFileA)));
        long time3 = timestampFunc.apply(sFileSystem.getStatus(new AlluxioURI(testFileC)));
        this.checkOutput("drwxr-xr-x  test_user_ls   test_user_ls                 1   NOT_PERSISTED " + this.getDisplayTime(time1) + "  DIR /testRoot/testDir", "-rw-r--r--  test_user_ls   test_user_ls                10   NOT_PERSISTED " + this.getDisplayTime(time2) + " 100% /testRoot/testFileA", "-rw-r--r--  test_user_ls   test_user_ls                30       PERSISTED " + this.getDisplayTime(time3) + " 100% /testRoot/testFileC");
    }

    @Test
    public void lsWithExtendedAcl() throws IOException, AlluxioException {
        int size = 50;
        FileSystem fs = sLocalAlluxioCluster.getClient(FileSystemContext.create((Subject)new TestUserState("test_user_ls", Configuration.global()).getSubject(), (AlluxioConfiguration)Configuration.global()));
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFile", (WritePType)WritePType.MUST_CACHE, (int)size, (long)size);
        sFsShell.run(new String[]{"ls", "--sort", "path", "/testRoot"});
        this.checkOutput("drwxr-xr-x  test_user_ls   test_user_ls                 1   NOT_PERSISTED .+ .+ DIR /testRoot/testDir", "-rw-r--r--  test_user_ls   test_user_ls                50   NOT_PERSISTED .+ .+ 100% /testRoot/testFile");
        this.mOutput.reset();
        fs.setAcl(new AlluxioURI("/testRoot/testDir"), SetAclAction.MODIFY, Arrays.asList(AclEntry.fromCliString((String)"default:user:nameduser:rwx")));
        fs.setAcl(new AlluxioURI("/testRoot/testFile"), SetAclAction.MODIFY, Arrays.asList(AclEntry.fromCliString((String)"user:nameduser:rwx")));
        sFsShell.run(new String[]{"ls", "--sort", "path", "/testRoot"});
        this.checkOutput("drwxr-xr-x\\+ test_user_ls   test_user_ls                 1   NOT_PERSISTED .+ .+  DIR /testRoot/testDir", "-rw-r--r--\\+ test_user_ls   test_user_ls                50   NOT_PERSISTED .+ .+ 100% /testRoot/testFile");
    }

    private void checkOutput(String ... linePatterns) {
        String[] actualLines = this.mOutput.toString().split("\n");
        Assert.assertEquals((String)("Output: " + this.mOutput.toString()), (long)linePatterns.length, (long)actualLines.length);
        for (int i = 0; i < linePatterns.length; ++i) {
            Assert.assertThat((String)("mOutput: " + this.mOutput.toString()), (Object)actualLines[i], (Matcher)Matchers.matchesPattern((String)linePatterns[i]));
        }
    }
}

