/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="the command is still relevant")
public final class MkdirCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void mkdir() throws IOException, AlluxioException {
        String qualifiedPath = "alluxio://" + sLocalAlluxioCluster.getHostname() + ":" + sLocalAlluxioCluster.getMasterRpcPort() + "/root/testFile1";
        sFsShell.run(new String[]{"mkdir", qualifiedPath});
        URIStatus status = sFileSystem.getStatus(new AlluxioURI("/root/testFile1"));
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)this.getCommandOutput(new String[]{"mkdir", qualifiedPath}), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)status.isFolder());
    }

    @Test
    public void mkdirComplexPath() throws IOException, AlluxioException {
        sFsShell.run(new String[]{"mkdir", "/Complex!@#$%^&*()-_=+[]{};\"'<>,.?/File"});
        URIStatus status = sFileSystem.getStatus(new AlluxioURI("/Complex!@#$%^&*()-_=+[]{};\"'<>,.?/File"));
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)this.getCommandOutput(new String[]{"mkdir", "/Complex!@#$%^&*()-_=+[]{};\"'<>,.?/File"}), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)status.isFolder());
    }

    @Test
    public void mkdirExisting() throws IOException {
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"mkdir", "/testFile1"}));
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"mkdir", "/testFile1"}));
    }

    @Test
    public void mkdirPathWithWhiteSpaces() {
        String[] paths;
        for (String path : paths = new String[]{"/ ", "/x y z", "/ x y z", "/ x y z / a b c"}) {
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"mkdir", path}));
        }
    }

    @Test
    public void mkdirInvalidPath() throws IOException {
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"mkdir", ""}));
    }

    @Test
    public void mkdirMultiPath() throws IOException, AlluxioException {
        String path1 = "/testDir1";
        String path2 = "/testDir2";
        String path3 = "/testDir2/testDir2.1";
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"mkdir", path1, path2, path3}));
        URIStatus status = sFileSystem.getStatus(new AlluxioURI(path1));
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isFolder());
        status = sFileSystem.getStatus(new AlluxioURI(path2));
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isFolder());
        status = sFileSystem.getStatus(new AlluxioURI(path3));
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isFolder());
    }

    @Test
    public void mkdirShortPath() throws IOException, AlluxioException {
        sFsShell.run(new String[]{"mkdir", "/root/testFile1"});
        URIStatus status = sFileSystem.getStatus(new AlluxioURI("/root/testFile1"));
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)this.getCommandOutput(new String[]{"mkdir", "/root/testFile1"}), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)status.isFolder());
    }
}

