/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="adapt mv command to the new logic and bring back the tests")
public final class MvCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void rename() throws IOException {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/testFolder1"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder1"}));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testFolder1")));
        sFsShell.run(new String[]{"mv", "/testFolder1", "/testFolder"});
        toCompare.append(this.getCommandOutput(new String[]{"mv", "/testFolder1", "/testFolder"}));
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/testFolder")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI("/testFolder1")));
    }

    @Test
    public void renameParentDirectory() throws IOException {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/test/File1"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/test/File1"}));
        sFsShell.run(new String[]{"mv", "/test", "/test2"});
        toCompare.append(this.getCommandOutput(new String[]{"mv", "/test", "/test2"}));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI("/test2/File1")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI("/test")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI("/test/File1")));
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
    }

    @Test
    public void renameToExistingFile() throws IOException {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/testFolder"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder"}));
        sFsShell.run(new String[]{"mkdir", "/testFolder1"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder1"}));
        int ret = sFsShell.run(new String[]{"mv", "/testFolder1", "/testFolder"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        System.out.println(output);
        Assert.assertTrue((boolean)output.contains("Cannot rename because destination already exists. src: /testFolder1 dst: /testFolder"));
    }
}

