/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.TestLoggerRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fs.FileSystemShell;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.security.authorization.Mode;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.master.persistence.blacklist", "foobar_blacklist"})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="fix persist command command")
public final class PersistCommandTest
extends AbstractFileSystemShellTest {
    @Rule
    public TestLoggerRule mLogRule = new TestLoggerRule();

    @Test
    public void persist() throws Exception {
        String testFilePath = "/testPersist/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)testFilePath, (WritePType)WritePType.MUST_CACHE, (int)10);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI("/testPersist/testFile")).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", testFilePath});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI("/testPersist/testFile"), 10);
    }

    @Test
    public void persistDirectory() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)"MUST_CACHE");
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/foo")).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/bar")).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", testDir});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testDir)).isPersisted());
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/foo")).isPersisted());
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/bar")).isPersisted());
        this.checkFilePersisted(new AlluxioURI(testDir + "/foo/foobar1"), 10);
        this.checkFilePersisted(new AlluxioURI(testDir + "/foo/foobar2"), 20);
        this.checkFilePersisted(new AlluxioURI(testDir + "/bar/foobar3"), 30);
        this.checkFilePersisted(new AlluxioURI(testDir + "/foobar4"), 40);
    }

    @Test
    public void persistOnRenameDirectory() throws Exception {
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, "MUST_CACHE");
        conf.set(PropertyKey.USER_FILE_PERSIST_ON_RENAME, (Object)true);
        try (FileSystemShell fsShell = new FileSystemShell((AlluxioConfiguration)conf);){
            String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
            String toPersist = testDir + "/foo";
            String persisted = testDir + "/foo_persisted";
            String doNotPersist = testDir + "/bar";
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir)).isPersisted());
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(toPersist)).isPersisted());
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(doNotPersist)).isPersisted());
            int ret = fsShell.run(new String[]{"mv", toPersist, persisted});
            Assert.assertEquals((String)this.mOutput.toString(), (long)0L, (long)ret);
            CommonUtils.waitFor((String)"Directory to be persisted", () -> {
                try {
                    return sFileSystem.getStatus(new AlluxioURI(persisted)).isPersisted() && sFileSystem.getStatus(new AlluxioURI(persisted + "/foobar1")).isPersisted() && sFileSystem.getStatus(new AlluxioURI(persisted + "/foobar2")).isPersisted();
                }
                catch (Exception e) {
                    return false;
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/bar")).isPersisted());
            this.checkFilePersisted(new AlluxioURI(persisted + "/foobar1"), 10);
            this.checkFilePersisted(new AlluxioURI(persisted + "/foobar2"), 20);
        }
    }

    @Test
    public void persistOnRenameDirectoryBlacklist() throws Exception {
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, "MUST_CACHE");
        conf.set(PropertyKey.USER_FILE_PERSIST_ON_RENAME, (Object)true);
        try (FileSystemShell fsShell = new FileSystemShell((AlluxioConfiguration)conf);){
            String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
            String toPersist = testDir + "/foo";
            String persisted = testDir + "/foo_persisted";
            FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)(toPersist + "/foobar_blacklist"), (WritePType)WritePType.MUST_CACHE, (int)10);
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir)).isPersisted());
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(toPersist)).isPersisted());
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(toPersist + "/foobar_blacklist")).isPersisted());
            int ret = fsShell.run(new String[]{"mv", toPersist, persisted});
            Assert.assertEquals((long)0L, (long)ret);
            CommonUtils.waitFor((String)"Directory to be persisted", () -> {
                try {
                    return sFileSystem.getStatus(new AlluxioURI(persisted)).isPersisted() && sFileSystem.getStatus(new AlluxioURI(persisted + "/foobar1")).isPersisted();
                }
                catch (Exception e) {
                    return false;
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
            Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(persisted + "/foobar_blacklist")).isPersisted());
            this.checkFilePersisted(new AlluxioURI(persisted + "/foobar1"), 10);
        }
    }

    @Test
    public void persistMultiFiles() throws Exception {
        String filePath1 = "/testPersist/testFile1";
        String filePath2 = "/testFile2";
        String filePath3 = "/testPersist/testFile3";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath1, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath2, (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath3, (WritePType)WritePType.MUST_CACHE, (int)30);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath1)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath2)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath3)).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", filePath1, filePath2, filePath3});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI(filePath1), 10);
        this.checkFilePersisted(new AlluxioURI(filePath2), 20);
        this.checkFilePersisted(new AlluxioURI(filePath3), 30);
    }

    @Test
    public void persistMultiFilesAndDirs() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)"MUST_CACHE");
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/foo")).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/foo/foobar2")).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/bar")).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", testDir + "/foo/foobar1", testDir + "/foobar4", testDir + "/bar", testDir + "/bar/foobar3"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testDir)).isPersisted());
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/foo")).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/foo/foobar2")).isPersisted());
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI(testDir + "/bar")).isPersisted());
        this.checkFilePersisted(new AlluxioURI(testDir + "/foo/foobar1"), 10);
        this.checkFilePersisted(new AlluxioURI(testDir + "/bar/foobar3"), 30);
        this.checkFilePersisted(new AlluxioURI(testDir + "/foobar4"), 40);
    }

    @Test
    public void persistNonexistentFile() throws Exception {
        String path = "/testPersistNonexistent";
        int ret = sFsShell.run(new String[]{"persist", path});
        Assert.assertEquals((long)-1L, (long)ret);
        Assert.assertEquals((Object)(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}) + "\n"), (Object)this.mOutput.toString());
    }

    @Test
    public void persistTwice() throws Exception {
        String testFilePath = "/testPersist/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)testFilePath, (WritePType)WritePType.MUST_CACHE, (int)10);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI("/testPersist/testFile")).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", testFilePath});
        Assert.assertEquals((long)0L, (long)ret);
        ret = sFsShell.run(new String[]{"persist", testFilePath});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI("/testPersist/testFile"), 10);
    }

    @Test
    public void persistWithAncestorPermission() throws Exception {
        String ufsRoot = sFileSystem.getStatus(new AlluxioURI("/")).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)ufs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)ufs) ? 1 : 0) != 0);
        AlluxioURI testFile = new AlluxioURI("/grand/parent/file");
        AlluxioURI grandParent = new AlluxioURI("/grand");
        Mode grandParentMode = new Mode(511);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)testFile, (WritePType)WritePType.MUST_CACHE, (int)10);
        URIStatus status = sFileSystem.getStatus(testFile);
        Assert.assertFalse((boolean)status.isPersisted());
        sFileSystem.setAttribute(grandParent, SetAttributePOptions.newBuilder().setMode(grandParentMode.toProto()).build());
        int ret = sFsShell.run(new String[]{"persist", testFile.toString()});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(testFile, 10);
        short fileMode = (short)status.getMode();
        short parentMode = (short)sFileSystem.getStatus(testFile.getParent()).getMode();
        Assert.assertEquals((long)fileMode, (long)ufs.getFileStatus(PathUtils.concatPath((Object)ufsRoot, (Object)testFile)).getMode());
        Assert.assertEquals((long)parentMode, (long)ufs.getDirectoryStatus(PathUtils.concatPath((Object)ufsRoot, (Object)testFile.getParent())).getMode());
        Assert.assertEquals((Object)grandParentMode, (Object)new Mode(ufs.getDirectoryStatus(PathUtils.concatPath((Object)ufsRoot, (Object)grandParent)).getMode()));
    }

    @Test
    public void persistWithWildCard() throws Exception {
        String filePath1 = "/testPersist1/testFile1";
        String filePath2 = "/testPersist2/testFile2";
        String filePath3 = "/testPersist2/testFile3";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath1, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath2, (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath3, (WritePType)WritePType.MUST_CACHE, (int)30);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath1)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath2)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath3)).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", "/*/testFile*"});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI(filePath1), 10);
        this.checkFilePersisted(new AlluxioURI(filePath2), 20);
        this.checkFilePersisted(new AlluxioURI(filePath3), 30);
    }

    @Test
    public void persistRecursive() throws Exception {
        String filePath1 = "/testPersistRecursive/testFile1";
        String filePath2 = "/testPersistRecursive/testDir1/testFile2";
        String filePath3 = "/testPersistRecursive/testDir1/testDir2/testFile3";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath1, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath2, (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath3, (WritePType)WritePType.MUST_CACHE, (int)30);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath1)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath2)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath3)).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", "/testPersistRecursive"});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI(filePath1), 10);
        this.checkFilePersisted(new AlluxioURI(filePath2), 20);
        this.checkFilePersisted(new AlluxioURI(filePath3), 30);
    }

    @Test
    public void persistPartial() throws Exception {
        String filePath1 = "/testPersistPartial/testFile1";
        String filePath2 = "/testPersistPartial/testFile2";
        String filePath3 = "/testPersistPartial/testFile3";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath1, (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath2, (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath3, (WritePType)WritePType.MUST_CACHE, (int)30);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath1)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath2)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath3)).isPersisted());
        int ret = sFsShell.run(new String[]{"persist", "/testPersistPartial/testFile1"});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI(filePath1), 10);
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath2)).isPersisted());
        Assert.assertFalse((boolean)sFileSystem.getStatus(new AlluxioURI(filePath3)).isPersisted());
        ret = sFsShell.run(new String[]{"persist", "/testPersistPartial"});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI(filePath1), 10);
        this.checkFilePersisted(new AlluxioURI(filePath2), 20);
        this.checkFilePersisted(new AlluxioURI(filePath3), 30);
    }

    @Test
    public void persistParallelFilesEqParallelism() throws Exception {
        this.persistParallel(10, 10);
    }

    @Test
    public void persistParallelFilesLtParallelism() throws Exception {
        this.persistParallel(10, 100);
    }

    @Test
    public void persistParallelFilesGtParallelism() throws Exception {
        this.persistParallel(2, 1);
    }

    @Test
    public void persistWithWaitTimeTest() throws Exception {
        String filePath = "/testPersistWaitTime/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"persist", "--wait", "1s", "/*"});
        Assert.assertEquals((long)0L, (long)ret);
        this.checkFilePersisted(new AlluxioURI(filePath), 10);
    }

    @Test
    public void persistWithWaitTimeBiggerThanTimeoutTest() throws Exception {
        String filePath = "/testPersistWaitTimeValid/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"persist", "--wait", "2s", "--timeout", "1s", "/*"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.persistence.initial.interval", "1s", "alluxio.master.persistence.scheduler.interval", "1s", "alluxio.master.persistence.checker.interval", "1s"})
    public void persistShortTimeout() throws Exception {
        this.shortTimeoutTest("--timeout");
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.persistence.initial.interval", "1s", "alluxio.master.persistence.scheduler.interval", "1s", "alluxio.master.persistence.checker.interval", "1s"})
    public void persistShortTimeoutShortOption() throws Exception {
        this.shortTimeoutTest("-t");
    }

    void shortTimeoutTest(String option) throws Exception {
        this.createUnpersistedFiles("/testPersistTimeout", 100, 2);
        sFsShell.run(new String[]{"persist", option, String.valueOf(1), "/*"});
        Assert.assertTrue((String)"Should log at least one timeout", (boolean)this.mLogRule.wasLogged("Timed out waiting for file to be persisted:"));
    }

    @Test
    public void persistLongTimeout() throws Exception {
        int fileSize = 100;
        List<AlluxioURI> files = this.createUnpersistedFiles("/testPersistTimeout", fileSize, 2);
        int ret = sFsShell.run(new String[]{"persist", "--timeout", String.valueOf(60000), "/*"});
        Assert.assertEquals((String)"shell should not report error", (long)0L, (long)ret);
        Assert.assertFalse((String)"Should not have logged timeout", (boolean)this.mLogRule.wasLogged("Timed out waiting for file to be persisted:"));
        for (AlluxioURI file : files) {
            this.checkFilePersisted(file, fileSize);
        }
    }

    private List<AlluxioURI> createUnpersistedFiles(String dirPath, int fileSize, int totalFiles) throws Exception {
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>(totalFiles);
        for (int i = 0; i < totalFiles; ++i) {
            String path = String.format("%s/%d", dirPath, i);
            files.add(new AlluxioURI(path));
            FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)path, (WritePType)WritePType.MUST_CACHE, (int)fileSize);
            Assert.assertFalse((boolean)sFileSystem.getStatus((AlluxioURI)files.get(i)).isPersisted());
        }
        return files;
    }

    public void persistParallel(int totalFiles, int parallelism) throws Exception {
        int fileSize = 30;
        List<AlluxioURI> files = this.createUnpersistedFiles("/testPersistParallel", fileSize, totalFiles);
        int ret = sFsShell.run(new String[]{"persist", "--parallelism", String.valueOf(parallelism), "/*"});
        Assert.assertEquals((long)0L, (long)ret);
        for (AlluxioURI file : files) {
            this.checkFilePersisted(file, fileSize);
        }
    }
}

