/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.WritePType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if this feature is still relevant")
public final class PinCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void setIsPinned() throws Exception {
        AlluxioURI filePath = new AlluxioURI("/testFile");
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertTrue((boolean)this.fileExists(filePath));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"unpin", filePath.toString()}));
        Assert.assertFalse((boolean)sFileSystem.getStatus(filePath).isPinned());
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"pin", filePath.toString()}));
        Assert.assertTrue((boolean)sFileSystem.getStatus(filePath).isPinned());
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"unpin", filePath.toString()}));
        Assert.assertFalse((boolean)sFileSystem.getStatus(filePath).isPinned());
    }

    @Test
    public void setPin() throws Exception {
        AlluxioURI filePathA = new AlluxioURI("/testFileA");
        AlluxioURI filePathB = new AlluxioURI("/testFileB");
        AlluxioURI filePathC = new AlluxioURI("/testFileC");
        int fileSize = 0x800000;
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)filePathA, (WritePType)WritePType.MUST_CACHE, (int)fileSize);
        Assert.assertTrue((boolean)this.fileExists(filePathA));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"pin", filePathA.toString()}));
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)filePathB, (WritePType)WritePType.MUST_CACHE, (int)fileSize);
        Assert.assertTrue((boolean)this.fileExists(filePathB));
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"unpin", filePathB.toString()}));
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)filePathC, (WritePType)WritePType.MUST_CACHE, (int)fileSize);
        Assert.assertTrue((boolean)this.fileExists(filePathC));
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(filePathA).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)sFileSystem.getStatus(filePathB).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)sFileSystem.getStatus(filePathC).getInAlluxioPercentage());
    }
}

