/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fs.FileSystemShell;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import alluxio.job.wire.Status;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import com.google.common.io.Files;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="Multiple media is no longer supported")
public final class PinCommandMultipleMediaIntegrationTest
extends BaseIntegrationTest {
    private static final int SIZE_BYTES = 0x1000000;
    private static LocalAlluxioJobCluster sJobCluster;
    private static WaitForOptions sWaitOptions;
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource;
    @Rule
    public TestRule mResetRule = sLocalAlluxioClusterResource.getResetResource();

    @BeforeClass
    public static void beforeClass() throws Exception {
        sJobCluster = new LocalAlluxioJobCluster();
        sJobCluster.start();
    }

    @Before
    public void beforeTest() throws Exception {
        sJobCluster.stop();
        sJobCluster.start();
    }

    @Test
    public void setPinToSpecificMedia() throws Exception {
        FileSystem fileSystem = sLocalAlluxioClusterResource.get().getClient();
        FileSystemShell fsShell = new FileSystemShell(Configuration.global());
        AlluxioURI filePathA = new AlluxioURI("/testFileA");
        AlluxioURI filePathB = new AlluxioURI("/testFileB");
        int fileSize = 0x800000;
        FileSystemTestUtils.createByteFile((FileSystem)fileSystem, (AlluxioURI)filePathA, (WritePType)WritePType.CACHE_THROUGH, (int)fileSize);
        Assert.assertTrue((boolean)fileSystem.exists(filePathA));
        Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"pin", filePathA.toString(), "SSD"}));
        CommonUtils.waitFor((String)"File being moved", () -> sJobCluster.getMaster().getJobMaster().listDetailed().stream().anyMatch(x -> x.getName().equals("Move") && x.getStatus().equals((Object)Status.COMPLETED) && x.getAffectedPaths().contains(filePathA.getPath())), (WaitForOptions)sWaitOptions);
        Assert.assertTrue((boolean)((FileBlockInfo)fileSystem.getStatus(filePathA).getFileBlockInfos().get(0)).getBlockInfo().getLocations().stream().anyMatch(x -> x.getMediumType().equals("SSD")));
        Assert.assertEquals((long)-1L, (long)fsShell.run(new String[]{"pin", filePathB.toString(), "NVRAM"}));
    }

    private static boolean fileExists(FileSystem fs, AlluxioURI path) {
        try {
            return fs.exists(path);
        }
        catch (IOException e) {
            return false;
        }
        catch (AlluxioException e) {
            return false;
        }
    }

    @Test
    public void pinToMediumForceEviction() throws Exception {
        FileSystem fileSystem = sLocalAlluxioClusterResource.get().getClient();
        FileSystemShell fsShell = new FileSystemShell(Configuration.global());
        AlluxioURI filePathA = new AlluxioURI("/testFileA");
        AlluxioURI dirPath = new AlluxioURI("/testDirA");
        AlluxioURI filePathB = new AlluxioURI(dirPath.getPath() + "/testFileB");
        AlluxioURI filePathC = new AlluxioURI("/testFileC");
        int fileSize = 0x800000;
        FileSystemTestUtils.createByteFile((FileSystem)fileSystem, (AlluxioURI)filePathA, (WritePType)WritePType.CACHE_THROUGH, (int)fileSize);
        Assert.assertTrue((boolean)PinCommandMultipleMediaIntegrationTest.fileExists(fileSystem, filePathA));
        Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"pin", filePathA.toString(), "MEM"}));
        URIStatus status = fileSystem.getStatus(filePathA);
        Assert.assertTrue((boolean)status.isPinned());
        Assert.assertTrue((boolean)status.getPinnedMediumTypes().contains("MEM"));
        fileSystem.createDirectory(dirPath);
        Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"pin", dirPath.toString(), "MEM"}));
        FileSystemTestUtils.createByteFile((FileSystem)fileSystem, (AlluxioURI)filePathB, (WritePType)WritePType.CACHE_THROUGH, (int)fileSize);
        Assert.assertTrue((boolean)PinCommandMultipleMediaIntegrationTest.fileExists(fileSystem, filePathB));
        URIStatus statusB = fileSystem.getStatus(filePathB);
        Assert.assertTrue((boolean)statusB.isPinned());
        Assert.assertTrue((boolean)statusB.getPinnedMediumTypes().contains("MEM"));
        FileSystemTestUtils.createByteFile((FileSystem)fileSystem, (AlluxioURI)filePathC, (WritePType)WritePType.THROUGH, (int)fileSize);
        Assert.assertEquals((long)100L, (long)fileSystem.getStatus(filePathA).getInAlluxioPercentage());
        Assert.assertEquals((long)100L, (long)fileSystem.getStatus(filePathB).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)fileSystem.getStatus(filePathC).getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"pin", filePathC.toString(), "SSD"}));
        CommonUtils.waitFor((String)"File being loaded", () -> sJobCluster.getMaster().getJobMaster().listDetailed().stream().anyMatch(x -> x.getStatus().equals((Object)Status.COMPLETED) && x.getName().equals("Replicate") && x.getAffectedPaths().contains(filePathC.getPath())), (WaitForOptions)sWaitOptions);
        Assert.assertEquals((long)100L, (long)fileSystem.getStatus(filePathC).getInAlluxioPercentage());
        Assert.assertEquals((Object)"MEM", (Object)((BlockLocation)((FileBlockInfo)fileSystem.getStatus(filePathA).getFileBlockInfos().get(0)).getBlockInfo().getLocations().get(0)).getMediumType());
        Assert.assertEquals((Object)"MEM", (Object)((BlockLocation)((FileBlockInfo)fileSystem.getStatus(filePathB).getFileBlockInfos().get(0)).getBlockInfo().getLocations().get(0)).getMediumType());
        Assert.assertEquals((Object)"SSD", (Object)((BlockLocation)((FileBlockInfo)fileSystem.getStatus(filePathC).getFileBlockInfos().get(0)).getBlockInfo().getLocations().get(0)).getMediumType());
        Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"unpin", filePathA.toString()}));
        Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"pin", filePathC.toString(), "MEM"}));
        status = fileSystem.getStatus(filePathA);
        Assert.assertFalse((boolean)status.isPinned());
        Assert.assertTrue((boolean)status.getPinnedMediumTypes().isEmpty());
        CommonUtils.waitFor((String)"File being moved", () -> sJobCluster.getMaster().getJobMaster().listDetailed().stream().anyMatch(x -> x.getStatus().equals((Object)Status.COMPLETED) && x.getName().equals("Move") && x.getAffectedPaths().contains(filePathC.getPath())), (WaitForOptions)sWaitOptions);
        Assert.assertEquals((long)0L, (long)fileSystem.getStatus(filePathA).getInAlluxioPercentage());
        Assert.assertEquals((Object)"MEM", (Object)((BlockLocation)((FileBlockInfo)fileSystem.getStatus(filePathC).getFileBlockInfos().get(0)).getBlockInfo().getLocations().get(0)).getMediumType());
    }

    static {
        sWaitOptions = WaitForOptions.defaults().setTimeoutMs(60000L).setInterval(1000);
        sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_PERSISTENCE_CHECKER_INTERVAL_MS, "10ms").setProperty(PropertyKey.MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS, "10ms").setProperty(PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL, "200ms").setProperty(PropertyKey.WORKER_RAMDISK_SIZE, 0x1000000).setProperty(PropertyKey.WORKER_MANAGEMENT_TIER_ALIGN_ENABLED, false).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 0x1000000).setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, Long.MAX_VALUE).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).setProperty(PropertyKey.USER_FILE_RESERVED_BYTES, 0x800000).setProperty(PropertyKey.MASTER_REPLICATION_CHECK_INTERVAL_MS, "500ms").setProperty(PropertyKey.WORKER_TIERED_STORE_LEVELS, 2).setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(new Object[]{1}), "SSD").setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{0}), Files.createTempDir().getAbsolutePath()).setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{1}), Files.createTempDir().getAbsolutePath() + "," + Files.createTempDir().getAbsolutePath()).setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA.format(new Object[]{0}), String.valueOf(0x1000000)).setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA.format(new Object[]{1}), "16777216,16777216").setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE.format(new Object[]{0}), "MEM").setProperty(PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE.format(new Object[]{1}), "SSD,SSD").build();
    }
}

