/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import alluxio.security.user.TestUserState;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.security.authorization.permission.enabled", "true", "alluxio.security.authentication.type", "SIMPLE", "alluxio.security.group.mapping.class", "alluxio.security.group.provider.IdentityUserGroupsMapping", "alluxio.security.authorization.permission.supergroup", "setfacl_test_user"})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if this feature will be supported")
public final class SetFaclCommandIntegrationTest
extends AbstractFileSystemShellTest {
    private static final List<String> FACL_STRING_ENTRIES = Arrays.asList("user::rw-", "group::r--", "other::r--");
    private static final List<String> DIR_FACL_STRING_ENTRIES = Arrays.asList("user::rwx", "group::r-x", "other::r-x");
    private static final List<String> FILE_FACL_STRING_ENTRIES = Arrays.asList("user::rw-", "group::r-x", "other::r--");
    private static final List<String> DEFAULT_FACL_STRING_ENTRIES = Arrays.asList("default:user::rwx", "default:group::r-x", "default:other::r-x");

    @Test
    public void setfacl() throws Exception {
        String testOwner = "setfacl_test_user";
        String expected = "";
        URIStatus[] files = this.createFiles(testOwner);
        sFsShell.run(new String[]{"setfacl", "-m", "user:testuser:rwx", "/testRoot/testFileA"});
        sFsShell.run(new String[]{"getfacl", "/testRoot/testFileA"});
        ArrayList<String> stringEntries = new ArrayList<String>(FACL_STRING_ENTRIES);
        stringEntries.add("user:testuser:rwx");
        stringEntries.add("mask::rwx");
        expected = expected + this.getFaclResultStr(testOwner, testOwner, "/testRoot/testFileA", stringEntries);
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        sFsShell.run(new String[]{"setfacl", "-m", "user::rwx", "/testRoot/testFileC"});
        sFsShell.run(new String[]{"getfacl", "/testRoot/testFileC"});
        stringEntries = new ArrayList<String>(FACL_STRING_ENTRIES);
        stringEntries.set(0, "user::rwx");
        expected = expected + this.getFaclResultStr(testOwner, testOwner, "/testRoot/testFileC", stringEntries);
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void setDefaultFacl() throws Exception {
        String testOwner = "setfacl_test_user";
        URIStatus[] files = this.createFiles(testOwner);
        sFsShell.run(new String[]{"setfacl", "-m", "default:user:testuser:rwx", "/testRoot/testDir"});
        sFsShell.run(new String[]{"getfacl", "/testRoot/testDir"});
        ArrayList<String> stringEntries = new ArrayList<String>(DIR_FACL_STRING_ENTRIES);
        stringEntries.addAll(DEFAULT_FACL_STRING_ENTRIES);
        stringEntries.add("default:user:testuser:rwx");
        stringEntries.add("default:mask::rwx");
        String expected = this.getFaclResultStr(testOwner, testOwner, "/testRoot/testDir", stringEntries);
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testDir/testDir2/testFileD", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"getfacl", "/testRoot/testDir/testDir2"});
        stringEntries = new ArrayList<String>(DIR_FACL_STRING_ENTRIES);
        stringEntries.add("user:testuser:rwx");
        stringEntries.add("mask::r-x");
        stringEntries.addAll(DEFAULT_FACL_STRING_ENTRIES);
        stringEntries.add("default:user:testuser:rwx");
        stringEntries.add("default:mask::rwx");
        expected = expected + this.getFaclResultStr(testOwner, testOwner, "/testRoot/testDir/testDir2", stringEntries);
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        sFsShell.run(new String[]{"getfacl", "/testRoot/testDir/testDir2/testFileD"});
        stringEntries = new ArrayList<String>(FILE_FACL_STRING_ENTRIES);
        stringEntries.add("user:testuser:rwx");
        stringEntries.add("mask::r--");
        expected = expected + this.getFaclResultStr(testOwner, testOwner, "/testRoot/testDir/testDir2/testFileD", stringEntries);
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    private String getFaclResultStr(String testUser, String testGroup, String fileName, List<String> perms) {
        StringBuilder sb = new StringBuilder();
        sb.append("# file: ");
        sb.append(fileName);
        sb.append("\n# owner: ");
        sb.append(testUser);
        sb.append("\n# group: ");
        sb.append(testGroup);
        sb.append("\n");
        for (String perm : perms) {
            sb.append(perm);
            sb.append("\n");
        }
        return sb.toString();
    }

    private URIStatus[] createFiles(String user) throws IOException, AlluxioException {
        FileSystem fs = sFileSystem;
        if (user != null) {
            fs = sLocalAlluxioCluster.getClient(FileSystemContext.create((Subject)new TestUserState(user, Configuration.global()).getSubject(), (AlluxioConfiguration)Configuration.global()));
        }
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileA", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testDir/testFileB", (WritePType)WritePType.MUST_CACHE, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileC", (WritePType)WritePType.THROUGH, (int)30);
        URIStatus[] files = new URIStatus[]{fs.getStatus(new AlluxioURI("/testRoot/testFileA")), fs.getStatus(new AlluxioURI("/testRoot/testDir")), fs.getStatus(new AlluxioURI("/testRoot/testDir/testFileB")), fs.getStatus(new AlluxioURI("/testRoot/testFileC"))};
        return files;
    }
}

