/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix TTL command tests")
public final class SetTtlCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void setTtl() throws Exception {
        long[] ttls;
        String filePath = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertEquals((long)-1L, (long)sFileSystem.getStatus(new AlluxioURI("/testFile")).getTtl());
        AlluxioURI uri = new AlluxioURI("/testFile");
        for (long ttl : ttls = new long[]{0L, 1000L}) {
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"setTtl", filePath, String.valueOf(ttl)}));
            URIStatus status = sFileSystem.getStatus(uri);
            Assert.assertEquals((long)ttl, (long)status.getTtl());
            Assert.assertEquals((Object)TtlAction.DELETE, (Object)status.getTtlAction());
        }
    }

    @Test
    public void setTtlWithDelete() throws Exception {
        String filePath = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertEquals((long)-1L, (long)sFileSystem.getStatus(new AlluxioURI("/testFile")).getTtl());
        AlluxioURI uri = new AlluxioURI("/testFile");
        long ttl = 1000L;
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"setTtl", "-action", "delete", filePath, String.valueOf(ttl)}));
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertEquals((long)ttl, (long)status.getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)status.getTtlAction());
    }

    @Test
    public void setTtlWithFree() throws Exception {
        String filePath = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertEquals((long)-1L, (long)sFileSystem.getStatus(new AlluxioURI("/testFile")).getTtl());
        AlluxioURI uri = new AlluxioURI("/testFile");
        long ttl = 1000L;
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"setTtl", "-action", "free", filePath, String.valueOf(ttl)}));
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertEquals((long)ttl, (long)status.getTtl());
        Assert.assertEquals((Object)TtlAction.FREE, (Object)status.getTtlAction());
    }

    @Test
    public void setTtlSameTimeDifferentAction() throws Exception {
        String filePath = "/testFile";
        AlluxioURI uri = new AlluxioURI("/testFile");
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        long ttl = 1000L;
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"setTtl", "-action", "delete", filePath, String.valueOf(ttl)}));
        Assert.assertEquals((long)ttl, (long)sFileSystem.getStatus(uri).getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)sFileSystem.getStatus(uri).getTtlAction());
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"setTtl", "-action", "free", filePath, String.valueOf(ttl)}));
        Assert.assertEquals((long)ttl, (long)sFileSystem.getStatus(uri).getTtl());
        Assert.assertEquals((Object)TtlAction.FREE, (Object)sFileSystem.getStatus(uri).getTtlAction());
    }

    @Test
    public void setTtlWithNoOperationValue() throws Exception {
        String filePath = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertEquals((long)-1L, (long)sFileSystem.getStatus(new AlluxioURI("/testFile")).getTtl());
        long ttl = 1000L;
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"setTtl", "-action", filePath, String.valueOf(ttl)}));
    }

    @Test
    public void setTtlWithInvalidOperationValue() throws Exception {
        String filePath = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertEquals((long)-1L, (long)sFileSystem.getStatus(new AlluxioURI("/testFile")).getTtl());
        long ttl = 1000L;
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"setTtl", "-action", "invalid", filePath, String.valueOf(ttl)}));
    }

    @Test
    public void setTtlWithDifferentUnitTime() throws Exception {
        String filePath = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)filePath, (WritePType)WritePType.MUST_CACHE, (int)1);
        Assert.assertEquals((long)-1L, (long)sFileSystem.getStatus(new AlluxioURI("/testFile")).getTtl());
        AlluxioURI uri = new AlluxioURI("/testFile");
        HashMap<String, Long> timeUnits = new HashMap<String, Long>();
        timeUnits.put("", 1L);
        timeUnits.put("ms", 1L);
        timeUnits.put("millisecond", 1L);
        timeUnits.put("s", 1000L);
        timeUnits.put("sec", 1000L);
        timeUnits.put("second", 1000L);
        timeUnits.put("m", 60000L);
        timeUnits.put("min", 60000L);
        timeUnits.put("minute", 60000L);
        timeUnits.put("h", 3600000L);
        timeUnits.put("hour", 3600000L);
        timeUnits.put("d", 86400000L);
        timeUnits.put("day", 86400000L);
        long numericValue = 100L;
        for (Map.Entry entry : timeUnits.entrySet()) {
            String timeUnit = (String)entry.getKey();
            long timeUnitInMilliSeconds = (Long)entry.getValue();
            String testValueWithTimeUnit = String.valueOf(numericValue) + timeUnit;
            Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"setTtl", filePath, testValueWithTimeUnit}));
            URIStatus status = sFileSystem.getStatus(uri);
            Assert.assertEquals((long)(numericValue * timeUnitInMilliSeconds), (long)status.getTtl());
            Assert.assertEquals((Object)TtlAction.DELETE, (Object)status.getTtlAction());
        }
    }

    @Test
    public void setTtlWithInvalidTime() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)1);
        sFsShell.run(new String[]{"setTtl", "/testFile", "some-random-text"});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("is not valid time"));
    }
}

