/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.WritePType;
import alluxio.util.io.BufferUtils;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="fix tail command")
public final class TailCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void tailEmptyFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/emptyFile", (WritePType)WritePType.MUST_CACHE, (int)0);
        int ret = sFsShell.run(new String[]{"tail", "/emptyFile"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void tailLargeFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)2048);
        sFsShell.run(new String[]{"tail", "/testFile"});
        byte[] expect = BufferUtils.getIncreasingByteArray((int)1024, (int)1024);
        Assert.assertArrayEquals((byte[])expect, (byte[])this.mOutput.toByteArray());
    }

    @Test
    public void tailNotExist() throws IOException {
        int ret = sFsShell.run(new String[]{"tail", "/testFile"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void tailSmallFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"tail", "/testFile"});
        byte[] expect = BufferUtils.getIncreasingByteArray((int)10);
        Assert.assertArrayEquals((byte[])expect, (byte[])this.mOutput.toByteArray());
    }

    @Test
    public void tailWildcard() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        byte[] exp1 = BufferUtils.getIncreasingByteArray((int)30);
        byte[] exp2 = BufferUtils.getIncreasingByteArray((int)10);
        byte[] exp3 = BufferUtils.getIncreasingByteArray((int)20);
        byte[] expect = new byte[exp1.length + exp2.length + exp3.length];
        System.arraycopy(exp1, 0, expect, 0, exp1.length);
        System.arraycopy(exp2, 0, expect, exp1.length, exp2.length);
        System.arraycopy(exp3, 0, expect, exp1.length + exp2.length, exp3.length);
        int ret = sFsShell.run(new String[]{"tail", testDir + "/*/foo*"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertArrayEquals((byte[])this.mOutput.toByteArray(), (byte[])expect);
    }

    @Test
    public void tailFileWithUserSpecifiedBytes() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)2048);
        sFsShell.run(new String[]{"tail", "-c", "2000", "/testFile"});
        byte[] expect = BufferUtils.getIncreasingByteArray((int)48, (int)2000);
        Assert.assertArrayEquals((byte[])expect, (byte[])this.mOutput.toByteArray());
    }

    @Test
    public void tailFileWithUserSpecifiedBytesWithUnit() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10000);
        sFsShell.run(new String[]{"tail", "-c", "2KB", "/testFile"});
        byte[] expect = BufferUtils.getIncreasingByteArray((int)7952, (int)2048);
        Assert.assertArrayEquals((byte[])expect, (byte[])this.mOutput.toByteArray());
    }
}

