/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.WritePType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="fix the @Ignore tests")
public final class TestCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void testPathIsDirectoryWhenPathNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"test", "-d", "/testPath"});
        Assert.assertEquals((long)3L, (long)ret);
    }

    @Test
    public void testPathIsDirectoryWhenPathIsDirectory() throws Exception {
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"test", "-d", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    @Ignore
    public void testPathIsDirectoryWhenPathIsFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"test", "-d", "/testFile"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testPathIsFileWhenPathNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"test", "-f", "/testPath"});
        Assert.assertEquals((long)3L, (long)ret);
    }

    @Test
    public void testPathIsFileWhenPathIsDirectory() throws Exception {
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"test", "-f", "/testDir"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    @Ignore
    public void testPathIsFileWhenPathIsFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"test", "-f", "/testFile"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void testPathExistWhenPathNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"test", "-e", "/testPath"});
        Assert.assertEquals((long)3L, (long)ret);
    }

    @Test
    public void testPathExistWhenPathIsDirectory() throws Exception {
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"test", "-e", "/testDir"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    @Ignore
    public void testPathExistWhenPathIsFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"test", "-e", "/testFile"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void testDirNotEmptyWhenPathNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"test", "-s", "/testPath"});
        Assert.assertEquals((long)3L, (long)ret);
    }

    @Test
    @Ignore
    public void testDirNotEmptyWhenPathIsDirectory() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir1/testFile1", (WritePType)WritePType.MUST_CACHE, (int)0);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir2/testFile2", (WritePType)WritePType.MUST_CACHE, (int)10);
        String[] command = new String[]{"mkdir", "/testDir3/testDir4"};
        sFsShell.run(command);
        int ret = sFsShell.run(new String[]{"test", "-s", "/testDir1"});
        Assert.assertEquals((long)0L, (long)ret);
        ret = sFsShell.run(new String[]{"test", "-s", "/testDir2"});
        Assert.assertEquals((long)0L, (long)ret);
        ret = sFsShell.run(new String[]{"test", "-s", "/testDir3"});
        Assert.assertEquals((long)0L, (long)ret);
        ret = sFsShell.run(new String[]{"test", "-s", "/testDir3/testDir4"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testDirNotEmptyWhenPathIsFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile1", (WritePType)WritePType.MUST_CACHE, (int)0);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile2", (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"test", "-s", "/testFile1"});
        Assert.assertEquals((long)1L, (long)ret);
        ret = sFsShell.run(new String[]{"test", "-s", "/testFile2"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testFileZeroLengthWhenPathNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"test", "-z", "/testPath"});
        Assert.assertEquals((long)3L, (long)ret);
    }

    @Test
    public void testFileZeroLengthWhenPathIsDirectory() throws Exception {
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"test", "-z", "/testDir"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    @Ignore
    public void testFileZeroLengthWhenPathIsFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile1", (WritePType)WritePType.MUST_CACHE, (int)0);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile2", (WritePType)WritePType.MUST_CACHE, (int)10);
        int ret = sFsShell.run(new String[]{"test", "-z", "/testFile1"});
        Assert.assertEquals((long)0L, (long)ret);
        ret = sFsShell.run(new String[]{"test", "-z", "/testFile2"});
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testWithoutOption() throws Exception {
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"test", "/testDir"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void testWrongOption() throws Exception {
        sFileSystem.createDirectory(new AlluxioURI("/testDir"));
        int ret = sFsShell.run(new String[]{"test", "-dfesz", "/testDir"});
        Assert.assertEquals((long)-1L, (long)ret);
    }
}

