/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin;

import alluxio.AlluxioTestDirectory;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.master.backup.directory", "${alluxio.work.dir}/backups", "alluxio.master.shell.backup.state.lock.try.duration", "3s", "alluxio.master.shell.backup.state.lock.timeout", "3s"})
public final class BackupCommandIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void defaultDirectory() throws IOException {
        Path dir = Paths.get(Configuration.getString((PropertyKey)PropertyKey.MASTER_BACKUP_DIRECTORY), new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        Assert.assertEquals((long)0L, (long)Files.list(dir).count());
        int errCode = this.mFsAdminShell.run(new String[]{"backup"});
        Assert.assertEquals((Object)"", (Object)this.mErrOutput.toString());
        Assert.assertEquals((long)0L, (long)errCode);
        Assert.assertEquals((long)2L, (long)Files.list(dir).count());
    }

    @Test
    public void specificDirectory() throws IOException {
        Path dir = AlluxioTestDirectory.createTemporaryDirectory((String)"test-backup").toPath();
        Files.createDirectories(dir, new FileAttribute[0]);
        Assert.assertEquals((long)0L, (long)Files.list(dir).count());
        int errCode = this.mFsAdminShell.run(new String[]{"backup", dir.toAbsolutePath().toString()});
        Assert.assertEquals((Object)"", (Object)this.mErrOutput.toString());
        Assert.assertEquals((long)0L, (long)errCode);
        Assert.assertEquals((long)2L, (long)Files.list(dir).count());
    }
}

