/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fsadmin.report.CapacityCommand;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import alluxio.util.FormatUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="rework on the register logic")
public final class CapacityCommandIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void allCapacity() {
        int ret = this.mFsAdminShell.run(new String[]{"report", "capacity"});
        Assert.assertEquals((long)0L, (long)ret);
        String output = this.mOutput.toString();
        String size = FormatUtils.getSizeFromBytes((long)0x1000000L);
        String[] lines = output.split("\n");
        Assert.assertEquals((long)11L, (long)lines.length);
        Assert.assertEquals((Object)"Capacity information for all workers: ", (Object)lines[0]);
        Assert.assertEquals((Object)("    Total Capacity: " + size), (Object)lines[1]);
        Assert.assertEquals((Object)("        Tier: MEM  Size: " + size), (Object)lines[2]);
        Assert.assertEquals((Object)"    Used Capacity: 0B", (Object)lines[3]);
        Assert.assertEquals((Object)"        Tier: MEM  Size: 0B", (Object)lines[4]);
        Assert.assertEquals((Object)"    Used Percentage: 0%", (Object)lines[5]);
        Assert.assertEquals((Object)"    Free Percentage: 100%", (Object)lines[6]);
        Assert.assertEquals((Object)"", (Object)lines[7]);
        Assert.assertTrue((boolean)lines[8].matches("Worker Name {6,}State {11,}Last Heartbeat {3}Storage {7}MEM {14}Version {10}Revision *"));
        Assert.assertTrue((boolean)lines[9].contains("ACTIVE"));
        Assert.assertTrue((boolean)lines[9].contains("capacity      " + size));
        Assert.assertTrue((boolean)lines[10].contains("used          0B (0%)"));
    }

    @Test
    public void lostCapacity() {
        int ret = this.mFsAdminShell.run(new String[]{"report", "capacity", "-lost"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertEquals((Object)this.mOutput.toString(), (Object)"No workers found.\n");
    }

    @Test
    public void liveCapacity() {
        int ret = this.mFsAdminShell.run(new String[]{"report", "capacity", "-live"});
        Assert.assertEquals((long)0L, (long)ret);
        String output = this.mOutput.toString();
        String size = FormatUtils.getSizeFromBytes((long)0x1000000L);
        String[] lines = output.split("\n");
        Assert.assertEquals((long)11L, (long)lines.length);
        Assert.assertEquals((Object)"Capacity information for live workers: ", (Object)lines[0]);
        Assert.assertEquals((Object)("    Total Capacity: " + size), (Object)lines[1]);
        Assert.assertEquals((Object)("        Tier: MEM  Size: " + size), (Object)lines[2]);
        Assert.assertEquals((Object)"    Used Capacity: 0B", (Object)lines[3]);
        Assert.assertEquals((Object)"        Tier: MEM  Size: 0B", (Object)lines[4]);
        Assert.assertEquals((Object)"    Used Percentage: 0%", (Object)lines[5]);
        Assert.assertEquals((Object)"    Free Percentage: 100%", (Object)lines[6]);
        Assert.assertEquals((Object)"", (Object)lines[7]);
        Assert.assertTrue((boolean)lines[8].matches("Worker Name {6,}State {11,}Last Heartbeat {3}Storage {7}MEM {14}Version {10}Revision *"));
        Assert.assertTrue((boolean)lines[9].contains("ACTIVE"));
        Assert.assertTrue((boolean)lines[9].contains("capacity      " + size));
        Assert.assertTrue((boolean)lines[10].contains("used          0B (0%)"));
    }

    @Test
    public void tooManyOptions() {
        this.mFsAdminShell.run(new String[]{"report", "capacity", "-live", "-lost"});
        String expected = CapacityCommand.getUsage() + "\nToo many arguments passed in.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }
}

