/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.cli.fsadmin.command.DoctorCommand;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import org.junit.Assert;
import org.junit.Test;

public final class DoctorCommandIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void masterNotRunning() throws Exception {
        this.mLocalAlluxioCluster.stopMasters();
        int ret = this.mFsAdminShell.run(new String[]{"doctor"});
        Assert.assertNotEquals((long)0L, (long)ret);
    }

    @Test
    public void doctorCategoryInvalid() {
        this.mFsAdminShell.run(new String[]{"doctor", "invalidCategory"});
        String expected = String.join((CharSequence)"\n", DoctorCommand.usage(), DoctorCommand.description(), "doctor category is invalid.") + "\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void doctorConfiguration() {
        int ret = this.mFsAdminShell.run(new String[]{"doctor", "configuration"});
        Assert.assertEquals((long)0L, (long)ret);
        String expected = "No server-side configuration errors or warnings.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void doctorStorage() {
        int ret = this.mFsAdminShell.run(new String[]{"doctor", "storage"});
        Assert.assertEquals((long)0L, (long)ret);
        String expected = "All worker storage paths are in working state.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }
}

