/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import alluxio.master.block.BlockId;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="bowen", comment="Block API will be deprecated and replaced by a Page API")
public final class GetBlockInfoCommandIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void invalidId() {
        String invalidId = "invalidId";
        int ret = this.mFsAdminShell.run(new String[]{"getBlockInfo", invalidId});
        Assert.assertEquals((long)-1L, (long)ret);
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)(invalidId + " is not a valid block id.")));
    }

    @Test
    public void blockMetaNotFound() {
        long invalidId = 1421312312L;
        int ret = this.mFsAdminShell.run(new String[]{"getBlockInfo", String.valueOf(invalidId)});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)"BlockMeta is not available for blockId"));
        Assert.assertThat((Object)this.mOutput.toString(), (Matcher)CoreMatchers.containsString((String)"This block belongs to file"));
    }

    @Test
    public void getBlockInfo() throws IOException, AlluxioException {
        FileSystem fileSystem = this.mLocalAlluxioCluster.getClient();
        fileSystem.createDirectory(new AlluxioURI("/foo"));
        FileSystemTestUtils.createByteFile((FileSystem)fileSystem, (String)"/foo/foobar1", (WritePType)WritePType.MUST_CACHE, (int)10);
        long blockId = (Long)((URIStatus)fileSystem.listStatus(new AlluxioURI("/foo/foobar1")).get(0)).getBlockIds().get(0);
        int ret = this.mFsAdminShell.run(new String[]{"getBlockInfo", String.valueOf(blockId)});
        Assert.assertEquals((long)0L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)("BlockInfo{id=" + blockId + ", length=10, locations=[BlockLocation{workerId=")));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)("This block belongs to file {id=" + BlockId.getFileId((long)blockId) + ", path=/foo/foobar1}")));
    }
}

