/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.cli.fsadmin.command.PathConfCommand;
import alluxio.cli.fsadmin.pathconf.AddCommand;
import alluxio.cli.fsadmin.pathconf.ListCommand;
import alluxio.cli.fsadmin.pathconf.RemoveCommand;
import alluxio.cli.fsadmin.pathconf.ShowCommand;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import org.junit.Assert;
import org.junit.Test;

public final class PathConfCommandIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void noArg() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)PathConfCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void unknownSubCommand() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "unknown"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)PathConfCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void addCommandWrongNumberOfArgs() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "add", "1", "2"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)AddCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void addCommandUnknownOption() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "add", "--unknown"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)AddCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void listCommandWrongNumberOfArgs() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "list", "1"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)ListCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void listCommandUnknownOption() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "list", "--unknown"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)ListCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void removeCommandWrongNumberOfArgs() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "remove", "1", "2"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)RemoveCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void removeCommandUnknownOption() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "remove", "--unknown"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)RemoveCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void showCommandWrongNumberOfArgs() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "show", "1", "2"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)ShowCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void showCommandUnknownOption() {
        int ret = this.mFsAdminShell.run(new String[]{"pathConf", "show", "--unknown"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)ShowCommand.description(), (Object)this.lastLine(output));
    }

    private String lastLine(String output) {
        String[] lines = output.split("\n");
        if (lines.length > 0) {
            return lines[lines.length - 1];
        }
        return "";
    }
}

