/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.AlluxioURI;
import alluxio.ConfigurationRule;
import alluxio.SystemErrRule;
import alluxio.SystemOutRule;
import alluxio.cli.fsadmin.FileSystemAdminShell;
import alluxio.cli.fsadmin.journal.QuorumCommand;
import alluxio.cli.fsadmin.journal.QuorumElectCommand;
import alluxio.cli.fsadmin.journal.QuorumInfoCommand;
import alluxio.cli.fsadmin.journal.QuorumRemoveCommand;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.JournalDomain;
import alluxio.grpc.QuorumServerInfo;
import alluxio.grpc.QuorumServerState;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class QuorumCommandIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public ConfigurationRule mConf = new ConfigurationRule(PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false, Configuration.modifiableGlobal());
    public MultiProcessCluster mCluster;
    public ByteArrayOutputStream mOutput = new ByteArrayOutputStream();
    public ByteArrayOutputStream mErrOutput = new ByteArrayOutputStream();
    @Rule
    public ExpectedException mException = ExpectedException.none();
    @Rule
    public SystemOutRule mOutRule = new SystemOutRule((OutputStream)this.mOutput);
    @Rule
    public SystemErrRule mErrRule = new SystemErrRule((OutputStream)this.mErrOutput);

    @After
    public void after() throws Exception {
        if (this.mCluster != null) {
            this.mCluster.destroy();
        }
    }

    @Test
    public void quorumInfo() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.QUORUM_SHELL_INFO).setClusterName("QuorumShellInfo").setNumMasters(3).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "info", "-domain", "MASTER"});
            String output = this.mOutput.toString().trim();
            Assert.assertTrue((boolean)output.contains(String.format("Journal domain\t: %s", JournalDomain.MASTER.name())));
            Assert.assertTrue((boolean)output.contains(String.format("Quorum size\t: %d", 3)));
            List journalAddresses = Configuration.getList((PropertyKey)PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES);
            for (String address : journalAddresses) {
                String format = String.format("%-11s | %-8s | %s%n", QuorumServerState.AVAILABLE.name(), "0", address).trim();
                Assert.assertTrue((boolean)output.contains(format));
            }
            this.mCluster.stopMaster(0);
            CommonUtils.waitFor((String)"Quorum noticing change.", () -> {
                this.mOutput.reset();
                shell.run(new String[]{"journal", "quorum", "info", "-domain", "MASTER"});
                return this.mOutput.toString().trim().contains(QuorumServerState.UNAVAILABLE.name());
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)(2 * (int)Configuration.getMs((PropertyKey)PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT))));
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void quorumRemove() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.QUORUM_SHELL_REMOVE).setClusterName("QuorumShellRemove").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            AlluxioURI testDir = new AlluxioURI("/testDir");
            this.mCluster.getFileSystemClient().createDirectory(testDir);
            Assert.assertTrue((boolean)this.mCluster.getFileSystemClient().exists(testDir));
            this.mCluster.stopMaster(0);
            this.mCluster.stopMaster(1);
            Assert.assertTrue((boolean)this.mCluster.getFileSystemClient().exists(testDir));
            CommonUtils.waitFor((String)"Quorum noticing change.", () -> {
                try {
                    return this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().stream().filter(info -> info.getServerState() == QuorumServerState.UNAVAILABLE).collect(Collectors.toList()).size() == 2;
                }
                catch (Exception e) {
                    return false;
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)(6 * (int)Configuration.getMs((PropertyKey)PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT))));
            for (QuorumServerInfo serverInfo : this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList()) {
                if (serverInfo.getServerState() != QuorumServerState.UNAVAILABLE) continue;
                this.mOutput.reset();
                String serverAddress = String.format("%s:%d", serverInfo.getServerAddress().getHost(), serverInfo.getServerAddress().getRpcPort());
                shell.run(new String[]{"journal", "quorum", "remove", "-domain", "MASTER", "-address", serverAddress});
                String output = this.mOutput.toString().trim();
                Assert.assertEquals((Object)String.format("Removed server at: %s from quorum: %s", serverAddress, JournalDomain.MASTER.name()), (Object)this.lastLine(output));
            }
            Assert.assertEquals((long)3L, (long)this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().size());
            this.mCluster.stopMaster(2);
            Assert.assertTrue((boolean)this.mCluster.getFileSystemClient().exists(testDir));
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void elect() throws Exception {
        int MASTER_INDEX_WAIT_TIME = 5000;
        int numMasters = 3;
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.QUORUM_SHELL_REMOVE).setClusterName("QuorumShellElect").setNumMasters(numMasters).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int newLeaderIdx = (this.mCluster.getPrimaryMasterIndex(5000) + 1) % numMasters;
            MasterNetAddress netAddress = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
            String newLeaderAddr = String.format("%s:%s", netAddress.getHostname(), netAddress.getEmbeddedJournalPort());
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "elect", "-address", newLeaderAddr});
            String output = this.mOutput.toString().trim();
            String expected = String.format("%s\n%s", String.format("Initiating transfer of leadership to %s", newLeaderAddr), String.format("Successfully elected %s as the new leader", newLeaderAddr));
            Assert.assertEquals((Object)expected, (Object)output);
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void infoAfterElect() throws Exception {
        int MASTER_INDEX_WAIT_TIME = 5000;
        int numMasters = 3;
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.QUORUM_SHELL_REMOVE).setClusterName("QuorumShellElect").setNumMasters(numMasters).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int newLeaderIdx = (this.mCluster.getPrimaryMasterIndex(5000) + 1) % numMasters;
            MasterNetAddress netAddress = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
            String newLeaderAddr = String.format("%s:%s", netAddress.getHostname(), netAddress.getEmbeddedJournalPort());
            int success = shell.run(new String[]{"journal", "quorum", "elect", "-address", newLeaderAddr});
            Assert.assertEquals((String)"elect command failed", (long)0L, (long)success);
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "info", "-domain", "MASTER"});
            String output = this.mOutput.toString().trim();
            for (MasterNetAddress masterAddr : this.mCluster.getMasterAddresses()) {
                String expected = String.format("%-11s | %-8s | %s%n", "AVAILABLE", "0", String.format("%s:%d", masterAddr.getHostname(), masterAddr.getEmbeddedJournalPort()));
                Assert.assertTrue((boolean)output.contains(expected.trim()));
            }
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void quorumCommand() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.QUORUM_SHELL).setClusterName("QuorumShell").setNumMasters(3).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "nonexistentCommand"});
            String output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "info"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumInfoCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "info", "-op1", "val1", "-op2", "val2"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumInfoCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "remove"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumRemoveCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "remove", "-op1", "val1"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumRemoveCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "remove", "-op1", "val1", "-op2", "val2", "-op3", "val3"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumRemoveCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "elect"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumElectCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "elect", "-op1", "val1"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumElectCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "elect", "-op1", "val1", "-op2", "val2", "-op3", "val3"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)QuorumElectCommand.description(), (Object)this.lastLine(output));
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "info", "-domain", "UNKNOWN"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)ExceptionMessage.INVALID_OPTION_VALUE.getMessage(new Object[]{"domain", Arrays.toString(JournalDomain.values())}), (Object)output);
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "remove", "-domain", "UNKNOWN", "-address", "host:0"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)ExceptionMessage.INVALID_OPTION_VALUE.getMessage(new Object[]{"domain", Arrays.toString(JournalDomain.values())}), (Object)output);
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "remove", "-domain", "JOB_MASTER", "-address", "hostname:invalid_port"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)ExceptionMessage.INVALID_ADDRESS_VALUE.getMessage(new Object[0]), (Object)output);
            this.mOutput.reset();
            shell.run(new String[]{"journal", "quorum", "elect", "-address", "hostname:invalid_port"});
            output = this.mOutput.toString().trim();
            Assert.assertEquals((Object)ExceptionMessage.INVALID_ADDRESS_VALUE.getMessage(new Object[0]), (Object)output);
        }
        this.mCluster.notifySuccess();
    }

    private String lastLine(String output) {
        String[] lines = output.split("\n");
        if (lines.length > 0) {
            return lines[lines.length - 1];
        }
        return "";
    }
}

