/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.cli.fsadmin.command.ReportCommand;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public final class ReportCommandIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void masterNotRunning() throws Exception {
        this.mLocalAlluxioCluster.stopMasters();
        int ret = this.mFsAdminShell.run(new String[]{"report"});
        Assert.assertNotEquals((long)0L, (long)ret);
    }

    @Test
    public void reportCategoryInvalid() {
        this.mFsAdminShell.run(new String[]{"report", "invalidCategory"});
        String expected = String.join((CharSequence)"\n", ReportCommand.usage(), ReportCommand.description(), "report category is invalid.") + "\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void reportUfs() {
        int ret = this.mFsAdminShell.run(new String[]{"report", "ufs"});
        Assert.assertEquals((long)0L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Alluxio under storage system information:"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"not read-only, not shared, properties={})"));
    }
}

