/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.network.NetworkAddressUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.master.journal.type", "EMBEDDED", "alluxio.master.embedded.journal.port", "0"})
public class ReportEmbeddedJournalIntegrationTest
extends AbstractFsAdminShellTest {
    static final String JOURNAL_PORT = "0";

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="journal no longer exists in dora")
    public void reportSummary() {
        int ret = this.mFsAdminShell.run(new String[]{"report", "summary"});
        Assert.assertEquals((long)0L, (long)ret);
        String output = this.mOutput.toString();
        String expectedMasterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)Configuration.global()).toString();
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)("Master Address: " + expectedMasterAddress)));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)("Web Port: " + Configuration.get((PropertyKey)PropertyKey.MASTER_WEB_PORT))));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)("Rpc Port: " + Configuration.get((PropertyKey)PropertyKey.MASTER_RPC_PORT))));
        Assert.assertFalse((boolean)output.contains("Started: 12-31-1969 16:00:00:000"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Version: 302"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Zookeeper Enabled: false"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Raft-based Journal: true"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Raft Journal Addresses:"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)(this.mLocalAlluxioCluster.getHostname() + ":" + JOURNAL_PORT)));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Live Workers: 1"));
        Assert.assertFalse((boolean)output.contains("Total Capacity: 0B"));
    }
}

