/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.pathconf;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fs.FileSystemShell;
import alluxio.cli.fsadmin.FileSystemAdminShell;
import alluxio.cli.fsadmin.pathconf.AddCommand;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.cli.fs.AbstractShellIntegrationTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.master.file.meta.PersistenceState;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AddCommandIntegrationTest
extends AbstractShellIntegrationTest {
    private static final String PATH1 = "/a/b";
    private static final String PATH2 = "/a/b/c";
    private static final String READ_TYPE_NO_CACHE = AddCommandIntegrationTest.format(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.NO_CACHE);
    private static final String READ_TYPE_CACHE = AddCommandIntegrationTest.format(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.CACHE);
    private static final String WRITE_TYPE_CACHE_THROUGH = AddCommandIntegrationTest.format(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH);
    private static final String WRITE_TYPE_THROUGH = AddCommandIntegrationTest.format(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.THROUGH);

    private static String format(PropertyKey key, Object value) {
        return String.format("%s=%s", key.getName(), value);
    }

    @Test
    public void add() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            ret = shell.run(new String[]{"pathConf", "show", PATH1});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "show", PATH2});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "add", "--property", READ_TYPE_NO_CACHE, "--property", WRITE_TYPE_CACHE_THROUGH, PATH1});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"/a/b\n", (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "add", "--property", WRITE_TYPE_THROUGH, PATH2});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"/a/b\n/a/b/c\n", (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "show", PATH1});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = READ_TYPE_NO_CACHE + "\n" + WRITE_TYPE_CACHE_THROUGH + "\n";
            output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "show", PATH2});
            Assert.assertEquals((long)0L, (long)ret);
            expected = WRITE_TYPE_THROUGH + "\n";
            output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
        }
    }

    @Test
    public void invalidPropertyKey() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "add", "--property", "unknown=value", "/"});
            Assert.assertEquals((long)-1L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"Invalid property key unknown\n", (Object)output);
        }
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="path conf does not exist in dora")
    public void immediatelyEffectiveForShellCommands() throws Exception {
        InstancedConfiguration conf = Configuration.modifiableGlobal();
        try (FileSystemShell fsShell = new FileSystemShell((AlluxioConfiguration)conf);
             FileSystemAdminShell fsAdminShell = new FileSystemAdminShell((AlluxioConfiguration)conf);){
            Assert.assertEquals((long)0L, (long)fsAdminShell.run(new String[]{"pathConf", "add", "--property", WRITE_TYPE_THROUGH, PATH1}));
            Assert.assertEquals((long)0L, (long)fsAdminShell.run(new String[]{"pathConf", "add", "--property", WRITE_TYPE_CACHE_THROUGH, PATH2}));
            FileSystem fs = sLocalAlluxioClusterResource.get().getClient();
            String file = "/file";
            FileSystemTestUtils.createByteFile((FileSystem)fs, (String)file, (int)100, (CreateFilePOptions)CreateFilePOptions.getDefaultInstance());
            fs.createDirectory(new AlluxioURI(PATH1), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
            fs.createDirectory(new AlluxioURI(PATH2), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
            AlluxioURI target = new AlluxioURI(PATH1 + file);
            Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"cp", file, target.toString()}));
            URIStatus status = fs.getStatus(target);
            Assert.assertEquals((long)0L, (long)status.getInMemoryPercentage());
            Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
            target = new AlluxioURI(PATH2 + file);
            Assert.assertEquals((long)0L, (long)fsShell.run(new String[]{"cp", file, target.toString()}));
            status = fs.getStatus(target);
            Assert.assertEquals((long)100L, (long)status.getInMemoryPercentage());
            Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        }
    }

    @Test
    public void addNoProperty() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "add", "/"});
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    @Test
    public void overwriteProperty() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "add", "--property", READ_TYPE_NO_CACHE, "/"});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "show", "/"});
            Assert.assertEquals((long)0L, (long)ret);
            Assert.assertEquals((Object)(READ_TYPE_NO_CACHE + "\n"), (Object)this.mOutput.toString());
            ret = shell.run(new String[]{"pathConf", "add", "--property", READ_TYPE_CACHE, "/"});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "show", "/"});
            Assert.assertEquals((long)0L, (long)ret);
            Assert.assertEquals((Object)(READ_TYPE_CACHE + "\n"), (Object)this.mOutput.toString());
        }
    }

    @Test
    public void nonClientScopeKey() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            PropertyKey key = PropertyKey.NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT;
            int ret = shell.run(new String[]{"pathConf", "add", "--property", AddCommandIntegrationTest.format(key, "10ms"), "/"});
            Assert.assertEquals((long)-1L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)(AddCommand.nonClientScopePropertyException((PropertyKey)key) + "\n"), (Object)output);
        }
    }
}

