/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.pathconf;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.cli.fsadmin.FileSystemAdminShell;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.cli.fs.AbstractShellIntegrationTest;
import alluxio.client.file.FileSystemContext;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class ListCommandIntegrationTest
extends AbstractShellIntegrationTest {
    private static final String DIR1 = "/path/to/dir1";
    private static final PropertyKey PROPERTY_KEY1 = PropertyKey.USER_FILE_READ_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE1 = ReadType.NO_CACHE.toString();
    private static final String DIR2 = "/path/to/dir2";
    private static final PropertyKey PROPERTY_KEY2 = PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE2 = WriteType.THROUGH.toString();

    private InstancedConfiguration setPathConfigurations() throws Exception {
        FileSystemContext metaCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        RetryHandlingMetaMasterConfigClient client = new RetryHandlingMetaMasterConfigClient(MasterClientContext.newBuilder((ClientContext)metaCtx.getClientContext()).build());
        client.setPathConfiguration(new AlluxioURI(DIR1), PROPERTY_KEY1, PROPERTY_VALUE1);
        client.setPathConfiguration(new AlluxioURI(DIR2), PROPERTY_KEY2, PROPERTY_VALUE2);
        InetSocketAddress address = sLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getAddress();
        FileSystemContext fsCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        fsCtx.getClientContext().loadConf(address, true, true);
        return (InstancedConfiguration)fsCtx.getClusterConf();
    }

    @Test
    public void listEmpty() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
        }
    }

    @Test
    public void list() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"/path/to/dir1\n/path/to/dir2\n", (Object)output);
        }
    }
}

