/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.pathconf;

import alluxio.cli.fsadmin.FileSystemAdminShell;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.cli.fs.AbstractShellIntegrationTest;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import org.junit.Assert;
import org.junit.Test;

public class RemoveCommandIntegrationTest
extends AbstractShellIntegrationTest {
    private static final String DIR1 = "/a/b";
    private static final PropertyKey PROPERTY_KEY11 = PropertyKey.USER_FILE_READ_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE11 = ReadType.NO_CACHE.toString();
    private static final PropertyKey PROPERTY_KEY12 = PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE12 = WriteType.MUST_CACHE.toString();
    private static final PropertyKey PROPERTY_KEY13 = PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL;
    private static final String PROPERTY_VALUE13 = "2sec";
    private static final String DIR2 = "/a/b/c";
    private static final PropertyKey PROPERTY_KEY2 = PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE2 = WriteType.THROUGH.toString();

    private String format(PropertyKey key, String value) {
        return key.getName() + "=" + value;
    }

    @Test
    public void remove() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            ret = shell.run(new String[]{"pathConf", "add", "--property", this.format(PROPERTY_KEY11, PROPERTY_VALUE11), "--property", this.format(PROPERTY_KEY12, PROPERTY_VALUE12), DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            ret = shell.run(new String[]{"pathConf", "add", "--property", this.format(PROPERTY_KEY13, PROPERTY_VALUE13), DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            ret = shell.run(new String[]{"pathConf", "add", "--property", this.format(PROPERTY_KEY2, PROPERTY_VALUE2), DIR2});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"/a/b\n/a/b/c\n", (Object)output);
            ret = shell.run(new String[]{"pathConf", "remove", DIR2});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"/a/b\n", (Object)output);
            ret = shell.run(new String[]{"pathConf", "remove", "--keys", PROPERTY_KEY11.getName(), DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "show", DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = this.format(PROPERTY_KEY13, PROPERTY_VALUE13) + "\n" + this.format(PROPERTY_KEY12, PROPERTY_VALUE12) + "\n";
            output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
            ret = shell.run(new String[]{"pathConf", "remove", "--keys", PROPERTY_KEY12.getName() + "," + PROPERTY_KEY13.getName(), DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
        }
    }

    @Test
    public void removeRecursive() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell(Configuration.global());){
            int ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
            ret = shell.run(new String[]{"pathConf", "add", "--property", this.format(PROPERTY_KEY11, PROPERTY_VALUE11), "--property", this.format(PROPERTY_KEY12, PROPERTY_VALUE12), DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            ret = shell.run(new String[]{"pathConf", "add", "--property", this.format(PROPERTY_KEY13, PROPERTY_VALUE13), DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            ret = shell.run(new String[]{"pathConf", "add", "--property", this.format(PROPERTY_KEY2, PROPERTY_VALUE2), DIR2});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"/a/b\n/a/b/c\n", (Object)output);
            ret = shell.run(new String[]{"pathConf", "remove", "-R", "/"});
            Assert.assertEquals((long)0L, (long)ret);
            this.mOutput.reset();
            ret = shell.run(new String[]{"pathConf", "list"});
            Assert.assertEquals((long)0L, (long)ret);
            output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
        }
    }
}

