/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.pathconf;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.cli.fsadmin.FileSystemAdminShell;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.cli.fs.AbstractShellIntegrationTest;
import alluxio.client.file.FileSystemContext;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class ShowCommandIntegrationTest
extends AbstractShellIntegrationTest {
    private static final String DIR0 = "/a";
    private static final String DIR1 = "/a/b";
    private static final PropertyKey PROPERTY_KEY11 = PropertyKey.USER_FILE_READ_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE11 = ReadType.NO_CACHE.toString();
    private static final PropertyKey PROPERTY_KEY12 = PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE12 = WriteType.MUST_CACHE.toString();
    private static final String DIR2 = "/a/b/c";
    private static final PropertyKey PROPERTY_KEY2 = PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT;
    private static final String PROPERTY_VALUE2 = WriteType.THROUGH.toString();
    private static final String DIR3 = "/a/b/c/d";

    private InstancedConfiguration setPathConfigurations() throws Exception {
        FileSystemContext metaCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        RetryHandlingMetaMasterConfigClient client = new RetryHandlingMetaMasterConfigClient(MasterClientContext.newBuilder((ClientContext)metaCtx.getClientContext()).build());
        client.setPathConfiguration(new AlluxioURI(DIR1), PROPERTY_KEY11, PROPERTY_VALUE11);
        client.setPathConfiguration(new AlluxioURI(DIR1), PROPERTY_KEY12, PROPERTY_VALUE12);
        client.setPathConfiguration(new AlluxioURI(DIR2), PROPERTY_KEY2, PROPERTY_VALUE2);
        InetSocketAddress address = sLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getAddress();
        FileSystemContext fsCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        fsCtx.getClientContext().loadConf(address, true, true);
        return (InstancedConfiguration)fsCtx.getClusterConf();
    }

    private String format(PropertyKey key, String value) {
        return key.getName() + "=" + value;
    }

    @Test
    public void showDir0() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", DIR0});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
        }
    }

    @Test
    public void showDir1() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = this.format(PROPERTY_KEY11, PROPERTY_VALUE11) + "\n" + this.format(PROPERTY_KEY12, PROPERTY_VALUE12) + "\n";
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
        }
    }

    @Test
    public void showDir2() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", DIR2});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = this.format(PROPERTY_KEY2, PROPERTY_VALUE2) + "\n";
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
        }
    }

    @Test
    public void showDir3() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", DIR3});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
        }
    }

    @Test
    public void showResolveDir0() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", "--all", DIR0});
            Assert.assertEquals((long)0L, (long)ret);
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)"", (Object)output);
        }
    }

    @Test
    public void showResolveDir1() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", "--all", DIR1});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = this.format(PROPERTY_KEY11, PROPERTY_VALUE11) + "\n" + this.format(PROPERTY_KEY12, PROPERTY_VALUE12) + "\n";
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
        }
    }

    @Test
    public void showResolveDir2() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", "--all", DIR2});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = this.format(PROPERTY_KEY11, PROPERTY_VALUE11) + "\n" + this.format(PROPERTY_KEY2, PROPERTY_VALUE2) + "\n";
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
        }
    }

    @Test
    public void showResolveDir3() throws Exception {
        try (FileSystemAdminShell shell = new FileSystemAdminShell((AlluxioConfiguration)this.setPathConfigurations());){
            int ret = shell.run(new String[]{"pathConf", "show", "--all", DIR3});
            Assert.assertEquals((long)0L, (long)ret);
            String expected = this.format(PROPERTY_KEY11, PROPERTY_VALUE11) + "\n" + this.format(PROPERTY_KEY2, PROPERTY_VALUE2) + "\n";
            String output = this.mOutput.toString();
            Assert.assertEquals((Object)expected, (Object)output);
        }
    }
}

