/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.job;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.job.JobConfig;
import alluxio.job.plan.NoopPlanConfig;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.master.job.metrics.DistributedCmdMetrics;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DistributedCmdTest {
    private static final String LOAD = "/load";
    private static final String MIGRATE = "/migrate";
    private static final String PERSIST = "/persist";
    private static final String NOOP_PLAN = "/noop";
    private static final long LOAD_FILE_LENGTH = 1L;
    private static final long MIGRATE_FILE_LENGTH = 2L;
    private static final long PERSIST_FILE_LENGTH = 3L;
    private static final long NOOP_PLAN_FILE_LENGTH = 4L;
    private static final long DEFAULT_ZERO_LENGTH = 0L;
    private MigrateConfig mMigrateJobConfig;
    private PersistConfig mPersistJobConfig;
    private NoopPlanConfig mNoopPlanConfig;
    private FileSystem mFileSystem;
    private RetryPolicy mRetryPolicy;
    private URIStatus mLoadURIStatus;
    private URIStatus mMigrateURIStatus;
    private URIStatus mPersistURIStatus;
    private URIStatus mNoopPlanURIStatus;
    @Rule
    public ExpectedException mException = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mMigrateJobConfig = (MigrateConfig)Mockito.mock(MigrateConfig.class);
        this.mPersistJobConfig = (PersistConfig)Mockito.mock(PersistConfig.class);
        this.mNoopPlanConfig = (NoopPlanConfig)Mockito.mock(NoopPlanConfig.class);
        this.mFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.mRetryPolicy = new CountingRetry(5);
        this.mLoadURIStatus = (URIStatus)Mockito.mock(URIStatus.class);
        this.mMigrateURIStatus = (URIStatus)Mockito.mock(URIStatus.class);
        this.mPersistURIStatus = (URIStatus)Mockito.mock(URIStatus.class);
        this.mNoopPlanURIStatus = (URIStatus)Mockito.mock(URIStatus.class);
        this.mockFsOnConfigs();
        MetricsSystem.resetAllMetrics();
    }

    private void mockFsOnConfigs() throws Exception {
        Mockito.when((Object)this.mLoadURIStatus.getLength()).thenReturn((Object)1L);
        Mockito.when((Object)this.mMigrateJobConfig.getSource()).thenReturn((Object)MIGRATE);
        Mockito.when((Object)this.mPersistJobConfig.getFilePath()).thenReturn((Object)PERSIST);
        Mockito.when((Object)this.mFileSystem.getStatus(new AlluxioURI(MIGRATE))).thenReturn((Object)this.mMigrateURIStatus);
        Mockito.when((Object)this.mFileSystem.getStatus(new AlluxioURI(MIGRATE)).getLength()).thenReturn((Object)2L);
        Mockito.when((Object)this.mFileSystem.getStatus(new AlluxioURI(PERSIST))).thenReturn((Object)this.mPersistURIStatus);
        Mockito.when((Object)this.mFileSystem.getStatus(new AlluxioURI(PERSIST)).getLength()).thenReturn((Object)3L);
        Mockito.when((Object)this.mFileSystem.getStatus(new AlluxioURI(NOOP_PLAN))).thenReturn((Object)this.mNoopPlanURIStatus);
        Mockito.when((Object)this.mFileSystem.getStatus(new AlluxioURI(NOOP_PLAN)).getLength()).thenReturn((Object)4L);
        Mockito.clearInvocations((Object[])new FileSystem[]{this.mFileSystem});
    }

    @Test
    public void testMigrateConfigForCompleteStatus() throws Exception {
        DistributedCmdMetrics.incrementForCompleteStatusWithRetry((JobConfig)this.mMigrateJobConfig, (FileSystem)this.mFileSystem, (RetryPolicy)this.mRetryPolicy);
        double migrateFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_MIGRATE_JOB_FILE_SIZE.getName()).getValue();
        double persistFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_SIZE.getName()).getValue();
        Assert.assertEquals((double)migrateFileSize, (double)2.0, (double)0.0);
        Assert.assertEquals((double)persistFileSize, (double)0.0, (double)0.0);
        ((FileSystem)Mockito.verify((Object)this.mFileSystem)).getStatus(new AlluxioURI(MIGRATE));
    }

    @Test
    public void testPersistConfigForCompleteStatus() throws Exception {
        DistributedCmdMetrics.incrementForCompleteStatusWithRetry((JobConfig)this.mPersistJobConfig, (FileSystem)this.mFileSystem, (RetryPolicy)this.mRetryPolicy);
        double migrateFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_MIGRATE_JOB_FILE_SIZE.getName()).getValue();
        double persistFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_SIZE.getName()).getValue();
        Assert.assertEquals((double)migrateFileSize, (double)0.0, (double)0.0);
        Assert.assertEquals((double)persistFileSize, (double)3.0, (double)0.0);
        ((FileSystem)Mockito.verify((Object)this.mFileSystem)).getStatus(new AlluxioURI(PERSIST));
    }

    @Test
    public void testUnSupportedConfigForCompleteStatus() throws Exception {
        DistributedCmdMetrics.incrementForCompleteStatusWithRetry((JobConfig)this.mNoopPlanConfig, (FileSystem)this.mFileSystem, (RetryPolicy)this.mRetryPolicy);
        double migrateFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_MIGRATE_JOB_FILE_SIZE.getName()).getValue();
        double persistFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_SIZE.getName()).getValue();
        Assert.assertEquals((double)migrateFileSize, (double)0.0, (double)0.0);
        Assert.assertEquals((double)persistFileSize, (double)0.0, (double)0.0);
        ((FileSystem)Mockito.verify((Object)this.mFileSystem, (VerificationMode)Mockito.never())).getStatus(new AlluxioURI(NOOP_PLAN));
    }
}

