/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.job;

import alluxio.AlluxioURI;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.job.JobShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.WritePType;
import alluxio.job.JobConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.job.util.JobTestUtils;
import alluxio.job.wire.Status;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemFactory;
import com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="Jianjian", comment="Job master and job worker no longer exists in dora")
public class DistributedCommandsStatsTest
extends JobShellTest {
    private static final long SLEEP_MS = 15000L;
    private static final int TEST_TIMEOUT = 45;
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new SleepingUnderFileSystemFactory(new SleepingUnderFileSystemOptions().setIsDirectoryMs(15000L).setIsFileMs(15000L).setGetStatusMs(15000L).setListStatusMs(15000L).setListStatusWithOptionsMs(15000L).setExistsMs(15000L).setMkdirsMs(15000L)));
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();
    private String mLocalUfsPath;

    @Before
    public void before() throws Exception {
        this.mLocalUfsPath = this.mTempFolder.getRoot().getAbsolutePath();
        sFileSystem.mount(new AlluxioURI("/mnt/"), new AlluxioURI("sleep://" + this.mLocalUfsPath));
    }

    @Test
    public void testCompleteStats() throws Exception {
        int length = 10;
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/test", (WritePType)WritePType.THROUGH, (int)10);
        long jobId = sJobMaster.run((JobConfig)new PersistConfig("/test", 1L, false, "/test"));
        JobTestUtils.waitForJobStatus(sJobMaster, jobId, Sets.newHashSet((Object[])new Status[]{Status.COMPLETED}), 45);
        sJobShell.run(new String[]{"stat", "-v", Long.toString(jobId)});
        String[] output = this.mOutput.toString().split("\n");
        Assert.assertEquals((Object)String.format("ID: %s", jobId), (Object)output[0]);
        Assert.assertEquals((Object)String.format("Name: Persist", new Object[0]), (Object)output[1]);
        Assert.assertTrue((boolean)output[2].contains("Description: PersistConfig"));
        Assert.assertTrue((boolean)output[2].contains("/test"));
        Assert.assertEquals((Object)"Status: COMPLETED", (Object)output[3]);
        Assert.assertEquals((Object)"Task 0", (Object)output[4]);
        Assert.assertTrue((boolean)output[5].contains("\tWorker: "));
        Assert.assertEquals((Object)"\tStatus: COMPLETED", (Object)output[7]);
        double completedMigrateCount = MetricsSystem.getMetricValue((String)MetricKey.MASTER_MIGRATE_JOB_SUCCESS.getName()).getValue();
        double completedMigrateFileCount = MetricsSystem.getMetricValue((String)MetricKey.MASTER_MIGRATE_JOB_FILE_COUNT.getName()).getValue();
        double completedMigrateFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_MIGRATE_JOB_FILE_SIZE.getName()).getValue();
        double completedPersistCount = MetricsSystem.getMetricValue((String)MetricKey.MASTER_ASYNC_PERSIST_SUCCESS.getName()).getValue();
        double completedPersistFileCount = MetricsSystem.getMetricValue((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_COUNT.getName()).getValue();
        double completedPersistFileSize = MetricsSystem.getMetricValue((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_SIZE.getName()).getValue();
        Assert.assertEquals((double)completedMigrateCount, (double)0.0, (double)0.0);
        Assert.assertEquals((double)completedMigrateFileCount, (double)0.0, (double)0.0);
        Assert.assertEquals((double)completedMigrateFileSize, (double)0.0, (double)0.0);
        Assert.assertEquals((double)completedPersistCount, (double)0.0, (double)0.0);
        Assert.assertEquals((double)completedPersistFileCount, (double)0.0, (double)0.0);
        Assert.assertEquals((double)completedPersistFileSize, (double)0.0, (double)0.0);
    }
}

