/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.job;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fs.FileSystemShell;
import alluxio.cli.job.JobShell;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="fix or remove this test")
public class GetCmdStatusCommandTest
extends AbstractFileSystemShellTest {
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();
    @ClassRule
    public static LocalAlluxioClusterResource sResource = new LocalAlluxioClusterResource.Builder().setNumWorkers(4).setProperty(PropertyKey.MASTER_PERSISTENCE_CHECKER_INTERVAL_MS, "10ms").setProperty(PropertyKey.MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS, "10ms").setProperty(PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL, "200ms").setProperty(PropertyKey.WORKER_RAMDISK_SIZE, 0x1000000).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 0x1000000).setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, Long.MAX_VALUE).setProperty(PropertyKey.USER_FILE_RESERVED_BYTES, 0x800000).setProperty(PropertyKey.CONF_DYNAMIC_UPDATE_ENABLED, true).build();

    @BeforeClass
    public static void beforeClass() throws Exception {
        sLocalAlluxioCluster = sResource.get();
        sLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        sLocalAlluxioJobCluster.start();
        sFileSystem = sLocalAlluxioCluster.getClient();
        sJobMaster = sLocalAlluxioJobCluster.getMaster().getJobMaster();
        sJobShell = new JobShell(Configuration.global());
        sFsShell = new FileSystemShell(Configuration.global());
    }

    @Test
    public void testGetCmdStatusForLoad() throws IOException, AlluxioException {
        FileSystem fs = sResource.get().getClient();
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileA", (WritePType)WritePType.THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testRoot/testFileB", (WritePType)WritePType.THROUGH, (int)10);
        sFsShell.run(new String[]{"distributedLoad", "/testRoot"});
        String[] output = this.mOutput.toString().split("\n");
        String jobControlId = output[1].split("=\\s+")[1];
        this.mOutput.reset();
        sJobShell.run(new String[]{"getCmdStatus", jobControlId});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Get command status information below:"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Successfully loaded path /testRoot/testFileA\n"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Successfully loaded path /testRoot/testFileB\n"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Total completed file count is 2, failed file count is 0"));
    }

    @Test
    public void testGetCmdStatusForBatchLoad() throws IOException {
        int batch = 2;
        FileSystem fs = sResource.get().getClient();
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testBatchRoot/testBatchFileA", (WritePType)WritePType.THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testBatchRoot/testBatchFileB", (WritePType)WritePType.THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testBatchRoot/testBatchFileC", (WritePType)WritePType.THROUGH, (int)10);
        sFsShell.run(new String[]{"distributedLoad", "/testBatchRoot", "--batch-size", String.valueOf(batch)});
        String[] output = this.mOutput.toString().split("\n");
        String jobControlId = output[1].split("=\\s+")[1];
        this.mOutput.reset();
        sJobShell.run(new String[]{"getCmdStatus", jobControlId});
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Successfully loaded path /testBatchRoot/testBatchFileA\n"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Successfully loaded path /testBatchRoot/testBatchFileB\n"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Successfully loaded path /testBatchRoot/testBatchFileC\n"));
        Assert.assertTrue((boolean)this.mOutput.toString().contains("Total completed file count is 3, failed file count is 0"));
    }
}

