/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.Server;
import alluxio.clock.ManualClock;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.RegisterWorkerPOptions;
import alluxio.master.AlwaysPrimaryPrimarySelector;
import alluxio.master.CoreMasterContext;
import alluxio.master.MasterRegistry;
import alluxio.master.MasterTestUtils;
import alluxio.master.PrimarySelector;
import alluxio.master.block.BlockMaster;
import alluxio.master.block.DefaultBlockMaster;
import alluxio.master.block.meta.MasterWorkerInfo;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.noop.NoopJournalSystem;
import alluxio.master.metrics.MetricsMaster;
import alluxio.master.metrics.MetricsMasterFactory;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.wire.WorkerNetAddress;
import java.time.Clock;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlockMasterDeleteLostWorkerIntegrationTest {
    private BlockMaster mBlockMaster;
    private ManualClock mClock;
    private MasterRegistry mRegistry;
    private static final int MASTER_WORKER_DELETE_TIMEOUT_MS = 10;
    private static final int MASTER_WORKER_TIMEOUT_MS = 10;
    static final WorkerNetAddress NET_ADDRESS_1 = new WorkerNetAddress().setHost("localhost").setRpcPort(80).setDataPort(81).setWebPort(82);

    @Before
    public void before() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.MASTER_LOST_WORKER_DELETION_TIMEOUT_MS, (Object)10);
        Configuration.set((PropertyKey)PropertyKey.MASTER_WORKER_TIMEOUT_MS, (Object)10);
        this.mRegistry = new MasterRegistry();
        CoreMasterContext masterContext = MasterTestUtils.testMasterContext((JournalSystem)new NoopJournalSystem(), null, (PrimarySelector)new AlwaysPrimaryPrimarySelector());
        MetricsMaster metricsMaster = new MetricsMasterFactory().create(this.mRegistry, masterContext);
        this.mRegistry.add(MetricsMaster.class, (Server)metricsMaster);
        this.mClock = new ManualClock();
        this.mBlockMaster = new DefaultBlockMaster(metricsMaster, masterContext, (Clock)this.mClock, ExecutorServiceFactories.constantExecutorServiceFactory((ExecutorService)Executors.newFixedThreadPool(10)));
        this.mRegistry.add(BlockMaster.class, (Server)this.mBlockMaster);
        this.mRegistry.start((Object)true);
    }

    @After
    public void after() throws Exception {
        this.mRegistry.stop();
    }

    @Test
    public void lostWorkerDeletedAfterTimeout() throws Exception {
        long workerId = this.mBlockMaster.getWorkerId(NET_ADDRESS_1);
        this.mBlockMaster.workerRegister(workerId, Collections.EMPTY_LIST, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, RegisterWorkerPOptions.getDefaultInstance());
        DefaultBlockMaster.LostWorkerDetectionHeartbeatExecutor lostWorkerDetector = new DefaultBlockMaster.LostWorkerDetectionHeartbeatExecutor((DefaultBlockMaster)this.mBlockMaster);
        Assert.assertEquals((long)1L, (long)this.mBlockMaster.getWorkerCount());
        Assert.assertEquals((long)0L, (long)this.mBlockMaster.getLostWorkerCount());
        MasterWorkerInfo worker = this.mBlockMaster.getWorker(workerId);
        long newTimeMs = worker.getLastUpdatedTimeMs() + 10L + 1L;
        this.mClock.setTimeMs(newTimeMs);
        lostWorkerDetector.heartbeat(Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)this.mBlockMaster.getWorkerCount());
        Assert.assertEquals((long)1L, (long)this.mBlockMaster.getLostWorkerCount());
        newTimeMs = newTimeMs + 10L + 1L;
        this.mClock.setTimeMs(newTimeMs);
        lostWorkerDetector.heartbeat(Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)this.mBlockMaster.getWorkerCount());
        Assert.assertEquals((long)0L, (long)this.mBlockMaster.getLostWorkerCount());
    }
}

