/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.CheckConsistencyContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.DeleteOptions;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if the command is still relevant")
public class CheckConsistencyIntegrationTest
extends BaseIntegrationTest {
    private static final AlluxioURI DIRECTORY = new AlluxioURI("/dir");
    private static final AlluxioURI FILE = new AlluxioURI("/dir/file");
    private static final String TEST_USER = "test";
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_LOGIN_USERNAME, "test").build();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    private FileSystemMaster mFileSystemMaster;
    private FileSystem mFileSystem;

    @Before
    public final void before() throws Exception {
        this.mFileSystemMaster = (FileSystemMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        this.mFileSystem = FileSystem.Factory.create();
        CreateDirectoryPOptions dirOptions = CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        CreateFilePOptions fileOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        this.mFileSystem.createDirectory(DIRECTORY, dirOptions);
        this.mFileSystem.createFile(FILE, fileOptions).close();
    }

    @Test
    public void consistent() throws Exception {
        Assert.assertEquals(new ArrayList(), (Object)this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults()));
    }

    @Test
    public void inconsistent() throws Exception {
        String ufsDirectory = this.mFileSystem.getStatus(DIRECTORY).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsDirectory, (AlluxioConfiguration)Configuration.global());
        ufs.deleteDirectory(ufsDirectory, DeleteOptions.defaults().setRecursive(true));
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{FILE, DIRECTORY});
        List result = this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults());
        Collections.sort(expected);
        Collections.sort(result);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void partiallyInconsistent() throws Exception {
        String ufsFile = this.mFileSystem.getStatus(FILE).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsFile, (AlluxioConfiguration)Configuration.global());
        ufs.deleteFile(ufsFile);
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{FILE});
        Assert.assertEquals((Object)expected, (Object)this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults()));
    }

    @Test
    public void largeTree() throws Exception {
        CreateDirectoryPOptions dirOptions = CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        CreateFilePOptions fileOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        AlluxioURI nestedDir = DIRECTORY.join("/dir2");
        AlluxioURI topLevelFile = new AlluxioURI("/file");
        AlluxioURI thirdLevelFile = nestedDir.join("/file");
        this.mFileSystem.createDirectory(nestedDir, dirOptions);
        this.mFileSystem.createFile(topLevelFile, fileOptions).close();
        this.mFileSystem.createFile(thirdLevelFile, fileOptions).close();
        String ufsDirectory = this.mFileSystem.getStatus(nestedDir).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsDirectory, (AlluxioConfiguration)Configuration.global());
        ufs.deleteDirectory(ufsDirectory, DeleteOptions.defaults().setRecursive(true));
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{nestedDir, thirdLevelFile});
        List result = this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults());
        Collections.sort(expected);
        Collections.sort(result);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void incorrectFileSize() throws Exception {
        String ufsFile = this.mFileSystem.getStatus(FILE).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsFile, (AlluxioConfiguration)Configuration.global());
        ufs.deleteFile(ufsFile);
        OutputStream out = ufs.create(ufsFile);
        out.write(1);
        out.close();
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{FILE});
        Assert.assertEquals((Object)expected, (Object)this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults()));
    }

    @Test
    public void notADirectory() throws Exception {
        String ufsDirectory = this.mFileSystem.getStatus(DIRECTORY).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsDirectory, (AlluxioConfiguration)Configuration.global());
        ufs.deleteDirectory(ufsDirectory, DeleteOptions.defaults().setRecursive(true));
        ufs.create(ufsDirectory).close();
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{DIRECTORY, FILE});
        List result = this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults());
        Collections.sort(expected);
        Collections.sort(result);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void existsInUfsButNotAlluxio() throws Exception {
        String ufsDirectory = this.mFileSystem.getStatus(DIRECTORY).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsDirectory, (AlluxioConfiguration)Configuration.global());
        String filename = "ufs_exists";
        String newPath = ufsDirectory + "/" + filename;
        ufs.mkdirs(newPath);
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{DIRECTORY.join(filename)});
        Assert.assertEquals((Object)expected, (Object)this.mFileSystemMaster.checkConsistency(DIRECTORY, CheckConsistencyContext.defaults()));
    }

    @Test
    public void notAFile() throws Exception {
        String ufsFile = this.mFileSystem.getStatus(FILE).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsFile, (AlluxioConfiguration)Configuration.global());
        ufs.deleteFile(ufsFile);
        ufs.mkdirs(ufsFile);
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{FILE});
        Assert.assertEquals((Object)expected, (Object)this.mFileSystemMaster.checkConsistency(new AlluxioURI("/"), CheckConsistencyContext.defaults()));
    }

    @Test
    public void inconsistentFile() throws Exception {
        String ufsFile = this.mFileSystem.getStatus(FILE).getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsFile, (AlluxioConfiguration)Configuration.global());
        ufs.deleteFile(ufsFile);
        ArrayList expected = Lists.newArrayList((Object[])new AlluxioURI[]{FILE});
        Assert.assertEquals((Object)expected, (Object)this.mFileSystemMaster.checkConsistency(FILE, CheckConsistencyContext.defaults()));
    }
}

