/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.ListStatusPartialResult;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.ListStatusPartialPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import alluxio.wire.BlockLocationInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="many tests fail due to a few missing APIs")
public final class FileSystemIntegrationTest
extends BaseIntegrationTest {
    private static final byte[] TEST_BYTES = "TestBytes".getBytes();
    private static final int USER_QUOTA_UNIT_BYTES = 1000;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, 1000).build();
    private FileSystem mFileSystem = null;
    private CreateFilePOptions mWriteBoth;
    private UnderFileSystem mUfs;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        this.mWriteBoth = CreateFilePOptions.newBuilder().setRecursive(true).setWriteType(WritePType.CACHE_THROUGH).build();
        this.mUfs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
    }

    @Test
    public void getRoot() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(new AlluxioURI("/")).getFileId());
    }

    @Test
    public void createFile() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 1; k < 5; ++k) {
            AlluxioURI uri = new AlluxioURI(uniqPath + k);
            this.mFileSystem.createFile(uri, this.mWriteBoth).close();
            Assert.assertNotNull((Object)this.mFileSystem.getStatus(uri));
        }
    }

    @Test
    public void deleteFile() throws Exception {
        AlluxioURI fileURI;
        int k;
        String uniqPath = PathUtils.uniqPath();
        for (k = 0; k < 5; ++k) {
            fileURI = new AlluxioURI(uniqPath + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)fileURI.getPath(), (int)k, (CreateFilePOptions)this.mWriteBoth);
            Assert.assertTrue((this.mFileSystem.getStatus(fileURI).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileURI));
        }
        for (k = 0; k < 5; ++k) {
            fileURI = new AlluxioURI(uniqPath + k);
            this.mFileSystem.delete(fileURI);
            Assert.assertFalse((boolean)this.mFileSystem.exists(fileURI));
            this.mThrown.expect(FileDoesNotExistException.class);
            this.mFileSystem.getStatus(fileURI);
        }
    }

    @Test
    public void deleteDirectoryWithPersistedWritesInProgress() throws Exception {
        AlluxioURI testFolder = new AlluxioURI("/testFolder");
        this.mFileSystem.createDirectory(testFolder, CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());
        FileOutStream out = this.mFileSystem.createFile(new AlluxioURI("/testFolder/testFile"), CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());
        out.write(TEST_BYTES);
        out.flush();
        CommonUtils.waitFor((String)"File flush.", () -> {
            try {
                return this.mUfs.listStatus(this.mFileSystem.getStatus(testFolder).getUfsPath()).length > 0;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(5000L));
        this.mFileSystem.delete(new AlluxioURI("/testFolder"), DeletePOptions.newBuilder().setRecursive(true).build());
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI("/testFolder")));
        this.mThrown.expect(IOException.class);
        out.close();
    }

    @Test
    public void getFileStatus() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        int writeBytes = 2000;
        AlluxioURI uri = new AlluxioURI(uniqPath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)uri.getPath(), (int)writeBytes, (CreateFilePOptions)this.mWriteBoth);
        Assert.assertTrue((this.mFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.mFileSystem.getStatus(uri).getPath().equals(uniqPath));
    }

    @Test
    public void renameFileTest1() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        AlluxioURI path1 = new AlluxioURI(uniqPath + 1);
        this.mFileSystem.createFile(path1, this.mWriteBoth).close();
        for (int k = 1; k < 10; ++k) {
            AlluxioURI fileA = new AlluxioURI(uniqPath + k);
            AlluxioURI fileB = new AlluxioURI(uniqPath + (k + 1));
            URIStatus existingFile = this.mFileSystem.getStatus(fileA);
            long oldFileId = existingFile.getFileId();
            Assert.assertNotNull((Object)existingFile);
            this.mFileSystem.rename(fileA, fileB);
            URIStatus renamedFile = this.mFileSystem.getStatus(fileB);
            Assert.assertNotNull((Object)renamedFile);
            Assert.assertEquals((long)oldFileId, (long)renamedFile.getFileId());
        }
    }

    @Test
    public void renameFileTest2() throws Exception {
        AlluxioURI uniqUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createFile(uniqUri, this.mWriteBoth).close();
        URIStatus f = this.mFileSystem.getStatus(uniqUri);
        long oldFileId = f.getFileId();
        this.mFileSystem.rename(uniqUri, uniqUri);
        Assert.assertEquals((long)oldFileId, (long)this.mFileSystem.getStatus(uniqUri).getFileId());
    }

    private String createAlternateUfs() throws Exception {
        AlluxioURI parentURI = new AlluxioURI(Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS)).getParent();
        String alternateUfsRoot = parentURI.join("alternateUnderFSStorage").toString();
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)alternateUfsRoot);
        return alternateUfsRoot;
    }

    private void destroyAlternateUfs(String alternateUfsRoot) throws Exception {
        UnderFileSystemUtils.deleteDirIfExists((UnderFileSystem)this.mUfs, (String)alternateUfsRoot);
    }

    @Test
    public void mountAlternateUfs() throws Exception {
        String alternateUfsRoot = this.createAlternateUfs();
        try {
            String filePath = PathUtils.concatPath((Object)alternateUfsRoot, (Object)"file1");
            UnderFileSystemUtils.touch((UnderFileSystem)this.mUfs, (String)filePath);
            this.mFileSystem.mount(new AlluxioURI("/d1"), new AlluxioURI(alternateUfsRoot));
            Assert.assertEquals((Object)"file1", (Object)((URIStatus)this.mFileSystem.listStatus(new AlluxioURI("/d1")).get(0)).getName());
        }
        finally {
            this.destroyAlternateUfs(alternateUfsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mountAlternateUfsSubdirs() throws Exception {
        String alternateUfsRoot = this.createAlternateUfs();
        try {
            String dirPath1 = PathUtils.concatPath((Object)alternateUfsRoot, (Object)"dir1");
            String dirPath2 = PathUtils.concatPath((Object)alternateUfsRoot, (Object)"dir2");
            UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)dirPath1);
            UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)dirPath2);
            String filePath1 = PathUtils.concatPath((Object)dirPath1, (Object)"file1");
            String filePath2 = PathUtils.concatPath((Object)dirPath2, (Object)"file2");
            UnderFileSystemUtils.touch((UnderFileSystem)this.mUfs, (String)filePath1);
            UnderFileSystemUtils.touch((UnderFileSystem)this.mUfs, (String)filePath2);
            this.mFileSystem.mount(new AlluxioURI("/d1"), new AlluxioURI(dirPath1));
            this.mFileSystem.mount(new AlluxioURI("/d2"), new AlluxioURI(dirPath2));
            Assert.assertEquals((Object)"file1", (Object)((URIStatus)this.mFileSystem.listStatus(new AlluxioURI("/d1")).get(0)).getName());
            Assert.assertEquals((Object)"file2", (Object)((URIStatus)this.mFileSystem.listStatus(new AlluxioURI("/d2")).get(0)).getName());
        }
        finally {
            this.destroyAlternateUfs(alternateUfsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mountPrefixUfs() throws Exception {
        String ufsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String ufsSubdir = PathUtils.concatPath((Object)ufsRoot, (Object)"dir1");
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)ufsSubdir);
        try {
            this.mFileSystem.mount(new AlluxioURI("/dir"), new AlluxioURI(ufsSubdir));
            Assert.fail((String)"Cannot remount primary ufs.");
        }
        catch (AlluxioException alluxioException) {
            // empty catch block
        }
        String alternateUfsRoot = this.createAlternateUfs();
        try {
            String midDirPath = PathUtils.concatPath((Object)alternateUfsRoot, (Object)"mid");
            String innerDirPath = PathUtils.concatPath((Object)midDirPath, (Object)"inner");
            UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)innerDirPath);
            this.mFileSystem.mount(new AlluxioURI("/mid"), new AlluxioURI(midDirPath));
            try {
                this.mFileSystem.mount(new AlluxioURI("/inner"), new AlluxioURI(innerDirPath));
                Assert.fail((String)"Cannot mount suffix of already-mounted directory");
            }
            catch (AlluxioException alluxioException) {
                // empty catch block
            }
            try {
                this.mFileSystem.mount(new AlluxioURI("/root"), new AlluxioURI(alternateUfsRoot));
                Assert.fail((String)"Cannot mount prefix of already-mounted directory");
            }
            catch (AlluxioException alluxioException) {
                // empty catch block
            }
        }
        finally {
            this.destroyAlternateUfs(alternateUfsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mountShadowUfs() throws Exception {
        String ufsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String ufsSubdir = PathUtils.concatPath((Object)ufsRoot, (Object)"dir1");
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)ufsSubdir);
        String alternateUfsRoot = this.createAlternateUfs();
        try {
            String subdirPath = PathUtils.concatPath((Object)alternateUfsRoot, (Object)"subdir");
            UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)subdirPath);
            this.mFileSystem.mount(new AlluxioURI("/dir1"), new AlluxioURI(subdirPath));
            Assert.fail((String)"Cannot mount to path that shadows a file in the primary UFS");
        }
        catch (AlluxioException alluxioException) {
        }
        finally {
            this.destroyAlternateUfs(alternateUfsRoot);
        }
    }

    @Test
    public void getBlockLocations() throws Exception {
        AlluxioURI testFile = new AlluxioURI("/test1");
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)testFile, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).setBlockSizeBytes(4L).build(), (int)100);
        List locations = this.mFileSystem.getBlockLocations(testFile);
        Assert.assertEquals((String)"should have 25 blocks", (long)25L, (long)locations.size());
        long lastOffset = -1L;
        for (BlockLocationInfo location : locations) {
            Assert.assertEquals((String)("block " + location.getBlockInfo() + " should have single worker"), (long)1L, (long)location.getLocations().size());
            Assert.assertTrue((String)("block " + location.getBlockInfo() + " should have offset larger than " + lastOffset), (location.getBlockInfo().getOffset() > lastOffset ? 1 : 0) != 0);
            lastOffset = location.getBlockInfo().getOffset();
        }
        testFile = new AlluxioURI("/test2");
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)testFile, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setBlockSizeBytes(100L).build(), (int)500);
        locations = this.mFileSystem.getBlockLocations(testFile);
        Assert.assertEquals((String)"Should have 5 blocks", (long)5L, (long)locations.size());
        lastOffset = -1L;
        for (BlockLocationInfo location : locations) {
            Assert.assertEquals((String)("block " + location.getBlockInfo() + " should have single worker"), (long)1L, (long)location.getLocations().size());
            Assert.assertTrue((String)("block " + location.getBlockInfo() + " should have offset larger than " + lastOffset), (location.getBlockInfo().getOffset() > lastOffset ? 1 : 0) != 0);
            lastOffset = location.getBlockInfo().getOffset();
        }
    }

    @Test
    public void testMultiSetAttribute() throws Exception {
        AlluxioURI testFile = new AlluxioURI("/test1");
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)testFile, (WritePType)WritePType.MUST_CACHE, (int)512);
        long expectedTtl = Configuration.getMs((PropertyKey)PropertyKey.USER_FILE_CREATE_TTL);
        URIStatus stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"TTL should be equal to configuration", (long)expectedTtl, (long)stat.getTtl());
        long newTtl = 14402478L;
        this.mFileSystem.setAttribute(testFile, SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(newTtl).build()).build());
        stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"Ttl should be the updated", (long)newTtl, (long)stat.getTtl());
        long lastModifiedTime = stat.getLastModificationTimeMs();
        this.mFileSystem.setAttribute(testFile, SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(newTtl).build()).build());
        stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"Ttl should not change", (long)newTtl, (long)stat.getTtl());
        Assert.assertEquals((String)"LastModifiedTime should not change", (long)lastModifiedTime, (long)stat.getLastModificationTimeMs());
        String newOwner = "testOwner";
        this.mFileSystem.setAttribute(testFile, SetAttributePOptions.newBuilder().setOwner(newOwner).build());
        stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"TTL should not change", (long)newTtl, (long)stat.getTtl());
        Assert.assertEquals((String)"Owner should be updated", (Object)newOwner, (Object)stat.getOwner());
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.create.ttl.action", "FREE"})
    @Test
    public void testTtlActionSetAttribute() throws Exception {
        AlluxioURI testFile = new AlluxioURI("/test1");
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)testFile, (WritePType)WritePType.MUST_CACHE, (int)512);
        TtlAction expectedAction = (TtlAction)Configuration.getEnum((PropertyKey)PropertyKey.USER_FILE_CREATE_TTL_ACTION, TtlAction.class);
        URIStatus stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"TTL action should be same", (Object)expectedAction, (Object)stat.getTtlAction());
        TtlAction newTtlAction = TtlAction.DELETE;
        long newTtl = 123400000L;
        this.mFileSystem.setAttribute(testFile, SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(newTtl).build()).build());
        stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"TTL should be same", (long)newTtl, (long)stat.getTtl());
        Assert.assertEquals((String)"TTL action should be same", (Object)expectedAction, (Object)stat.getTtlAction());
        this.mFileSystem.setAttribute(testFile, SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtlAction(newTtlAction).build()).build());
        stat = this.mFileSystem.getStatus(testFile);
        Assert.assertEquals((String)"TTL should be same", (long)newTtl, (long)stat.getTtl());
        Assert.assertEquals((String)"TTL action should be same", (Object)newTtlAction, (Object)stat.getTtlAction());
    }

    @Test
    public void createExistingDirectory() throws Exception {
        AlluxioURI path = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(path);
        this.mThrown.expect(FileAlreadyExistsException.class);
        this.mFileSystem.createDirectory(path);
    }

    @Test
    public void createDirectoryOnTopOfFile() throws Exception {
        AlluxioURI path = new AlluxioURI("/dir");
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)path, (CreateFilePOptions)CreateFilePOptions.getDefaultInstance(), (int)10);
        this.mThrown.expect(FileAlreadyExistsException.class);
        this.mFileSystem.createDirectory(path);
    }

    @Test
    public void createDirectoryInvalidPath() throws Exception {
        this.mThrown.expect(InvalidPathException.class);
        this.mFileSystem.createDirectory(new AlluxioURI("not a path"));
    }

    @Test
    public void createExistingFile() throws Exception {
        AlluxioURI path = new AlluxioURI("/file");
        this.mFileSystem.createFile(path).close();
        this.mThrown.expect(FileAlreadyExistsException.class);
        this.mFileSystem.createFile(path);
    }

    @Test
    public void createFileInvalidPath() throws Exception {
        this.mThrown.expect(InvalidPathException.class);
        this.mFileSystem.createFile(new AlluxioURI("not a path"));
    }

    @Test
    public void deleteNonexistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.delete(new AlluxioURI("/dir"));
    }

    @Test
    public void deleteNonexistingNestedPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.delete(new AlluxioURI("/dir/dir"));
    }

    @Test
    public void deleteNonemptyDirectory() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"file"))).close();
        this.mThrown.expect(DirectoryNotEmptyException.class);
        this.mFileSystem.delete(dir, DeletePOptions.getDefaultInstance());
    }

    @Test
    public void existsNonexistingPath() throws Exception {
        AlluxioURI path = new AlluxioURI("/path");
        Assert.assertFalse((boolean)this.mFileSystem.exists(path));
    }

    @Test
    public void existsNonexistingNestedPath() throws Exception {
        AlluxioURI path = new AlluxioURI("/dir/path");
        Assert.assertFalse((boolean)this.mFileSystem.exists(path));
    }

    @Test
    public void freeNonexistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.free(new AlluxioURI("/path"));
    }

    @Test
    public void freeNonexistingNestedPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.free(new AlluxioURI("/dir/path"));
    }

    @Test
    public void getStatusNonexistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.getStatus(new AlluxioURI("/path"));
    }

    @Test
    public void getStatusNonexistingNestedPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.getStatus(new AlluxioURI("/dir/path"));
    }

    @Test
    public void listStatusNonexistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.listStatus(new AlluxioURI("/path"));
    }

    @Test
    public void openFileNonexistingPath() throws Exception {
        AlluxioURI path = new AlluxioURI("/path");
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.openFile(path);
    }

    @Test
    public void renameNonexistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.rename(new AlluxioURI("/path1"), new AlluxioURI("/path1"));
    }

    @Test
    public void setAttributeNonexistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.setAttribute(new AlluxioURI("/path"));
    }

    @Test
    public void getBlockLocationNonExistingPath() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFileSystem.getBlockLocations(new AlluxioURI("/path"));
    }

    Pair<List<String>, ListStatusPartialResult> partialList(AlluxioURI path, ListStatusPartialPOptions options) throws Exception {
        ListStatusPartialResult result = this.mFileSystem.listStatusPartial(path, options);
        return new Pair(result.getListings().stream().map(URIStatus::getName).collect(Collectors.toList()), (Object)result);
    }

    @Test
    public void listStatusPartial() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"a"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"b"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"e"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"f"))).close();
        Pair<List<String>, ListStatusPartialResult> result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setBatchSize(2).build());
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)result.getFirst());
        Assert.assertTrue((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
        result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setOffsetId(((URIStatus)((ListStatusPartialResult)result.getSecond()).getListings().get(((ListStatusPartialResult)result.getSecond()).getListings().size() - 1)).getFileId()).build());
        Assert.assertEquals(Arrays.asList("e", "f"), (Object)result.getFirst());
        Assert.assertFalse((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
    }

    @Test
    public void listStatusStartAfterLoop() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        int fileCount = 100;
        for (int i = 0; i < fileCount; ++i) {
            this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)String.format("%05d", i)))).close();
        }
        int batchSize = 2;
        String startAfter = "";
        for (int i = 0; i < fileCount; i += batchSize) {
            Pair<List<String>, ListStatusPartialResult> result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setStartAfter(startAfter).setBatchSize(batchSize).build());
            ArrayList<String> expectedResult = new ArrayList<String>();
            for (int j = i; j < Math.min(fileCount, i + batchSize); ++j) {
                expectedResult.add(String.format("%05d", j));
            }
            Assert.assertEquals(expectedResult, (Object)result.getFirst());
            if (i + batchSize < fileCount) {
                Assert.assertTrue((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
            } else {
                Assert.assertFalse((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
            }
            List listings = ((ListStatusPartialResult)result.getSecond()).getListings();
            if (listings.isEmpty()) continue;
            startAfter = ((URIStatus)listings.get(listings.size() - 1)).getPath();
        }
    }

    @Test
    public void listStatusPartialLoop() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        int fileCount = 100;
        for (int i = 0; i < fileCount; ++i) {
            this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)String.format("%05d", i)))).close();
        }
        int batchSize = 2;
        long startAfter = 0L;
        for (int i = 0; i < fileCount; i += batchSize) {
            Pair<List<String>, ListStatusPartialResult> result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setOffsetId(startAfter).setBatchSize(batchSize).build());
            ArrayList<String> expectedResult = new ArrayList<String>();
            for (int j = i; j < Math.min(fileCount, i + batchSize); ++j) {
                expectedResult.add(String.format("%05d", j));
            }
            Assert.assertEquals(expectedResult, (Object)result.getFirst());
            if (i + batchSize < fileCount) {
                Assert.assertTrue((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
            } else {
                Assert.assertFalse((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
            }
            List listings = ((ListStatusPartialResult)result.getSecond()).getListings();
            if (listings.isEmpty()) continue;
            startAfter = ((URIStatus)listings.get(listings.size() - 1)).getFileId();
        }
    }

    @Test
    public void listStatusPartialStartAfter() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        dir = dir.join("nested");
        this.mFileSystem.createDirectory(dir);
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"a"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"b"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"e"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"f"))).close();
        Pair<List<String>, ListStatusPartialResult> result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setBatchSize(2).build());
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)result.getFirst());
        Assert.assertTrue((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
        result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setStartAfter("b").build());
        Assert.assertEquals(Arrays.asList("e", "f"), (Object)result.getFirst());
        Assert.assertFalse((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
    }

    @Test
    public void listStatusPartialPrefix() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        dir = dir.join("nested");
        this.mFileSystem.createDirectory(dir);
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"prefix"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"prefix-suffix"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"dif-prefix"))).close();
        this.mFileSystem.createFile(new AlluxioURI(PathUtils.concatPath((Object)dir, (Object)"dif-suffix"))).close();
        Pair<List<String>, ListStatusPartialResult> result = this.partialList(dir, ListStatusPartialPOptions.newBuilder().setPrefix("/prefix").build());
        Assert.assertEquals(Arrays.asList("prefix", "prefix-suffix"), (Object)result.getFirst());
        Assert.assertFalse((boolean)((ListStatusPartialResult)result.getSecond()).isTruncated());
    }
}

