/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.GetStatusPOptions;
import alluxio.master.MasterClientContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.FileSystemOptionsUtils;
import com.google.common.base.Throwables;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public final class FileSystemMasterClientIntegrationTest
extends BaseIntegrationTest {
    private static final GetStatusPOptions GET_STATUS_OPTIONS = FileSystemOptionsUtils.getStatusDefaults((AlluxioConfiguration)Configuration.global());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();

    @Test
    public void openClose() throws AlluxioException, IOException {
        FileSystemMasterClient fsMasterClient = FileSystemMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        AlluxioURI file = new AlluxioURI("/file");
        Assert.assertFalse((boolean)fsMasterClient.isConnected());
        fsMasterClient.connect();
        Assert.assertTrue((boolean)fsMasterClient.isConnected());
        fsMasterClient.createFile(file, FileSystemOptionsUtils.createFileDefaults((AlluxioConfiguration)Configuration.global()));
        Assert.assertNotNull((Object)fsMasterClient.getStatus(file, GET_STATUS_OPTIONS));
        fsMasterClient.disconnect();
        Assert.assertFalse((boolean)fsMasterClient.isConnected());
        fsMasterClient.connect();
        Assert.assertTrue((boolean)fsMasterClient.isConnected());
        Assert.assertNotNull((Object)fsMasterClient.getStatus(file, GET_STATUS_OPTIONS));
        fsMasterClient.close();
    }

    @Test(timeout=3000L, expected=NotFoundException.class)
    public void getFileInfoReturnsOnError() throws Exception {
        FileSystemMasterClient fsMasterClient = FileSystemMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        fsMasterClient.getStatus(new AlluxioURI("/doesNotExist"), GET_STATUS_OPTIONS);
        fsMasterClient.close();
    }

    @Test(timeout=300000L)
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.rpc.retry.max.duration", "10s"})
    public void masterUnavailable() throws Exception {
        this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().stop();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    FileSystemMasterClientIntegrationTest.this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().start();
                }
                catch (InterruptedException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        thread.start();
        FileSystem fileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        fileSystem.listStatus(new AlluxioURI("/"));
        thread.join();
    }
}

