/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.client.WriteType;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.CompleteFileContext;
import alluxio.master.file.contexts.CreateDirectoryContext;
import alluxio.master.file.contexts.CreateFileContext;
import alluxio.master.file.contexts.DeleteContext;
import alluxio.master.file.contexts.GetStatusContext;
import alluxio.master.file.contexts.ListStatusContext;
import alluxio.master.file.contexts.MountContext;
import alluxio.master.file.meta.TtlIntervalRule;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.Mode;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.master.FsMasterResource;
import alluxio.testutils.master.MasterTestUtils;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.wire.FileInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class FileSystemMasterRestartIntegrationTest
extends BaseIntegrationTest {
    private static final long TEST_TIME_MS = Long.MAX_VALUE;
    private static final long TTL_CHECKER_INTERVAL_MS = 100L;
    private static final String TEST_USER = "test";
    @ClassRule
    public static ManuallyScheduleHeartbeat sManuallySchedule = new ManuallyScheduleHeartbeat(new String[]{"Master TTL Check"});
    @ClassRule
    public static TtlIntervalRule sTtlIntervalRule = new TtlIntervalRule(100L);
    @Rule
    public Timeout mGlobalTimeout = Timeout.seconds((long)60L);
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_METRICS_COLLECTION_ENABLED, false).setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, 100L).setProperty(PropertyKey.WORKER_RAMDISK_SIZE, 1000).setProperty(PropertyKey.MASTER_FILE_ACCESS_TIME_UPDATE_PRECISION, 0).setProperty(PropertyKey.SECURITY_LOGIN_USERNAME, "test").build();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    private FileSystemMaster mFsMaster;

    @Before
    public final void before() throws Exception {
        this.mFsMaster = (FileSystemMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
    }

    private FsMasterResource createFileSystemMasterFromJournal() throws Exception {
        FsMasterResource resource = MasterTestUtils.createLeaderFileSystemMasterFromJournalCopy();
        if (AuthenticatedClientUser.getOrNull() == null) {
            AuthenticatedClientUser.set((String)TEST_USER);
        }
        return resource;
    }

    @Test
    public void syncReplay() throws Exception {
        AlluxioURI root = new AlluxioURI("/");
        AlluxioURI alluxioFile = new AlluxioURI("/in_alluxio");
        this.mFsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.completeFile(alluxioFile, CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setUfsLength(0L)).setOperationTimeMs(Long.MAX_VALUE));
        List files = this.mFsMaster.listStatus(root, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L))));
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertEquals((Object)alluxioFile.getName(), (Object)((FileInfo)files.get(0)).getName());
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        Files.createDirectory(Paths.get(ufs, "ufs_dir"), new FileAttribute[0]);
        Files.createFile(Paths.get(ufs, "ufs_file"), new FileAttribute[0]);
        files = this.mFsMaster.listStatus(root, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L))));
        Assert.assertEquals((long)2L, (long)files.size());
        Set filenames = files.stream().map(FileInfo::getName).collect(Collectors.toSet());
        Assert.assertTrue((boolean)filenames.contains("ufs_dir"));
        Assert.assertTrue((boolean)filenames.contains("ufs_file"));
        this.mLocalAlluxioClusterResource.get().stopFS();
        try (FsMasterResource masterResource = this.createFileSystemMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            files = fsMaster.listStatus(root, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L))));
            Assert.assertEquals((long)2L, (long)files.size());
            filenames = files.stream().map(FileInfo::getName).collect(Collectors.toSet());
            Assert.assertTrue((boolean)filenames.contains("ufs_dir"));
            Assert.assertTrue((boolean)filenames.contains("ufs_file"));
        }
    }

    @Test
    public void syncDirReplay() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir/");
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        Files.createDirectory(Paths.get(ufs, "dir"), new FileAttribute[0]);
        Files.createFile(Paths.get(ufs, "dir", "file"), new FileAttribute[0]);
        File ufsDir = new File(Paths.get(ufs, "dir").toString());
        Assert.assertTrue((boolean)ufsDir.setReadable(true, false));
        Assert.assertTrue((boolean)ufsDir.setWritable(true, false));
        Assert.assertTrue((boolean)ufsDir.setExecutable(true, false));
        FileInfo info = this.mFsMaster.getFileInfo(dir, GetStatusContext.mergeFrom((GetStatusPOptions.Builder)GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build())));
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)"dir", (Object)info.getName());
        int mode = info.getMode();
        Assert.assertTrue((boolean)ufsDir.setExecutable(false, false));
        info = this.mFsMaster.getFileInfo(dir, GetStatusContext.mergeFrom((GetStatusPOptions.Builder)GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build())));
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)"dir", (Object)info.getName());
        Assert.assertNotEquals((long)mode, (long)info.getMode());
        mode = info.getMode();
        this.mLocalAlluxioClusterResource.get().stopFS();
        try (FsMasterResource masterResource = this.createFileSystemMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            info = fsMaster.getFileInfo(dir, GetStatusContext.mergeFrom((GetStatusPOptions.Builder)GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L).build())));
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"dir", (Object)info.getName());
            Assert.assertEquals((long)mode, (long)info.getMode());
        }
    }

    @Test
    public void unavailableUfsRecursiveCreate() throws Exception {
        String ufsBase = "test://test/";
        UnderFileSystemFactory mockUfsFactory = (UnderFileSystemFactory)Mockito.mock(UnderFileSystemFactory.class);
        Mockito.when((Object)mockUfsFactory.supportsPath(ArgumentMatchers.anyString(), (UnderFileSystemConfiguration)ArgumentMatchers.any())).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mockUfsFactory.supportsPath((String)ArgumentMatchers.eq((Object)ufsBase), (UnderFileSystemConfiguration)ArgumentMatchers.any())).thenReturn((Object)Boolean.TRUE);
        UnderFileSystem mockUfs = (UnderFileSystem)Mockito.mock(UnderFileSystem.class);
        UfsDirectoryStatus ufsStatus = new UfsDirectoryStatus(TEST_USER, "owner", "group", 511);
        Mockito.when((Object)mockUfsFactory.create((String)ArgumentMatchers.eq((Object)ufsBase), (UnderFileSystemConfiguration)ArgumentMatchers.any())).thenReturn((Object)mockUfs);
        Mockito.when((Object)mockUfs.isDirectory(ufsBase)).thenReturn((Object)true);
        Mockito.when((Object)mockUfs.resolveUri(new AlluxioURI(ufsBase), "")).thenReturn((Object)new AlluxioURI(ufsBase));
        Mockito.when((Object)mockUfs.resolveUri(new AlluxioURI(ufsBase), "/dir1")).thenReturn((Object)new AlluxioURI(ufsBase + "/dir1"));
        Mockito.when((Object)mockUfs.getExistingDirectoryStatus(ufsBase)).thenReturn((Object)ufsStatus);
        Mockito.when((Object)mockUfs.mkdirs((String)ArgumentMatchers.eq((Object)(ufsBase + "/dir1")), (MkdirsOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException("ufs unavailable")});
        Mockito.when((Object)mockUfs.getStatus(ufsBase)).thenReturn((Object)ufsStatus);
        UnderFileSystemFactoryRegistry.register((UnderFileSystemFactory)mockUfsFactory);
        this.mFsMaster.mount(new AlluxioURI("/mnt"), new AlluxioURI(ufsBase), MountContext.defaults());
        AlluxioURI root = new AlluxioURI("/mnt/");
        AlluxioURI alluxioFile = new AlluxioURI("/mnt/dir1/dir2/file");
        try {
            this.mFsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setRecursive(true)).setWriteType(WriteType.CACHE_THROUGH));
            Assert.fail((String)"persisted create should fail, when UFS is unavailable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        List files = this.mFsMaster.listStatus(root, ListStatusContext.defaults());
        Assert.assertTrue((boolean)files.isEmpty());
        try {
            files = this.mFsMaster.listStatus(new AlluxioURI("/mnt/dir1/"), ListStatusContext.defaults());
            Assert.fail((String)"dir should not exist, when UFS is unavailable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mFsMaster.delete(new AlluxioURI("/mnt/dir1/"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
            Assert.fail((String)"cannot delete non-existing directory, when UFS is unavailable");
        }
        catch (Exception e) {
            files = null;
        }
        files = this.mFsMaster.listStatus(new AlluxioURI("/mnt/"), ListStatusContext.defaults());
        Assert.assertTrue((boolean)files.isEmpty());
        this.mLocalAlluxioClusterResource.get().stopFS();
        try (FsMasterResource masterResource = MasterTestUtils.createLeaderFileSystemMasterFromJournal();){
            FileSystemMaster newFsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            AuthenticatedClientUser.set((String)TEST_USER);
            files = newFsMaster.listStatus(new AlluxioURI("/mnt/"), ListStatusContext.defaults());
            Assert.assertTrue((boolean)files.isEmpty());
        }
    }

    @Test
    public void ufsModeReplay() throws Exception {
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.NO_ACCESS);
        this.mLocalAlluxioClusterResource.get().stopFS();
        try (FsMasterResource masterResource = this.createFileSystemMasterFromJournal();){
            FileSystemMaster fsMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            AlluxioURI alluxioFile = new AlluxioURI("/in_alluxio");
            this.mThrown.expect(AccessControlException.class);
            fsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.metastore", "HEAP"})
    public void updateAccessTimeAsyncFlush() throws Exception {
        FileSystemMaster fsm;
        String parentName = "d1";
        AlluxioURI parentPath = new AlluxioURI("/" + parentName);
        long parentId = this.mFsMaster.createDirectory(parentPath, CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(new Mode(448).toProto())));
        long oldAccessTime = this.mFsMaster.getFileInfo(parentId).getLastAccessTimeMs();
        Thread.sleep(100L);
        this.mFsMaster.listStatus(parentPath, ListStatusContext.defaults());
        long newAccessTime = this.mFsMaster.getFileInfo(parentId).getLastAccessTimeMs();
        Assert.assertNotEquals((long)newAccessTime, (long)oldAccessTime);
        try (FsMasterResource masterResource = this.createFileSystemMasterFromJournal();){
            fsm = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long journaledAccessTime = fsm.getFileInfo(parentId).getLastAccessTimeMs();
            Assert.assertEquals((long)journaledAccessTime, (long)oldAccessTime);
        }
        this.mLocalAlluxioClusterResource.get().stopFS();
        masterResource = this.createFileSystemMasterFromJournal();
        var10_7 = null;
        try {
            fsm = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long journaledAccessTimeAfterStop = fsm.getFileInfo(parentId).getLastAccessTimeMs();
            Assert.assertEquals((long)journaledAccessTimeAfterStop, (long)newAccessTime);
        }
        catch (Throwable throwable) {
            var10_7 = throwable;
            throw throwable;
        }
        finally {
            if (masterResource != null) {
                if (var10_7 != null) {
                    try {
                        masterResource.close();
                    }
                    catch (Throwable throwable) {
                        var10_7.addSuppressed(throwable);
                    }
                } else {
                    masterResource.close();
                }
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.metastore", "HEAP"})
    public void updateAccessTimeAsyncFlushAfterDelete() throws Exception {
        FileSystemMaster fsm;
        String parentName = "d1";
        AlluxioURI parentPath = new AlluxioURI("/" + parentName);
        long parentId = this.mFsMaster.createDirectory(parentPath, CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(new Mode(448).toProto())));
        long oldAccessTime = this.mFsMaster.getFileInfo(parentId).getLastAccessTimeMs();
        Thread.sleep(100L);
        this.mFsMaster.listStatus(parentPath, ListStatusContext.defaults());
        long newAccessTime = this.mFsMaster.getFileInfo(parentId).getLastAccessTimeMs();
        Assert.assertNotEquals((long)newAccessTime, (long)oldAccessTime);
        try (FsMasterResource masterResource = this.createFileSystemMasterFromJournal();){
            fsm = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            long journaledAccessTime = fsm.getFileInfo(parentId).getLastAccessTimeMs();
            Assert.assertEquals((long)journaledAccessTime, (long)oldAccessTime);
            this.mFsMaster.delete(parentPath, DeleteContext.defaults());
        }
        this.mLocalAlluxioClusterResource.get().stopFS();
        masterResource = this.createFileSystemMasterFromJournal();
        var10_7 = null;
        try {
            fsm = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            Assert.assertEquals((long)fsm.getFileId(parentPath), (long)-1L);
        }
        catch (Throwable throwable) {
            var10_7 = throwable;
            throw throwable;
        }
        finally {
            if (masterResource != null) {
                if (var10_7 != null) {
                    try {
                        masterResource.close();
                    }
                    catch (Throwable throwable) {
                        var10_7.addSuppressed(throwable);
                    }
                } else {
                    masterResource.close();
                }
            }
        }
    }
}

