/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.wire.MountPointInfo;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="the FSM does not exist in dora")
public class FileSystemReadonlyIntegrationTest {
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_READONLY, true).build();
    private FileSystem mFileSystem;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        FileSystemContext fsCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        fsCtx.getClientContext().loadConf(fsCtx.getMasterAddress(), true, true);
        this.mFileSystem = sLocalAlluxioClusterResource.get().getClient(fsCtx);
    }

    @Test
    public void rootMountIsReadonly() throws Exception {
        Map mountTable = this.mFileSystem.getMountTable();
        MountPointInfo rootInfo = (MountPointInfo)mountTable.get("/");
        TestCase.assertTrue((boolean)rootInfo.getReadOnly());
    }

    @Test
    public void rootMountWriteDenied() throws Exception {
        this.mThrown.expect(AccessControlException.class);
        this.mFileSystem.createFile(new AlluxioURI("/test"));
    }
}

