/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.gaul.s3proxy.junit.S3ProxyRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="yuyang", comment="the API should be validated")
public class FileSystemS3UfsIntegrationTest
extends BaseIntegrationTest {
    private static final String TEST_CONTENT = "TestContents";
    private static final String TEST_FILE = "test_file";
    private static final String TEST_FILE2 = "test_file2";
    private static final int USER_QUOTA_UNIT_BYTES = 1000;
    @Rule
    public S3ProxyRule mS3Proxy = S3ProxyRule.builder().withPort(8001).withCredentials("_", "_").build();
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, 1000).setProperty(PropertyKey.UNDERFS_S3_ENDPOINT, "localhost:8001").setProperty(PropertyKey.UNDERFS_S3_ENDPOINT_REGION, "us-west-2").setProperty(PropertyKey.UNDERFS_S3_DISABLE_DNS_BUCKETS, true).setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "s3://test-bucket").setProperty(PropertyKey.S3A_ACCESS_KEY, this.mS3Proxy.getAccessKey()).setProperty(PropertyKey.S3A_SECRET_KEY, this.mS3Proxy.getSecretKey()).setStartCluster(false).build();
    private FileSystem mFileSystem = null;
    private AmazonS3 mS3Client = null;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private static final String TEST_BUCKET = "test-bucket";

    @Before
    public void before() throws Exception {
        this.mS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.mS3Proxy.getAccessKey(), this.mS3Proxy.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.mS3Proxy.getUri().toString(), Regions.US_WEST_2.getName()))).build();
        this.mS3Client.createBucket(TEST_BUCKET);
        this.mLocalAlluxioClusterResource.start();
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @After
    public void after() {
        this.mS3Client = null;
    }

    @Test
    public void basicMetadataSync() throws IOException, AlluxioException {
        this.mS3Client.putObject(TEST_BUCKET, TEST_FILE, TEST_CONTENT);
        FileInStream fis = this.mFileSystem.openFile(new AlluxioURI("/test_file"));
        Assert.assertEquals((Object)TEST_CONTENT, (Object)IOUtils.toString((InputStream)fis, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void basicWriteThrough() throws IOException, AlluxioException {
        FileOutStream fos = this.mFileSystem.createFile(new AlluxioURI("/test_file2"), CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());
        fos.write(TEST_CONTENT.getBytes());
        fos.close();
        try (S3Object s3Object = this.mS3Client.getObject(TEST_BUCKET, TEST_FILE2);){
            Assert.assertEquals((Object)TEST_CONTENT, (Object)IOUtils.toString((InputStream)s3Object.getObjectContent(), (Charset)StandardCharsets.UTF_8));
        }
    }
}

