/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FileSystemUtilsIntegrationTest
extends BaseIntegrationTest {
    private static final int USER_QUOTA_UNIT_BYTES = 1000;
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, 1000).build();
    public static LocalAlluxioJobCluster sJobCluster;
    private static CreateFilePOptions sWriteBoth;
    private static FileSystem sFileSystem;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws Exception {
        sJobCluster = new LocalAlluxioJobCluster();
        sJobCluster.start();
        sFileSystem = sLocalAlluxioClusterResource.get().getClient();
        sWriteBoth = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build();
    }

    @Test
    public void waitCompletedTest1() throws IOException, AlluxioException, InterruptedException {
        String uniqPath = PathUtils.uniqPath();
        int numWrites = 4;
        final AlluxioURI uri = new AlluxioURI(uniqPath);
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try {
                    FileOutStream os = sFileSystem.createFile(uri, sWriteBoth);
                    boolean completed = sFileSystem.getStatus(uri).isCompleted();
                    Assert.assertFalse((boolean)completed);
                    for (int i = 0; i < 4; ++i) {
                        os.write(42);
                        CommonUtils.sleepMs((long)200L);
                    }
                    os.close();
                    completed = sFileSystem.getStatus(uri).isCompleted();
                    Assert.assertTrue((boolean)completed);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        Runnable waiter = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean completed = FileSystemUtils.waitCompleted((FileSystem)sFileSystem, (AlluxioURI)uri);
                    Assert.assertTrue((boolean)completed);
                    completed = sFileSystem.getStatus(uri).isCompleted();
                    Assert.assertTrue((boolean)completed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        Thread waitingThread = new Thread(waiter);
        waitingThread.start();
        Thread writingThread = new Thread(writer);
        writingThread.start();
        waitingThread.join();
        writingThread.join();
    }

    @Test
    public void waitCompletedTest2() throws IOException, AlluxioException, InterruptedException {
        String uniqPath = PathUtils.uniqPath();
        int numWrites = 4;
        final AlluxioURI uri = new AlluxioURI(uniqPath);
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try {
                    FileOutStream os = sFileSystem.createFile(uri, sWriteBoth);
                    boolean completed = sFileSystem.getStatus(uri).isCompleted();
                    Assert.assertFalse((boolean)completed);
                    for (int i = 0; i < 4; ++i) {
                        os.write(42);
                        CommonUtils.sleepMs((long)200L);
                    }
                    os.close();
                    completed = sFileSystem.getStatus(uri).isCompleted();
                    Assert.assertTrue((boolean)completed);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        Runnable waiter = new Runnable(){

            @Override
            public void run() {
                try {
                    String original = Configuration.getString((PropertyKey)PropertyKey.USER_FILE_WAITCOMPLETED_POLL_MS);
                    Configuration.set((PropertyKey)PropertyKey.USER_FILE_WAITCOMPLETED_POLL_MS, (Object)"100");
                    try {
                        boolean completed = FileSystemUtils.waitCompleted((FileSystem)sFileSystem, (AlluxioURI)uri, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
                        Assert.assertFalse((boolean)completed);
                        completed = sFileSystem.getStatus(uri).isCompleted();
                        Assert.assertFalse((boolean)completed);
                    }
                    finally {
                        Configuration.set((PropertyKey)PropertyKey.USER_FILE_WAITCOMPLETED_POLL_MS, (Object)original);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        Thread waitingThread = new Thread(waiter);
        waitingThread.start();
        Thread writingThread = new Thread(writer);
        writingThread.start();
        waitingThread.join();
        writingThread.join();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="check persist API")
    public void waitPersistTimeoutTest() throws Exception {
        String path = PathUtils.uniqPath();
        AlluxioURI alluxioPath = new AlluxioURI(path);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)path, (WritePType)WritePType.MUST_CACHE, (int)4096);
        Assert.assertFalse((String)"File cannot yet be persisted", (boolean)sFileSystem.getStatus(alluxioPath).isPersisted());
        this.mThrown.expect(TimeoutException.class);
        FileSystemUtils.persistAndWait((FileSystem)sFileSystem, (AlluxioURI)alluxioPath, (long)0L, (int)1);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="check persist API")
    public void waitPersistIndefiniteTimeoutTest() throws Exception {
        String path = PathUtils.uniqPath();
        AlluxioURI alluxioPath = new AlluxioURI(path);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)path, (WritePType)WritePType.MUST_CACHE, (int)4096);
        Assert.assertFalse((String)"File cannot yet be persisted", (boolean)sFileSystem.getStatus(alluxioPath).isPersisted());
        FileSystemUtils.persistAndWait((FileSystem)sFileSystem, (AlluxioURI)alluxioPath, (long)5000L, (int)-1);
        Assert.assertTrue((String)"File must be persisted", (boolean)sFileSystem.getStatus(alluxioPath).isPersisted());
    }

    static {
        sFileSystem = null;
    }
}

