/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.SetAttributePOptions;
import alluxio.security.CurrentUser;
import alluxio.security.authorization.Mode;
import alluxio.security.group.GroupMappingService;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="pending security features in dora")
public final class ImpersonationIntegrationTest
extends BaseIntegrationTest {
    private static final String IMPERSONATION_USER = "impersonation_user";
    private static final String IMPERSONATION_GROUP1 = "impersonation_group1";
    private static final String IMPERSONATION_GROUP2 = "impersonation_group2";
    private static final String HDFS_USER = "hdfs_user";
    private static final String HDFS_GROUP1 = "hdfs_group1";
    private static final String HDFS_GROUP2 = "hdfs_group2";
    private static final String CONNECTION_USER = "alluxio_user";
    private static final String IMPERSONATION_GROUPS_CONFIG = "alluxio.master.security.impersonation.alluxio_user.groups";
    private static final String IMPERSONATION_USERS_CONFIG = "alluxio.master.security.impersonation.alluxio_user.users";
    private static final HashMap<String, String> GROUPS = new HashMap();
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_METRICS_COLLECTION_ENABLED, false).setProperty(PropertyKey.SECURITY_LOGIN_USERNAME, "alluxio_user").setProperty(PropertyKey.SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS, 0).setProperty(PropertyKey.SECURITY_GROUP_MAPPING_CLASS, CustomGroupMapping.class.getName()).build();

    @After
    public void after() throws Exception {
        Configuration.reloadProperties();
    }

    @Before
    public void before() throws Exception {
        FileSystem.Factory.create().setAttribute(new AlluxioURI("/"), SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto()).build());
        Configuration.set((PropertyKey)PropertyKey.SECURITY_LOGIN_IMPERSONATION_USERNAME, (Object)"_HDFS_USER_");
    }

    @BeforeClass
    public static void beforeClass() {
        GROUPS.put(IMPERSONATION_USER, "impersonation_group1,impersonation_group2");
        GROUPS.put(HDFS_USER, "hdfs_group1,hdfs_group2");
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.groups", "*"})
    public void impersonationNotUsed() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.SECURITY_LOGIN_IMPERSONATION_USERNAME, (Object)"_NONE_");
        FileSystemContext context = FileSystemContext.create((Subject)this.createHdfsSubject(), (AlluxioConfiguration)Configuration.global());
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient(context);
        fs.createFile(new AlluxioURI("/impersonation-test")).close();
        List listing = fs.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)1L, (long)listing.size());
        URIStatus status = (URIStatus)listing.get(0);
        Assert.assertNotEquals((Object)IMPERSONATION_USER, (Object)status.getOwner());
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.groups", "*"})
    public void impersonationArbitraryUserDisallowed() throws Exception {
        String arbitraryUser = "arbitrary_user";
        Configuration.set((PropertyKey)PropertyKey.SECURITY_LOGIN_IMPERSONATION_USERNAME, (Object)arbitraryUser);
        FileSystemContext context = FileSystemContext.create((Subject)this.createHdfsSubject(), (AlluxioConfiguration)Configuration.global());
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient(context);
        fs.createFile(new AlluxioURI("/impersonation-test")).close();
        List listing = fs.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)1L, (long)listing.size());
        URIStatus status = (URIStatus)listing.get(0);
        Assert.assertNotEquals((Object)arbitraryUser, (Object)status.getOwner());
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.groups", "*"})
    public void impersonationUsedHdfsUser() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    public void impersonationHdfsDisabled() throws Exception {
        try {
            this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
            Assert.fail((String)"Connection succeeded, but impersonation should be denied.");
        }
        catch (UnauthenticatedException unauthenticatedException) {
            // empty catch block
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "hdfs_user"})
    public void impersonationHdfsUserAllowed() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "wrong_user1,wrong_user2,hdfs_user"})
    public void impersonationHdfsUsersAllowed() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "wrong_user"})
    public void impersonationHdfsUserDenied() throws Exception {
        try {
            this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
            Assert.fail((String)"Connection succeeded, but impersonation should be denied.");
        }
        catch (UnauthenticatedException unauthenticatedException) {
            // empty catch block
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "hdfs_user", "alluxio.master.security.impersonation.alluxio_user.groups", "hdfs_group1"})
    public void impersonationUsersAllowedGroupsAllowed() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "wrong_user", "alluxio.master.security.impersonation.alluxio_user.groups", "hdfs_group1"})
    public void impersonationUsersDeniedGroupsAllowed() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "hdfs_user", "alluxio.master.security.impersonation.alluxio_user.groups", "wrong_group"})
    public void impersonationUsersAllowedGroupsDenied() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.users", "wrong_user", "alluxio.master.security.impersonation.alluxio_user.groups", "wrong_group"})
    public void impersonationUsersDeniedGroupsDenied() throws Exception {
        try {
            this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
            Assert.fail((String)"Connection succeeded, but impersonation should be denied.");
        }
        catch (UnauthenticatedException unauthenticatedException) {
            // empty catch block
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.groups", "hdfs_group2"})
    public void impersonationHdfsGroupAllowed() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.groups", "impersonation_group1,impersonation_group2,hdfs_group1"})
    public void impersonationHdfsGroupsAllowed() throws Exception {
        this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.security.impersonation.alluxio_user.groups", "wrong_group"})
    public void impersonationHdfsGroupDenied() throws Exception {
        try {
            this.checkCreateFile(this.createHdfsSubject(), HDFS_USER);
            Assert.fail((String)"Connection succeeded, but impersonation should be denied.");
        }
        catch (UnauthenticatedException unauthenticatedException) {
            // empty catch block
        }
    }

    private void checkCreateFile(Subject subject, String expectedUser) throws Exception {
        FileSystemContext context = FileSystemContext.create((Subject)subject, (AlluxioConfiguration)Configuration.global());
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient(context);
        fs.createFile(new AlluxioURI("/impersonation-test")).close();
        List listing = fs.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)1L, (long)listing.size());
        URIStatus status = (URIStatus)listing.get(0);
        Assert.assertEquals((Object)expectedUser, (Object)status.getOwner());
    }

    private Subject createHdfsSubject() {
        CurrentUser user = new CurrentUser(HDFS_USER);
        HashSet<CurrentUser> principals = new HashSet<CurrentUser>();
        principals.add(user);
        return new Subject(false, principals, new HashSet(), new HashSet());
    }

    public static class CustomGroupMapping
    implements GroupMappingService {
        public List<String> getGroups(String user) {
            if (GROUPS.containsKey(user)) {
                return Lists.newArrayList((Object[])((String)GROUPS.get(user)).split(","));
            }
            return new ArrayList<String>();
        }
    }
}

