/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.meta.UfsAbsentPathCache;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import alluxio.wire.LoadMetadataType;
import alluxio.wire.MountPointInfo;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.powermock.reflect.Whitebox;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if the feature is still relevant")
public class LoadMetadataIntegrationTest
extends BaseIntegrationTest {
    private static final long SLEEP_MS = 500L;
    private static final int EXTRA_DIR_FILES = 6;
    private static final FileSystemMasterCommonPOptions PSYNC_ALWAYS = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build();
    private FileSystem mFileSystem;
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();
    private String mLocalUfsPath;
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_METADATA_SYNC_UFS_PREFETCH_POOL_SIZE, 2).setProperty(PropertyKey.MASTER_METADATA_SYNC_IGNORE_TTL, true).build();
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new SleepingUnderFileSystemFactory(new SleepingUnderFileSystemOptions().setGetStatusMs(500L).setExistsMs(500L).setListStatusMs(500L).setListStatusWithOptionsMs(500L)));

    @Before
    public void before() throws Exception {
        this.mLocalUfsPath = this.mTempFolder.getRoot().getAbsolutePath();
        this.mFileSystem = FileSystem.Factory.create();
        this.mFileSystem.mount(new AlluxioURI("/mnt/"), new AlluxioURI("sleep://" + this.mLocalUfsPath));
        new File(this.mLocalUfsPath + "/dir1/dirA/").mkdirs();
        FileWriter fileWriter = new FileWriter(this.mLocalUfsPath + "/dir1/dirA/file");
        fileWriter.write("test");
        fileWriter.close();
        FileOutStream stream = this.mFileSystem.createFile(new AlluxioURI("/mnt/mustcache/dir1/dir2/file1"), CreateFilePOptions.newBuilder().setRecursive(true).setWriteType(WritePType.MUST_CACHE).build());
        stream.write("test".getBytes(StandardCharsets.UTF_8));
        stream.close();
    }

    @After
    public void after() throws Exception {
        Configuration.reloadProperties();
    }

    @Test
    public void symLink() throws Exception {
        Path target = Paths.get(this.mLocalUfsPath + "/dir1/dirA/file", new String[0]);
        Path link = Paths.get(this.mLocalUfsPath + "/symlink", new String[0]);
        Files.createSymbolicLink(link, target, new FileAttribute[0]);
        Path target2 = Paths.get(this.mLocalUfsPath + "/dir1/dirA/", new String[0]);
        Path link2 = Paths.get(this.mLocalUfsPath + "/symlinkDir", new String[0]);
        Files.createSymbolicLink(link2, target2, new FileAttribute[0]);
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        List<URIStatus> statusList = this.checkListStatus("/mnt/", options, true, true, 3);
        Assert.assertEquals((long)4L, (long)statusList.size());
        Assert.assertTrue((boolean)statusList.stream().anyMatch(x -> x.getName().equals("symlink")));
        Assert.assertTrue((boolean)statusList.stream().anyMatch(x -> x.getName().equals("symlinkDir")));
        if (Files.exists(link, new LinkOption[0])) {
            Files.delete(link);
        }
        if (Files.exists(link2, new LinkOption[0])) {
            Files.delete(link2);
        }
    }

    @Test
    public void absentCacheListStatus() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkListStatus("/mnt/dir1/dirA/file", options, true, true, 3);
        this.checkListStatus("/mnt/dir1/dirA/file", options, true, true, 0);
        this.checkListStatus("/mnt/dir1/dirDNE", options, false, false, 1);
        this.checkListStatus("/mnt/dir1/dirDNE/dirDNE2/file1", options, false, false, 0);
    }

    @Test
    public void absentCacheGetStatus() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE2/file2", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE2", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/fileDNE", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/dirB/fileDNE", options, false, false, 0);
        GetStatusPOptions optionsAlways = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/", optionsAlways, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", optionsAlways, false, false, 1);
    }

    @Test
    public void absentCacheMustCache() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setRecursive(true).setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        GetStatusPOptions getStatusOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkListStatus("/mnt/mustcache/dir1/dir2", options, true, false, 1);
        this.checkListStatus("/mnt/mustcache/dir1", options, true, false, 1);
        this.checkListStatus("/mnt/mustcache", options, true, false, 1);
    }

    @Test
    public void repeatedDirectorySync() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setRecursive(true).setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkListStatus("/mnt/dir1/", options, true, true, 3);
        this.checkListStatus("/mnt/dir1/", options, true, true, 0);
    }

    @Test
    public void repeatedChildrenSync() throws Exception {
        ListStatusPOptions listOptions = ListStatusPOptions.newBuilder().setRecursive(true).setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        GetStatusPOptions getOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkGetStatus("/mnt/dir1/dirA/file", getOptions, true, true, 3);
        this.checkListStatus("/mnt/dir1/", listOptions, true, true, 3);
    }

    @Test
    public void syncOverrideLoadMetadata() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L)).build();
        this.checkGetStatus("/mnt/dir1/dirA/file", options, true, true, 3);
        this.checkGetStatus("/mnt/dir1/dirA/file", options, true, true, 1);
    }

    @Test
    public void loadMetadataListDir() throws Exception {
        ListStatusPOptions listOptions = ListStatusPOptions.newBuilder().setRecursive(false).setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L)).build();
        this.checkListStatus("/mnt/", listOptions, true, true, 3);
    }

    @Test
    public void loadMetadataAlways() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).build();
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE2", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/file", options, true, true, 3);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/", options, false, false, 1);
    }

    @Test
    public void loadMetadataNever() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build();
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, true, 0);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, true, 0);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE2", options, false, true, 0);
        this.checkGetStatus("/mnt/dir1/dirA/file", options, false, true, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/", options, false, true, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/fileDNE3", options, false, true, 0);
    }

    @Test
    public void loadMetadataOnce() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).build();
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE2", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/file", options, true, true, 3);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/dir1", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/dir1/file1", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirDNE/dir2", options, false, false, 0);
    }

    @Test
    public void loadMetadataOnceAfterUfsCreate() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).build();
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 1);
        Assert.assertTrue((boolean)new File(this.mLocalUfsPath + "/dir1/dirA/dirB").mkdirs());
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirB", GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).build(), true, true, 3);
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 0);
    }

    @Test
    public void listStatusLoadsFile() throws Exception {
        GetStatusPOptions getStatusOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).build();
        ListStatusPOptions lsOptions = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkListStatus("/mnt/dir1/dirA", lsOptions, true, true, 3);
        this.checkGetStatus("/mnt/dir1/dirA/file", getStatusOptions, true, true, 0);
    }

    @Test
    public void getStatusDoesNotLoadFile() throws Exception {
        GetStatusPOptions getStatusOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).build();
        ListStatusPOptions lsOptions = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkGetStatus("/mnt/dir1/dirA", getStatusOptions, true, true, 2);
        this.checkGetStatus("/mnt/dir1/dirA/file", getStatusOptions, true, true, 1);
    }

    @Test
    public void loadMetadataOnceAfterUfsDelete() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).build();
        Assert.assertTrue((boolean)new File(this.mLocalUfsPath + "/dir1/dirA/dirB").mkdirs());
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 0);
        Assert.assertTrue((boolean)new File(this.mLocalUfsPath + "/dir1/dirA/dirB").delete());
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 0);
        this.checkGetStatus("/mnt/dir1/dirA/dirB", GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).build(), false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/dirB/file", options, false, false, 0);
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.metadata.load.type", "ALWAYS"})
    @Test
    public void loadAlwaysConfiguration() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.getDefaultInstance();
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.metadata.load.type", "ONCE"})
    @Test
    public void loadOnceConfiguration() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.getDefaultInstance();
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 1);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, false, 0);
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.metadata.load.type", "NEVER"})
    @Test
    public void loadNeverConfiguration() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.getDefaultInstance();
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, true, 0);
        this.checkGetStatus("/mnt/dir1/dirA/fileDNE1", options, false, true, 0);
    }

    @Test
    public void loadRecursive() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_METADATA_LOAD_TYPE, (Object)LoadMetadataType.ONCE.toString());
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setRecursive(true).build();
        int createdInodes = this.createUfsFiles(5);
        List list = this.mFileSystem.listStatus(new AlluxioURI("/mnt"), options);
        Assert.assertEquals((long)(createdInodes + 6), (long)list.size());
    }

    @Test
    public void noTtlOnLoadedFiles() throws Exception {
        int created = this.createUfsFiles(2);
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_METADATA_LOAD_TYPE, (Object)LoadMetadataType.ONCE.toString());
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_CREATE_TTL, (Object)"11000");
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_CREATE_TTL_ACTION, (Object)TtlAction.FREE.toString());
        Configuration.set((PropertyKey)PropertyKey.MASTER_METADATA_SYNC_IGNORE_TTL, (Object)true);
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(10000L).setTtlAction(TtlAction.FREE).build()).build();
        List list = this.mFileSystem.listStatus(new AlluxioURI("/mnt"), options);
        Assert.assertEquals((long)(created + 6), (long)list.size());
        list.forEach(stat -> Assert.assertEquals((long)-1L, (long)stat.getTtl()));
    }

    @Test
    public void hasTtlOnLoadedFiles() throws Exception {
        int created = this.createUfsFiles(2);
        long expectedTtl = 1000000L;
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_METADATA_LOAD_TYPE, (Object)LoadMetadataType.ONCE.toString());
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_CREATE_TTL, (Object)"11000");
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_CREATE_TTL_ACTION, (Object)TtlAction.FREE.toString());
        Configuration.set((PropertyKey)PropertyKey.MASTER_METADATA_SYNC_IGNORE_TTL, (Object)false);
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(expectedTtl).setTtlAction(TtlAction.FREE).build()).build();
        List list = this.mFileSystem.listStatus(new AlluxioURI("/mnt"), options);
        Assert.assertEquals((long)(created + 6), (long)list.size());
        list.forEach(stat -> {
            if (stat.getPath().startsWith("/mnt/dir")) {
                Assert.assertEquals((long)expectedTtl, (long)stat.getTtl());
            }
        });
    }

    public int createUfsFiles(int loops) throws Exception {
        int count = 0;
        for (int i = 0; i < loops; ++i) {
            new File(this.mLocalUfsPath + "/dir" + i + "/").mkdirs();
            ++count;
            for (int j = 0; j < loops; ++j) {
                new File(this.mLocalUfsPath + "/dir" + i + "/dir" + j + "/").mkdirs();
                FileWriter fileWriter = new FileWriter(this.mLocalUfsPath + "/dir" + i + "/dir" + j + "/file");
                fileWriter.write("test" + i);
                fileWriter.close();
                count += 2;
            }
        }
        return count;
    }

    @Test(timeout=20000L)
    public void loadNonexistentSubpath() throws Exception {
        String rootUfs = ((MountPointInfo)this.mFileSystem.getMountTable().get("/")).getUfsUri();
        String subdirPath = "/i/dont/exist/in/alluxio";
        String ufsPath = PathUtils.concatPath((Object)rootUfs, (Object)subdirPath);
        Assert.assertTrue((boolean)new File(ufsPath).mkdirs());
        String filepath = PathUtils.concatPath((Object)ufsPath, (Object)"a");
        String data = "testtesttest";
        try (FileWriter w = new FileWriter(filepath);){
            w.write(data);
        }
        String alluxioPath = PathUtils.concatPath((Object)subdirPath, (Object)"a");
        URIStatus s = this.mFileSystem.getStatus(new AlluxioURI(alluxioPath), GetStatusPOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build()).build());
        Assert.assertFalse((boolean)s.isFolder());
        Assert.assertEquals((long)data.length(), (long)s.getLength());
        Assert.assertEquals((Object)"a", (Object)s.getName());
        Assert.assertTrue((boolean)s.isPersisted());
    }

    private URIStatus checkGetStatus(String path, GetStatusPOptions options, boolean expectExistsAlluxio, boolean expectExistsUfs, int expectedAccesses) throws Exception {
        return (URIStatus)this.checkFunctionCall(path, (statusPath, statusOption) -> this.mFileSystem.getStatus(new AlluxioURI(statusPath), (GetStatusPOptions)statusOption), (Message)options, expectExistsAlluxio, expectExistsUfs, expectedAccesses);
    }

    private List<URIStatus> checkListStatus(String path, ListStatusPOptions options, boolean expectExistsAlluxio, boolean expectExistsUfs, int expectedAccesses) throws Exception {
        return (List)this.checkFunctionCall(path, (statusPath, statusOption) -> this.mFileSystem.listStatus(new AlluxioURI(statusPath), (ListStatusPOptions)statusOption), (Message)options, expectExistsAlluxio, expectExistsUfs, expectedAccesses);
    }

    private Object checkFunctionCall(String path, CheckedBiFunction<String, Message, Object> function, Message options, boolean expectExistsAlluxio, boolean expectExistsUfs, int expectedAccesses) throws Exception {
        UfsAbsentPathCache cache;
        Object result;
        long startMs;
        block9: {
            startMs = CommonUtils.getCurrentMs();
            result = null;
            try {
                result = function.apply(path, options);
                UfsAbsentPathCache cache2 = this.getUfsAbsentPathCache();
                if (!expectExistsAlluxio) {
                    Assert.fail((String)("Path is not expected to exist: " + path));
                }
            }
            catch (FileDoesNotExistException e) {
                if (!expectExistsAlluxio) break block9;
                throw e;
            }
        }
        long durationMs = CommonUtils.getCurrentMs() - startMs;
        Assert.assertTrue((String)("Expected to be take between " + (long)expectedAccesses * 500L + " and " + ((double)expectedAccesses + 0.5) * 500.0 + ". actual duration (ms): " + durationMs), (durationMs >= (long)expectedAccesses * 500L && (double)durationMs < ((double)expectedAccesses + 0.5) * 500.0 ? 1 : 0) != 0);
        if (!expectExistsUfs) {
            cache = this.getUfsAbsentPathCache();
            try {
                CommonUtils.waitFor((String)("path (" + path + ") to be added to absent cache"), () -> cache.isAbsentSince(new AlluxioURI(path), -1L), (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(60000L));
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Absent Path Cache addition timed out");
            }
        }
        if (expectExistsUfs) {
            cache = this.getUfsAbsentPathCache();
            try {
                CommonUtils.waitFor((String)("path (" + path + ") to be removed from absent cache"), () -> {
                    if (cache.isAbsentSince(new AlluxioURI(path), -1L)) {
                        return false;
                    }
                    return true;
                }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(60000L));
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Absent Path Cache removal timed out");
            }
        }
        return result;
    }

    private UfsAbsentPathCache getUfsAbsentPathCache() {
        FileSystemMaster master = (FileSystemMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        return (UfsAbsentPathCache)Whitebox.getInternalState((Object)master, (String)"mUfsAbsentPathCache");
    }

    @FunctionalInterface
    public static interface CheckedBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }
}

