/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioTestDirectory;
import alluxio.ConfigurationRule;
import alluxio.ConfigurationTestUtils;
import alluxio.Process;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.master.AlluxioMasterProcess;
import alluxio.master.TestUtils;
import alluxio.network.TieredIdentityFactory;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.WorkerProcess;
import alluxio.worker.block.BlockWorker;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="this policy is still relevant but racking is no longer supported")
public class LocalFirstPolicyIntegrationTest
extends BaseIntegrationTest {
    private ExecutorService mExecutor;
    @Rule
    public ConfigurationRule mConf = new ConfigurationRule(LocalFirstPolicyIntegrationTest.conf(), Configuration.modifiableGlobal());

    private static Map<PropertyKey, Object> conf() {
        Map map = ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)Configuration.global(), (String)NetworkAddressUtils.getLocalHostName((int)((int)Configuration.getMs((PropertyKey)PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS))), (String)AlluxioTestDirectory.createTemporaryDirectory((String)"tiered_identity_test").getAbsolutePath());
        map.put(PropertyKey.WORKER_RPC_PORT, 0);
        map.put(PropertyKey.WORKER_WEB_PORT, 0);
        return map;
    }

    @Before
    public void before() {
        this.mExecutor = Executors.newCachedThreadPool();
    }

    @After
    public void after() {
        this.mExecutor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void localNodeFirst() throws Exception {
        AlluxioMasterProcess master = AlluxioMasterProcess.Factory.create();
        Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", (Object)TieredIdentityFactory.fromString((String)"node=node1,rack=rack1", (AlluxioConfiguration)Configuration.global()));
        WorkerProcess worker1 = WorkerProcess.Factory.create();
        Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", (Object)TieredIdentityFactory.fromString((String)"node=node2,rack=rack2", (AlluxioConfiguration)Configuration.global()));
        WorkerProcess worker2 = WorkerProcess.Factory.create();
        this.runProcess(this.mExecutor, (Process)master);
        this.runProcess(this.mExecutor, (Process)worker1);
        this.runProcess(this.mExecutor, (Process)worker2);
        TestUtils.waitForReady((Process)master);
        TestUtils.waitForReady((Process)worker1);
        TestUtils.waitForReady((Process)worker2);
        FileSystem fs = FileSystem.Factory.create();
        Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", (Object)TieredIdentityFactory.fromString((String)"node=node1,rack=rack1", (AlluxioConfiguration)Configuration.global()));
        try {
            FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/file1", (WritePType)WritePType.MUST_CACHE, (int)100);
        }
        finally {
            Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", null);
        }
        BlockWorker blockWorker1 = (BlockWorker)worker1.getWorker(BlockWorker.class);
        BlockWorker blockWorker2 = (BlockWorker)worker2.getWorker(BlockWorker.class);
        Assert.assertEquals((long)100L, (long)blockWorker1.getStoreMeta().getUsedBytes());
        Assert.assertEquals((long)0L, (long)blockWorker2.getStoreMeta().getUsedBytes());
        worker2.stop();
        worker1.stop();
        master.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void differentNodeOfSameRack() throws Exception {
        AlluxioMasterProcess master = AlluxioMasterProcess.Factory.create();
        Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", (Object)TieredIdentityFactory.fromString((String)"node=node1,rack=rack1", (AlluxioConfiguration)Configuration.global()));
        WorkerProcess worker1 = WorkerProcess.Factory.create();
        Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", (Object)TieredIdentityFactory.fromString((String)"node=node2,rack=rack2", (AlluxioConfiguration)Configuration.global()));
        WorkerProcess worker2 = WorkerProcess.Factory.create();
        this.runProcess(this.mExecutor, (Process)master);
        this.runProcess(this.mExecutor, (Process)worker1);
        this.runProcess(this.mExecutor, (Process)worker2);
        TestUtils.waitForReady((Process)master);
        TestUtils.waitForReady((Process)worker1);
        TestUtils.waitForReady((Process)worker2);
        FileSystem fs = FileSystem.Factory.create();
        Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", (Object)TieredIdentityFactory.fromString((String)"node=node3,rack=rack2", (AlluxioConfiguration)Configuration.global()));
        try {
            FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/file2", (WritePType)WritePType.MUST_CACHE, (int)10);
        }
        finally {
            Whitebox.setInternalState(TieredIdentityFactory.class, (String)"sInstance", null);
        }
        BlockWorker blockWorker1 = (BlockWorker)worker1.getWorker(BlockWorker.class);
        BlockWorker blockWorker2 = (BlockWorker)worker2.getWorker(BlockWorker.class);
        Assert.assertEquals((long)0L, (long)blockWorker1.getStoreMeta().getUsedBytes());
        Assert.assertEquals((long)10L, (long)blockWorker2.getStoreMeta().getUsedBytes());
        worker2.stop();
        worker1.stop();
        master.stop();
    }

    private void runProcess(ExecutorService e, Process p) {
        e.execute(() -> {
            try {
                p.start();
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        });
    }
}

