/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.meta.MetaMasterConfigClient;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.MasterClientContext;
import alluxio.testutils.LocalAlluxioClusterResource;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class PathConfigurationIntegrationTest {
    private static final byte[] TEST_BYTES = "TestBytes".getBytes();
    private static final int USER_QUOTA_UNIT_BYTES = 1000;
    private static final String REMOTE_DIR = "/remote/";
    private static final String REMOTE_UNCACHED_FILE = "/remote/0";
    private static final String LOCAL_DIR = "/local/";
    private static final String LOCAL_CACHED_FILE = "/local/0";
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, 1000).build();
    private MetaMasterConfigClient mMetaConfig;
    private FileSystem mFileSystem;
    private CreateFilePOptions mWriteThrough;

    private void setPathConfigurations(MetaMasterConfigClient client) throws Exception {
        client.setPathConfiguration(new AlluxioURI(REMOTE_DIR), PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.CACHE.toString());
        client.setPathConfiguration(new AlluxioURI(REMOTE_UNCACHED_FILE), PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.NO_CACHE.toString());
        client.setPathConfiguration(new AlluxioURI(LOCAL_DIR), PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.NO_CACHE.toString());
        client.setPathConfiguration(new AlluxioURI(LOCAL_CACHED_FILE), PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.CACHE.toString());
    }

    @Before
    public void before() throws Exception {
        FileSystemContext metaCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        this.mMetaConfig = new RetryHandlingMetaMasterConfigClient(MasterClientContext.newBuilder((ClientContext)metaCtx.getClientContext()).build());
        this.setPathConfigurations(this.mMetaConfig);
        FileSystemContext fsCtx = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        fsCtx.getClientContext().loadConf(fsCtx.getMasterAddress(), true, true);
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient(fsCtx);
        this.mWriteThrough = CreateFilePOptions.newBuilder().setRecursive(true).setWriteType(WritePType.THROUGH).build();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix the test here with remote worker")
    public void read() throws Exception {
        int i;
        String[] dirs;
        int n = 3;
        for (String dir : dirs = new String[]{REMOTE_DIR, LOCAL_DIR}) {
            for (int i2 = 0; i2 < 3; ++i2) {
                AlluxioURI uri = new AlluxioURI(dir + i2);
                try (FileOutStream os = this.mFileSystem.createFile(uri, this.mWriteThrough);){
                    os.write(TEST_BYTES);
                    continue;
                }
            }
        }
        this.checkCacheStatus(REMOTE_UNCACHED_FILE, false);
        for (i = 1; i < 3; ++i) {
            this.checkCacheStatus(REMOTE_DIR + i, true);
        }
        this.checkCacheStatus(LOCAL_CACHED_FILE, true);
        for (i = 1; i < 3; ++i) {
            this.checkCacheStatus(LOCAL_DIR + i, false);
        }
    }

    private void checkCacheStatus(String path, boolean shouldCache) throws Exception {
        AlluxioURI uri = new AlluxioURI(path);
        Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(uri).getInMemoryPercentage());
        try (FileInStream is = this.mFileSystem.openFile(uri);){
            IOUtils.copy((InputStream)is, (OutputStream)ByteStreams.nullOutputStream());
        }
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)(shouldCache ? 100 : 0));
    }
}

