/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.io.AbstractFileOutStreamIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.file.meta.PersistenceState;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="pending on perm features in dora")
public final class PersistPermissionIntegrationTest
extends AbstractFileOutStreamIntegrationTest {
    private String mUfsRoot;
    private UnderFileSystem mUfs;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.mUfsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        this.mUfs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
    }

    @Test
    public void syncPersistPermission() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)this.mUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)this.mUfs) ? 1 : 0) != 0);
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build());
        os.write(0);
        os.write(1);
        os.close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        short fileMode = (short)status.getMode();
        short parentMode = (short)this.mFileSystem.getStatus(filePath.getParent()).getMode();
        Assert.assertEquals((long)fileMode, (long)this.mUfs.getFileStatus(PathUtils.concatPath((Object)this.mUfsRoot, (Object)filePath)).getMode());
        Assert.assertEquals((long)parentMode, (long)this.mUfs.getDirectoryStatus(PathUtils.concatPath((Object)this.mUfsRoot, (Object)filePath.getParent())).getMode());
    }

    @Test
    public void asyncPersistPermission() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)this.mUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)this.mUfs) ? 1 : 0) != 0);
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setRecursive(true).build());
        os.write(0);
        os.write(1);
        os.close();
        CommonUtils.sleepMs((long)1L);
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        short fileMode = (short)status.getMode();
        short parentMode = (short)this.mFileSystem.getStatus(filePath.getParent()).getMode();
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, filePath);
        status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertEquals((long)fileMode, (long)this.mUfs.getFileStatus(PathUtils.concatPath((Object)this.mUfsRoot, (Object)filePath)).getMode());
        Assert.assertEquals((long)parentMode, (long)this.mUfs.getDirectoryStatus(PathUtils.concatPath((Object)this.mUfsRoot, (Object)filePath.getParent())).getMode());
    }

    @Test
    public void asyncPersistEmptyFilePermission() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)this.mUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)this.mUfs) ? 1 : 0) != 0);
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setRecursive(true).build()).close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertNotEquals((Object)PersistenceState.PERSISTED, (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        short fileMode = (short)status.getMode();
        short parentMode = (short)this.mFileSystem.getStatus(filePath.getParent()).getMode();
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, filePath);
        status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertEquals((long)fileMode, (long)this.mUfs.getFileStatus(PathUtils.concatPath((Object)this.mUfsRoot, (Object)filePath)).getMode());
        Assert.assertEquals((long)parentMode, (long)this.mUfs.getDirectoryStatus(PathUtils.concatPath((Object)this.mUfsRoot, (Object)filePath.getParent())).getMode());
    }
}

