/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.MasterClientContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.PathUtils;
import alluxio.wire.LoadMetadataType;
import alluxio.worker.file.FileSystemMasterClient;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.powermock.core.classloader.annotations.PrepareForTest;

@PrepareForTest(value={FileSystemContext.class})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if pinning will be kept in dora")
public final class PinIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).build();
    private FileSystem mFileSystem = null;
    private FileSystemMasterClient mFSMasterClient;
    private SetAttributePOptions mSetPinned;
    private SetAttributePOptions mUnsetPinned;
    private String mLocalUfsPath = Files.createTempDir().getAbsolutePath();
    private static final FileSystemMasterCommonPOptions SYNC_ALWAYS = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build();
    private static final FileSystemMasterCommonPOptions SYNC_NEVER = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L).build();

    @Before
    public final void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        this.mFSMasterClient = new FileSystemMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        this.mSetPinned = SetAttributePOptions.newBuilder().setPinned(true).build();
        this.mUnsetPinned = SetAttributePOptions.newBuilder().setPinned(false).build();
        this.mFileSystem.mount(new AlluxioURI("/mnt/"), new AlluxioURI(this.mLocalUfsPath));
    }

    @After
    public final void after() throws Exception {
        this.mFSMasterClient.close();
    }

    @Test
    public void recursivePinness() throws Exception {
        AlluxioURI folderURI = new AlluxioURI("/myFolder");
        AlluxioURI fileURI = new AlluxioURI("/myFolder/myFile");
        this.mFileSystem.createDirectory(folderURI);
        this.createEmptyFile(fileURI);
        Assert.assertFalse((boolean)this.mFileSystem.getStatus(fileURI).isPinned());
        this.mFileSystem.setAttribute(fileURI, this.mSetPinned);
        URIStatus status = this.mFileSystem.getStatus(fileURI);
        Assert.assertTrue((boolean)status.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status.getFileId()}));
        this.mFileSystem.setAttribute(fileURI, this.mUnsetPinned);
        status = this.mFileSystem.getStatus(fileURI);
        Assert.assertFalse((boolean)status.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), new HashSet());
        this.mFileSystem.setAttribute(folderURI, this.mSetPinned);
        status = this.mFileSystem.getStatus(fileURI);
        Assert.assertTrue((boolean)status.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status.getFileId()}));
        this.mFileSystem.setAttribute(folderURI, this.mUnsetPinned);
        status = this.mFileSystem.getStatus(fileURI);
        Assert.assertFalse((boolean)status.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), new HashSet());
        this.mFileSystem.setAttribute(fileURI, this.mSetPinned);
        status = this.mFileSystem.getStatus(fileURI);
        Assert.assertTrue((boolean)status.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status.getFileId()}));
    }

    @Test
    public void newFilesInheritPinness() throws Exception {
        this.mFileSystem.setAttribute(new AlluxioURI("/"), this.mSetPinned);
        AlluxioURI file0 = new AlluxioURI("/file0");
        this.createEmptyFile(file0);
        URIStatus status0 = this.mFileSystem.getStatus(file0);
        Assert.assertTrue((boolean)status0.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status0.getFileId()}));
        AlluxioURI folder = new AlluxioURI("/folder");
        this.mFileSystem.createDirectory(folder);
        Assert.assertTrue((boolean)this.mFileSystem.getStatus(folder).isPinned());
        AlluxioURI file1 = new AlluxioURI("/folder/file1");
        this.createEmptyFile(file1);
        URIStatus status1 = this.mFileSystem.getStatus(file1);
        Assert.assertTrue((boolean)status1.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status0.getFileId(), status1.getFileId()}));
        this.mFileSystem.setAttribute(folder, this.mUnsetPinned);
        Assert.assertFalse((boolean)this.mFileSystem.getStatus(folder).isPinned());
        Assert.assertFalse((boolean)this.mFileSystem.getStatus(file1).isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status0.getFileId()}));
        this.createEmptyFile(new AlluxioURI("/folder/file2"));
        Assert.assertFalse((boolean)this.mFileSystem.getStatus(new AlluxioURI("/folder/file2")).isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status0.getFileId()}));
        this.createEmptyFile(new AlluxioURI("/file3"));
        URIStatus status3 = this.mFileSystem.getStatus(new AlluxioURI("/file3"));
        Assert.assertTrue((boolean)status3.isPinned());
        Assert.assertEquals(new HashSet(this.mFSMasterClient.getPinList()), (Object)Sets.newHashSet((Object[])new Long[]{status0.getFileId(), status3.getFileId()}));
    }

    @Test
    public void pinDiscoverNewFiles() throws Exception {
        String deeplyNestedDir = "/tmp/tmp2/tmp3";
        new File(this.ufsPath(deeplyNestedDir)).mkdirs();
        FileWriter fileWriter = new FileWriter(this.ufsPath(PathUtils.concatPath((Object)deeplyNestedDir, (Object)"/newfile")));
        fileWriter.write("test");
        fileWriter.close();
        SetAttributePOptions attributeOption = SetAttributePOptions.newBuilder().setPinned(true).setCommonOptions(SYNC_ALWAYS).build();
        GetStatusPOptions getStatusOption = GetStatusPOptions.newBuilder().setCommonOptions(SYNC_NEVER).build();
        this.mFileSystem.setAttribute(new AlluxioURI("/mnt/tmp/"), attributeOption);
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_METADATA_LOAD_TYPE, (Object)LoadMetadataType.NEVER.toString());
        URIStatus dirStat = this.mFileSystem.getStatus(new AlluxioURI("/mnt/tmp/"), getStatusOption);
        URIStatus fileStat = this.mFileSystem.getStatus(new AlluxioURI(PathUtils.concatPath((Object)"/mnt", (Object[])new Object[]{deeplyNestedDir, "newfile"})), getStatusOption);
        Assert.assertTrue((boolean)dirStat.isPinned());
        Assert.assertTrue((boolean)fileStat.isPinned());
    }

    private String ufsPath(String path) {
        return PathUtils.concatPath((Object)this.mLocalUfsPath, (Object)path);
    }

    private void createEmptyFile(AlluxioURI fileURI) throws IOException, AlluxioException {
        CreateFilePOptions options = CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build();
        FileOutStream os = this.mFileSystem.createFile(fileURI, options);
        os.close();
    }
}

