/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.security.authorization.Mode;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if this feature is still relevant")
public class ReadOnlyMountIntegrationTest
extends BaseIntegrationTest {
    private static final String MOUNT_PATH = PathUtils.concatPath((Object)"/", (Object[])new Object[]{"mnt", "foo"});
    private static final String FILE_PATH = PathUtils.concatPath((Object)MOUNT_PATH, (Object)"file");
    private static final String SUB_DIR_PATH = PathUtils.concatPath((Object)MOUNT_PATH, (Object[])new Object[]{"sub", "dir"});
    private static final String SUB_FILE_PATH = PathUtils.concatPath((Object)SUB_DIR_PATH, (Object)"subfile");
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private FileSystem mFileSystem = null;
    private UnderFileSystem mUfs;
    private String mAlternateUfsRoot;

    @Before
    public void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        AlluxioURI parentURI = new AlluxioURI(Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS)).getParent();
        this.mUfs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
        this.mAlternateUfsRoot = parentURI.join("alternateUnderFSStorage").toString();
        String ufsMountDir = PathUtils.concatPath((Object)this.mAlternateUfsRoot, (Object)MOUNT_PATH);
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)this.mAlternateUfsRoot);
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)ufsMountDir);
        UnderFileSystemUtils.touch((UnderFileSystem)this.mUfs, (String)PathUtils.concatPath((Object)this.mAlternateUfsRoot, (Object)FILE_PATH));
        UnderFileSystemUtils.mkdirIfNotExists((UnderFileSystem)this.mUfs, (String)PathUtils.concatPath((Object)this.mAlternateUfsRoot, (Object)SUB_DIR_PATH));
        UnderFileSystemUtils.touch((UnderFileSystem)this.mUfs, (String)PathUtils.concatPath((Object)this.mAlternateUfsRoot, (Object)SUB_FILE_PATH));
        this.mFileSystem.createDirectory(new AlluxioURI("/mnt"));
        this.mFileSystem.mount(new AlluxioURI(MOUNT_PATH), new AlluxioURI(ufsMountDir), MountPOptions.newBuilder().setReadOnly(true).build());
    }

    @After
    public void after() throws Exception {
        UnderFileSystemUtils.deleteDirIfExists((UnderFileSystem)this.mUfs, (String)this.mAlternateUfsRoot);
    }

    @Test
    public void createFile() throws IOException, AlluxioException {
        CreateFilePOptions writeBoth = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        AlluxioURI uri = new AlluxioURI(FILE_PATH + "_create");
        try {
            this.mFileSystem.createFile(uri, writeBoth).close();
            Assert.fail((String)"createFile should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
        uri = new AlluxioURI(SUB_FILE_PATH + "_create");
        try {
            this.mFileSystem.createFile(uri, writeBoth).close();
            Assert.fail((String)"createFile should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
    }

    @Test
    public void createDirectory() throws IOException, AlluxioException {
        AlluxioURI uri = new AlluxioURI(PathUtils.concatPath((Object)MOUNT_PATH, (Object)"create"));
        try {
            this.mFileSystem.createDirectory(uri);
            Assert.fail((String)"createDirectory should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
        uri = new AlluxioURI(PathUtils.concatPath((Object)SUB_DIR_PATH, (Object)"create"));
        try {
            this.mFileSystem.createDirectory(uri);
            Assert.fail((String)"createDirectory should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
    }

    @Test
    public void deleteFile() throws IOException, AlluxioException {
        AlluxioURI fileUri = new AlluxioURI(FILE_PATH);
        try {
            this.mFileSystem.delete(fileUri);
            Assert.fail((String)"deleteFile should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{fileUri, MOUNT_PATH})));
        }
        Assert.assertTrue((boolean)this.mFileSystem.exists(fileUri));
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileUri));
        fileUri = new AlluxioURI(SUB_FILE_PATH);
        try {
            this.mFileSystem.delete(fileUri);
            Assert.fail((String)"deleteFile should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{fileUri, MOUNT_PATH})));
        }
        Assert.assertTrue((boolean)this.mFileSystem.exists(fileUri));
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileUri));
    }

    @Test
    public void getFileStatus() throws IOException, AlluxioException {
        AlluxioURI fileUri = new AlluxioURI(FILE_PATH);
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileUri));
        fileUri = new AlluxioURI(SUB_FILE_PATH);
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileUri));
    }

    @Test
    public void renameFile() throws IOException, AlluxioException {
        AlluxioURI srcUri = new AlluxioURI(FILE_PATH);
        AlluxioURI dstUri = new AlluxioURI(FILE_PATH + "_renamed");
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"rename should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{srcUri, MOUNT_PATH})));
        }
        srcUri = new AlluxioURI(SUB_FILE_PATH);
        dstUri = new AlluxioURI(SUB_FILE_PATH + "_renamed");
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"rename should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{srcUri, MOUNT_PATH})));
        }
    }

    @Test
    public void renameFileDst() throws IOException, AlluxioException {
        AlluxioURI srcUri = new AlluxioURI("/tmp");
        AlluxioURI dstUri = new AlluxioURI(FILE_PATH + "_renamed");
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"rename should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{dstUri, MOUNT_PATH})));
        }
        dstUri = new AlluxioURI(SUB_FILE_PATH + "_renamed");
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"rename should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{dstUri, MOUNT_PATH})));
        }
    }

    @Test
    public void renameFileSrc() throws IOException, AlluxioException {
        AlluxioURI srcUri = new AlluxioURI(FILE_PATH);
        AlluxioURI dstUri = new AlluxioURI("/tmp");
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"rename should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{srcUri, MOUNT_PATH})));
        }
        srcUri = new AlluxioURI(SUB_FILE_PATH);
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"rename should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{srcUri, MOUNT_PATH})));
        }
    }

    @Test
    public void renameDirectory() throws IOException, AlluxioException {
        AlluxioURI srcUri = new AlluxioURI(SUB_DIR_PATH);
        AlluxioURI dstUri = new AlluxioURI(SUB_DIR_PATH + "_renamed");
        try {
            this.mFileSystem.rename(srcUri, dstUri);
            Assert.fail((String)"renameDirectory should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{srcUri, MOUNT_PATH})));
        }
    }

    @Test
    public void loadMetadata() throws IOException, AlluxioException {
        AlluxioURI fileUri = new AlluxioURI(FILE_PATH);
        try {
            this.mFileSystem.getStatus(fileUri, GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build());
            Assert.fail((String)"File should not exist before loading metadata.");
        }
        catch (FileDoesNotExistException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{FILE_PATH}));
        }
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileUri));
        fileUri = new AlluxioURI(SUB_FILE_PATH);
        try {
            this.mFileSystem.getStatus(fileUri, GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build());
            Assert.fail((String)"File should not exist before loading metadata.");
        }
        catch (FileDoesNotExistException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{SUB_FILE_PATH}));
        }
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(fileUri));
    }

    @Test
    public void openFile() throws IOException, AlluxioException {
        AlluxioURI fileUri = new AlluxioURI(FILE_PATH);
        FileInStream inStream = this.mFileSystem.openFile(fileUri);
        Assert.assertNotNull((Object)inStream);
        inStream.close();
        fileUri = new AlluxioURI(SUB_FILE_PATH);
        inStream = this.mFileSystem.openFile(fileUri);
        Assert.assertNotNull((Object)inStream);
        inStream.close();
    }

    @Test
    public void setAttribute() throws IOException, AlluxioException {
        AlluxioURI fileUri = new AlluxioURI(FILE_PATH);
        this.mFileSystem.setAttribute(fileUri, SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build()).setPinned(true).setReplicationMax(10).setReplicationMin(1).build());
    }

    @Test
    public void chmod() throws IOException, AlluxioException {
        AlluxioURI uri = new AlluxioURI(FILE_PATH + "_chmod");
        try {
            this.mFileSystem.setAttribute(uri, SetAttributePOptions.newBuilder().setMode(new Mode(365).toProto()).build());
            Assert.fail((String)"chomd should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
    }

    @Test
    public void chgrp() throws IOException, AlluxioException {
        AlluxioURI uri = new AlluxioURI(FILE_PATH + "_chgrp");
        try {
            this.mFileSystem.setAttribute(uri, SetAttributePOptions.newBuilder().setGroup("foo").build());
            Assert.fail((String)"chgrp should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
    }

    @Test
    public void chown() throws IOException, AlluxioException {
        AlluxioURI uri = new AlluxioURI(FILE_PATH + "_chown");
        try {
            this.mFileSystem.setAttribute(uri, SetAttributePOptions.newBuilder().setOwner("foo").build());
            Assert.fail((String)"chown should not succeed under a readonly mount.");
        }
        catch (AccessControlException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)ExceptionMessage.MOUNT_READONLY.getMessage(new Object[]{uri, MOUNT_PATH})));
        }
    }
}

