/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.heartbeat.HeartbeatScheduler;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="check if this feature is still relevant")
public class TtlIntegrationTest
extends BaseIntegrationTest {
    private static final int TTL_INTERVAL_MS = 50;
    private FileSystem mFileSystem;
    private FileOutStream mOutStream = null;
    protected byte[] mBuffer;
    @ClassRule
    public static ManuallyScheduleHeartbeat sManuallySchedule = new ManuallyScheduleHeartbeat(new String[]{"Master TTL Check"});
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    public File mUfs = AlluxioTestDirectory.createTemporaryDirectory((String)"RootUfs");
    private String mLocalUfsPath = this.mUfs.getAbsolutePath();
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, this.mLocalUfsPath).setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, 50).setProperty(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.NEVER).build();

    @Before
    public void before() throws Exception {
        this.mFileSystem = FileSystem.Factory.create();
        this.mBuffer = new byte[10];
        Arrays.fill(this.mBuffer, (byte)65);
    }

    @Test
    public void expireManyAfterDeleteAlluxio() throws Exception {
        int i;
        int numFiles = 100;
        AlluxioURI[] files = new AlluxioURI[numFiles];
        for (i = 0; i < numFiles; ++i) {
            files[i] = new AlluxioURI("/file" + i);
            long ttl = i % 2 == 0 ? 25L : 50000L;
            this.mOutStream = this.mFileSystem.createFile(files[i], CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl).setTtlAction(TtlAction.DELETE_ALLUXIO)).build());
            this.mOutStream.write(this.mBuffer, 0, 10);
            this.mOutStream.close();
            if (i % 20 != 0) continue;
            this.mFileSystem.delete(files[i]);
        }
        CommonUtils.sleepMs((long)100L);
        HeartbeatScheduler.execute((String)"Master TTL Check");
        for (i = 0; i < numFiles; ++i) {
            if (i % 2 == 0) {
                Assert.assertFalse((boolean)this.mFileSystem.exists(files[i]));
                if (i % 20 == 0) continue;
                String fileName = "file" + i;
                Assert.assertTrue((boolean)Arrays.stream(this.mUfs.list()).anyMatch(s -> s.equals(fileName)));
                continue;
            }
            Assert.assertTrue((boolean)this.mFileSystem.exists(files[i]));
        }
    }

    @Test
    public void expireManyAfterFree() throws Exception {
        int i;
        int numFiles = 100;
        AlluxioURI[] files = new AlluxioURI[numFiles];
        for (i = 0; i < numFiles; ++i) {
            files[i] = new AlluxioURI("/fileFree" + i);
            long ttl = i % 2 == 0 ? 25L : 50000L;
            this.mOutStream = this.mFileSystem.createFile(files[i], CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl)).build());
            this.mOutStream.write(this.mBuffer, 0, 10);
            this.mOutStream.close();
            if (i % 20 != 0) continue;
            this.mFileSystem.delete(files[i]);
        }
        CommonUtils.sleepMs((long)100L);
        HeartbeatScheduler.execute((String)"Master TTL Check");
        for (i = 0; i < numFiles; ++i) {
            if (i % 2 == 0) {
                if (i % 20 == 0) continue;
                Assert.assertEquals((long)-1L, (long)this.mFileSystem.getStatus(files[i]).getTtl());
                Assert.assertEquals((Object)TtlAction.DELETE, (Object)this.mFileSystem.getStatus(files[i]).getTtlAction());
                Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(files[i]).getInMemoryPercentage());
                String fileName = "fileFree" + i;
                Assert.assertTrue((boolean)Arrays.stream(this.mUfs.list()).anyMatch(s -> s.equals(fileName)));
                continue;
            }
            Assert.assertTrue((boolean)this.mFileSystem.exists(files[i]));
            Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(files[i]).getInMemoryPercentage());
        }
    }

    @Test
    public void expireManyAfterDelete() throws Exception {
        int i;
        int numFiles = 100;
        AlluxioURI[] files = new AlluxioURI[numFiles];
        for (i = 0; i < numFiles; ++i) {
            files[i] = new AlluxioURI("/fileDelete" + i);
            long ttl = i % 2 == 0 ? 25L : 50000L;
            this.mOutStream = this.mFileSystem.createFile(files[i], CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl).setTtlAction(TtlAction.DELETE)).build());
            this.mOutStream.write(this.mBuffer, 0, 10);
            this.mOutStream.close();
            if (i % 20 != 0) continue;
            this.mFileSystem.delete(files[i]);
        }
        CommonUtils.sleepMs((long)200L);
        HeartbeatScheduler.execute((String)"Master TTL Check");
        for (i = 0; i < numFiles; ++i) {
            if (i % 2 == 0) {
                Assert.assertFalse((boolean)this.mFileSystem.exists(files[i]));
                String fileName = "fileDelete" + i;
                Assert.assertFalse((boolean)Arrays.stream(this.mUfs.list()).anyMatch(s -> s.equals(fileName)));
                continue;
            }
            Assert.assertTrue((boolean)this.mFileSystem.exists(files[i]));
        }
    }

    @Test
    public void expireADirectory() throws Exception {
        int numFiles = 100;
        AlluxioURI[] files = new AlluxioURI[numFiles];
        String directoryName = "dir1";
        this.mFileSystem.createDirectory(new AlluxioURI("/" + directoryName), CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());
        String fileNamePrefix = "fileDelete";
        for (int i = 0; i < numFiles; ++i) {
            files[i] = new AlluxioURI("/" + directoryName + "/" + fileNamePrefix + i);
            long ttl = i % 2 == 0 ? 100000L : 50000L;
            this.mOutStream = this.mFileSystem.createFile(files[i], CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl).setTtlAction(TtlAction.DELETE)).build());
            this.mOutStream.write(this.mBuffer, 0, 10);
            this.mOutStream.close();
        }
        SetAttributePOptions setTTlOptions = SetAttributePOptions.newBuilder().setRecursive(false).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(50L).setTtlAction(TtlAction.DELETE).build()).build();
        this.mFileSystem.setAttribute(new AlluxioURI("/" + directoryName), setTTlOptions);
        Random random = new Random();
        int fileNum = random.nextInt(numFiles);
        URIStatus anyFileStatus = this.mFileSystem.getStatus(new AlluxioURI("/" + directoryName + "/" + fileNamePrefix + fileNum));
        assert (anyFileStatus.getFileInfo().getTtl() == (long)(fileNum % 2 == 0 ? 100000 : 50000));
        CommonUtils.sleepMs((long)200L);
        HeartbeatScheduler.execute((String)"Master TTL Check");
        for (int i = 0; i < numFiles; ++i) {
            Assert.assertFalse((boolean)this.mFileSystem.exists(files[i]));
            String fileName = directoryName + "/" + fileNamePrefix + i;
            Assert.assertFalse((boolean)Arrays.stream(this.mUfs.list()).anyMatch(s -> s.equals(fileName)));
        }
    }
}

