/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.MasterClientContext;
import alluxio.security.authorization.Mode;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.FileUtils;
import alluxio.util.io.PathUtils;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import io.grpc.Context;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if this feature is still relevant")
public class UfsSyncIntegrationTest
extends BaseIntegrationTest {
    private static final long INTERVAL_MS = 100L;
    private static final long LARGE_INTERVAL_MS = 1000L;
    private static final FileSystemMasterCommonPOptions PSYNC_NEVER = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L).build();
    private static final FileSystemMasterCommonPOptions PSYNC_ALWAYS = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build();
    private static final FileSystemMasterCommonPOptions PSYNC_INTERVAL = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(100L).build();
    private static final FileSystemMasterCommonPOptions PSYNC_LARGE_INTERVAL = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(1000L).build();
    private static final String ROOT_DIR = "/";
    private static final String EXISTING_DIR = "/dir_exist";
    private static final String NEW_FILE_UNDER_DIR = "/dir_exist/file_new";
    private static final String EXISTING_FILE = "/file_exist";
    private static final String NEW_DIR = "/dir_new";
    private static final String NEW_FILE = "/file_new";
    private static final String NEW_NESTED_FILE = "/a/b/file_new";
    private FileSystem mFileSystem;
    private String mLocalUfsPath = Files.createTempDir().getAbsolutePath();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 5).setProperty(PropertyKey.MASTER_METADATA_SYNC_CONCURRENCY_LEVEL, 10).setProperty(PropertyKey.MASTER_METADATA_SYNC_EXECUTOR_POOL_SIZE, 10).build();

    @After
    public void after() throws Exception {
        Configuration.reloadProperties();
    }

    @Before
    public void before() throws Exception {
        this.mFileSystem = FileSystem.Factory.create();
        this.mFileSystem.mount(new AlluxioURI("/mnt/"), new AlluxioURI(this.mLocalUfsPath));
        new File(this.ufsPath(EXISTING_DIR)).mkdirs();
        this.writeUfsFile(this.ufsPath(EXISTING_FILE), 1);
    }

    @Test
    public void getStatusNoSync() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).build();
        this.checkGetStatus(EXISTING_DIR, options, false);
        this.checkGetStatus(EXISTING_FILE, options, false);
        new File(this.ufsPath(NEW_DIR)).mkdirs();
        this.writeUfsFile(this.ufsPath(NEW_FILE), 2);
        this.checkGetStatus(NEW_DIR, options, false);
        this.checkGetStatus(NEW_FILE, options, false);
    }

    @Test
    public void listStatusNoSync() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).build();
        this.checkListStatus(EXISTING_DIR, options, false);
        this.checkListStatus(EXISTING_FILE, options, false);
        new File(this.ufsPath(NEW_DIR)).mkdirs();
        this.writeUfsFile(this.ufsPath(NEW_FILE), 2);
        this.checkListStatus(NEW_DIR, options, false);
        this.checkListStatus(NEW_FILE, options, false);
    }

    @Test
    public void getStatusFileSync() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkGetStatus(EXISTING_FILE, options, true);
    }

    @Test
    public void getStatusDirSync() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkGetStatus(EXISTING_DIR, options, true);
    }

    @Test
    public void getStatusDirSyncOnlyTouchingChildren() throws Exception {
        String dir1 = PathUtils.concatPath((Object)EXISTING_DIR, (Object)"dir_should_sync");
        String dir2 = PathUtils.concatPath((Object)dir1, (Object)"dir_should_not_sync");
        new File(this.ufsPath(dir1)).mkdirs();
        new File(this.ufsPath(dir2)).mkdirs();
        GetStatusPOptions optionsAlways = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkGetStatus(EXISTING_DIR, optionsAlways, true);
        ListStatusPOptions optionsNever = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).setRecursive(false).build();
        this.checkListStatus(dir2, optionsNever, false);
    }

    @Test
    public void listDirSync() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkListStatus(ROOT_DIR, options, true);
        new File(this.ufsPath(NEW_DIR)).mkdirs();
        this.writeUfsFile(this.ufsPath(NEW_FILE), 2);
        this.checkListStatus(ROOT_DIR, options, true);
    }

    @Test
    public void listDirSyncOnlyTouchingChildren() throws Exception {
        String dir1 = PathUtils.concatPath((Object)EXISTING_DIR, (Object)"dir_should_sync");
        String dir2 = PathUtils.concatPath((Object)dir1, (Object)"dir_should_not_sync");
        new File(this.ufsPath(dir1)).mkdirs();
        new File(this.ufsPath(dir2)).mkdirs();
        ListStatusPOptions optionsAlways = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setRecursive(false).setCommonOptions(PSYNC_ALWAYS).build();
        this.checkListStatus(EXISTING_DIR, optionsAlways, true);
        ListStatusPOptions optionsNever = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).setRecursive(false).build();
        this.checkListStatus(dir2, optionsNever, false);
    }

    @Test
    public void getStatusFileSyncInterval() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_INTERVAL).build();
        long startMs = System.currentTimeMillis();
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        long startLength = status.getLength();
        int sizeFactor = 10;
        while (true) {
            this.writeUfsFile(this.ufsPath(EXISTING_FILE), sizeFactor);
            status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
            if (status.getLength() != startLength) break;
            ++sizeFactor;
        }
        long endMs = System.currentTimeMillis();
        Assert.assertTrue((endMs - startMs >= 100L ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void listDirSyncInterval() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_INTERVAL).build();
        long startMs = System.currentTimeMillis();
        List statusList = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(ROOT_DIR)), options);
        long startSize = statusList.size();
        int index = 10;
        while (true) {
            this.writeUfsFile(this.ufsPath(NEW_FILE + index), 1);
            statusList = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(ROOT_DIR)), options);
            if ((long)statusList.size() != startSize) break;
            ++index;
        }
        long endMs = System.currentTimeMillis();
        Assert.assertTrue((endMs - startMs >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void deleteFileNoSync() throws Exception {
        DeletePOptions options = DeletePOptions.newBuilder().setCommonOptions(PSYNC_NEVER).build();
        try {
            this.mFileSystem.delete(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
            Assert.fail((String)("Delete expected to fail: " + this.alluxioPath(EXISTING_FILE)));
        }
        catch (FileDoesNotExistException fileDoesNotExistException) {
            // empty catch block
        }
    }

    @Test
    public void deleteFileSync() throws Exception {
        DeletePOptions options = DeletePOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS).build();
        this.mFileSystem.delete(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
    }

    @Test
    public void renameFileNoSync() throws Exception {
        RenamePOptions options = RenamePOptions.newBuilder().setCommonOptions(PSYNC_NEVER).build();
        try {
            this.mFileSystem.rename(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), new AlluxioURI(this.alluxioPath(NEW_FILE)), options);
            Assert.fail((String)"Rename expected to fail.");
        }
        catch (FileDoesNotExistException fileDoesNotExistException) {
            // empty catch block
        }
    }

    @Test
    public void renameFileSync() throws Exception {
        RenamePOptions options = RenamePOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS).build();
        this.mFileSystem.rename(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), new AlluxioURI(this.alluxioPath(NEW_FILE)), options);
    }

    @Test
    public void unpersistedFileSync() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        List initialStatusList = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(ROOT_DIR)), options).stream().map(URIStatus::getName).collect(Collectors.toList());
        this.writeMustCacheFile(this.alluxioPath(NEW_FILE), 1);
        List syncStatusList = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(ROOT_DIR)), options).stream().map(URIStatus::getName).collect(Collectors.toList());
        HashSet initialSet = Sets.newHashSet(initialStatusList);
        HashSet syncSet = Sets.newHashSet(syncStatusList);
        Assert.assertTrue((syncSet.size() > initialSet.size() ? 1 : 0) != 0);
        syncSet.removeAll(initialSet);
        Assert.assertTrue((syncSet.size() == 1 ? 1 : 0) != 0);
        String file = (String)syncSet.iterator().next();
        Assert.assertTrue((boolean)file.equals(new AlluxioURI(NEW_FILE).getName()));
    }

    @Test(timeout=10000L)
    public void lastModifiedLocalFileSync() throws Exception {
        long modTime;
        int sizefactor = 10;
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        this.writeUfsFile(this.ufsPath(EXISTING_FILE), sizefactor);
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        String startFingerprint = status.getUfsFingerprint();
        long startLength = status.getLength();
        long newModTime = modTime = new File(this.ufsPath(EXISTING_FILE)).lastModified();
        while (newModTime == modTime) {
            long delay = 100L;
            CommonUtils.sleepMs((long)delay);
            this.writeUfsFile(this.ufsPath(EXISTING_FILE), sizefactor);
            newModTime = new File(this.ufsPath(EXISTING_FILE)).lastModified();
        }
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        Assert.assertTrue((status.getLength() == startLength ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)startFingerprint, (Object)status.getUfsFingerprint());
    }

    @Test
    public void mountPoint() throws Exception {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).build();
        List rootListing = this.mFileSystem.listStatus(new AlluxioURI(ROOT_DIR), options).stream().map(URIStatus::getName).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)rootListing.size());
        Assert.assertEquals((Object)"mnt", rootListing.get(0));
        options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        rootListing = this.mFileSystem.listStatus(new AlluxioURI(ROOT_DIR), options).stream().map(URIStatus::getName).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)rootListing.size());
        Assert.assertEquals((Object)"mnt", rootListing.get(0));
    }

    @Test
    public void mountPointConflict() throws Exception {
        GetStatusPOptions gsOptions = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(ROOT_DIR), gsOptions);
        String fromRootUfs = status.getUfsPath() + "/mnt";
        Assert.assertTrue((boolean)new File(fromRootUfs).mkdirs());
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        List rootListing = this.mFileSystem.listStatus(new AlluxioURI(ROOT_DIR), options);
        Assert.assertEquals((long)1L, (long)rootListing.size());
        Assert.assertEquals((Object)"mnt", (Object)((URIStatus)rootListing.get(0)).getName());
        Assert.assertNotEquals((Object)fromRootUfs, (Object)((URIStatus)rootListing.get(0)).getUfsPath());
    }

    @Test
    public void mountPointNested() throws Exception {
        String ufsPath = Files.createTempDir().getAbsolutePath();
        this.mFileSystem.createDirectory(new AlluxioURI("/nested/mnt/"), CreateDirectoryPOptions.newBuilder().setRecursive(true).setWriteType(WritePType.CACHE_THROUGH).build());
        this.mFileSystem.mount(new AlluxioURI("/nested/mnt/ufs"), new AlluxioURI(ufsPath));
        this.mFileSystem.setAttribute(new AlluxioURI(ROOT_DIR), SetAttributePOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS.toBuilder().setTtl(55555L)).setRecursive(true).build());
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).build();
        List listing = this.mFileSystem.listStatus(new AlluxioURI("/nested/mnt/"), options);
        Assert.assertEquals((long)1L, (long)listing.size());
        Assert.assertEquals((Object)"ufs", (Object)((URIStatus)listing.get(0)).getName());
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI("/nested/mnt/"), GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).build());
        Assert.assertTrue((boolean)new File(status.getUfsPath()).delete());
        this.mFileSystem.setAttribute(new AlluxioURI(ROOT_DIR), SetAttributePOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS.toBuilder().setTtl(44444L)).setRecursive(true).build());
        listing = this.mFileSystem.listStatus(new AlluxioURI("/nested/mnt/"), options);
        Assert.assertEquals((long)1L, (long)listing.size());
        Assert.assertEquals((Object)"ufs", (Object)((URIStatus)listing.get(0)).getName());
        status = this.mFileSystem.getStatus(new AlluxioURI("/nested/"), GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_NEVER).build());
        Assert.assertTrue((boolean)new File(status.getUfsPath()).delete());
        this.mFileSystem.setAttribute(new AlluxioURI(ROOT_DIR), SetAttributePOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS.toBuilder().setTtl(44444L)).setRecursive(true).build());
        listing = this.mFileSystem.listStatus(new AlluxioURI("/nested/mnt/"), options);
        Assert.assertEquals((long)1L, (long)listing.size());
        Assert.assertEquals((Object)"ufs", (Object)((URIStatus)listing.get(0)).getName());
        this.writeUfsFile(ufsPath + "/nestedufs", 1);
        this.mFileSystem.setAttribute(new AlluxioURI(ROOT_DIR), SetAttributePOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS.toBuilder().setTtl(44444L)).setRecursive(true).build());
        listing = this.mFileSystem.listStatus(new AlluxioURI("/nested/mnt/ufs"), options);
        Assert.assertEquals((long)1L, (long)listing.size());
        Assert.assertEquals((Object)"nestedufs", (Object)((URIStatus)listing.get(0)).getName());
    }

    @Test
    public void ufsModeSync() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        this.writeUfsFile(this.ufsPath(EXISTING_FILE), 10);
        File ufsFile = new File(this.ufsPath(EXISTING_FILE));
        Assert.assertTrue((boolean)ufsFile.setReadable(true, false));
        Assert.assertTrue((boolean)ufsFile.setWritable(true, false));
        Assert.assertTrue((boolean)ufsFile.setExecutable(true, false));
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        String startFingerprint = status.getUfsFingerprint();
        Assert.assertTrue((boolean)ufsFile.setExecutable(false, false));
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        Assert.assertNotEquals((Object)startFingerprint, (Object)status.getUfsFingerprint());
    }

    @Test
    public void alluxioModeFingerprintUpdate() throws Exception {
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE).setCommonOptions(PSYNC_NEVER).build();
        this.writeUfsFile(this.ufsPath(EXISTING_FILE), 10);
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options));
        this.mFileSystem.setAttribute(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto()).build());
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        String startFingerprint = status.getUfsFingerprint();
        this.mFileSystem.setAttribute(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), SetAttributePOptions.newBuilder().setMode(new Mode(429).toProto()).build());
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        String endFingerprint = status.getUfsFingerprint();
        Assert.assertNotEquals((Object)startFingerprint, (Object)endFingerprint);
    }

    @Test
    public void ufsDirUpdatePermissions() throws Exception {
        new File(this.ufsPath("/dir1")).mkdirs();
        new File(this.ufsPath("/dir1/dir2")).mkdirs();
        String fileA = "/dir1/dir2/fileA";
        this.writeUfsFile(this.ufsPath(fileA), 1);
        FileUtils.changeLocalFilePermission((String)this.ufsPath("/dir1"), (String)"rwxrwxrwx");
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath("/dir1")), options);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((long)FileUtils.translatePosixPermissionToMode(PosixFilePermissions.fromString("rwxrwxrwx")), (long)status.getMode());
        FileUtils.changeLocalFilePermission((String)this.ufsPath("/dir1"), (String)"rwxr-xr-x");
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath("/dir1")), options);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((long)FileUtils.translatePosixPermissionToMode(PosixFilePermissions.fromString("rwxr-xr-x")), (long)status.getMode());
    }

    @Test
    public void ufsMetadataContentChange() throws Exception {
        FileSystemTestUtils.loadFile((FileSystem)this.mFileSystem, (String)this.alluxioPath(EXISTING_FILE));
        GetStatusPOptions options = GetStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_ALWAYS).build();
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        Assert.assertNotNull((Object)status);
        long prevFileid = status.getFileId();
        FileUtils.changeLocalFilePermission((String)this.ufsPath(EXISTING_FILE), (String)"rwxrwxrwx");
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((long)FileUtils.translatePosixPermissionToMode(PosixFilePermissions.fromString("rwxrwxrwx")), (long)status.getMode());
        Assert.assertEquals((long)prevFileid, (long)status.getFileId());
        this.writeUfsFile(this.ufsPath(EXISTING_FILE), 2);
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), options);
        Assert.assertNotNull((Object)status);
        Assert.assertNotEquals((long)prevFileid, (long)status.getFileId());
    }

    @Test
    public void ufsDeleteSync() throws Exception {
        FileSystemTestUtils.loadFile((FileSystem)this.mFileSystem, (String)this.alluxioPath(EXISTING_FILE));
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)new AlluxioURI(this.alluxioPath(EXISTING_FILE)), (int)100);
        new File(this.ufsPath(EXISTING_FILE)).delete();
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(this.alluxioPath(EXISTING_FILE)), ExistsPOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS).build()));
        this.mFileSystem.free(new AlluxioURI(ROOT_DIR), FreePOptions.newBuilder().setRecursive(true).build());
        BlockMasterClient blockClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        CommonUtils.waitFor((String)"data to be freed", () -> {
            try {
                return blockClient.getUsedBytes() == 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(30000L));
    }

    @Test
    public void ufsDeleteChildrenSync() throws Exception {
        String baseDir = "/base_dir";
        int numChildren = 20;
        new File(this.ufsPath(baseDir)).mkdirs();
        for (int i = 0; i < numChildren; ++i) {
            this.writeUfsFile(this.ufsPath(baseDir + "/child" + i), 10000);
        }
        ListStatusPOptions lsOptions = ListStatusPOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS).build();
        List statuses = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(baseDir)), lsOptions);
        Assert.assertEquals((long)numChildren, (long)statuses.size());
        for (int i = 0; i < numChildren; ++i) {
            new File(this.ufsPath(baseDir + "/child" + i)).delete();
        }
        statuses = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(baseDir)), lsOptions);
        Assert.assertTrue((boolean)statuses.isEmpty());
    }

    @Test
    public void createNestedFileSync() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, (Object)"0");
        this.mFileSystem.createFile(new AlluxioURI(this.alluxioPath(NEW_NESTED_FILE)), CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setCommonOptions(PSYNC_ALWAYS).setRecursive(true).build()).close();
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(EXISTING_FILE))));
    }

    @Test
    public void clusterRestartSync() throws Exception {
        ListStatusPOptions listStatusPOptions = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(PSYNC_LARGE_INTERVAL).build();
        List statusList = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(EXISTING_DIR)), listStatusPOptions);
        Assert.assertNotNull((Object)statusList);
        Assert.assertEquals((long)0L, (long)statusList.size());
        this.mLocalAlluxioClusterResource.get().stopMasters();
        this.mLocalAlluxioClusterResource.get().startMasters();
        List statusListAfterRestart = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(EXISTING_DIR)), listStatusPOptions);
        Assert.assertNotNull((Object)statusListAfterRestart);
        Assert.assertEquals((long)0L, (long)statusListAfterRestart.size());
        this.writeUfsFile(this.ufsPath(NEW_FILE_UNDER_DIR), 1);
        List statusListAgain = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(EXISTING_DIR)), listStatusPOptions);
        Assert.assertNotNull((Object)statusListAgain);
        Assert.assertEquals((long)0L, (long)statusListAgain.size());
        Thread.sleep(1000L);
        List statusListAfterSleeping = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(EXISTING_DIR)), listStatusPOptions);
        Assert.assertNotNull((Object)statusListAfterSleeping);
        Assert.assertEquals((long)1L, (long)statusListAfterSleeping.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.metadata.load.type", "NEVER"})
    @Test
    public void interruptSync() throws Exception {
        List status;
        for (int i = 0; i < 100; ++i) {
            new File(this.ufsPath("/dir" + i)).mkdirs();
            for (int j = 0; j < 100; ++j) {
                new File(this.ufsPath("/dir" + i + "/dir" + j)).mkdirs();
                this.writeUfsFile(this.ufsPath("/dir" + i + "/dir" + j + "/file"), 1);
            }
        }
        Context.CancellableContext c = Context.current().withDeadlineAfter(1L, TimeUnit.MILLISECONDS, Executors.newScheduledThreadPool(1));
        Object object = null;
        try {
            Context toRestore = c.attach();
            try {
                status = (List)Context.current().withCancellation().call(() -> {
                    try {
                        return this.mFileSystem.listStatus(new AlluxioURI(ROOT_DIR), ListStatusPOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemOptionsUtils.commonDefaults((AlluxioConfiguration)this.mFileSystem.getConf()).toBuilder().setSyncIntervalMs(0L).build()).build());
                    }
                    catch (Exception e) {
                        return Collections.emptyList();
                    }
                });
                Thread.sleep(5L);
                c.cancel((Throwable)new AlluxioException("test exception"));
            }
            finally {
                c.detach(toRestore);
            }
        }
        catch (Throwable toRestore) {
            object = toRestore;
            throw toRestore;
        }
        finally {
            if (c != null) {
                if (object != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable toRestore) {
                        ((Throwable)object).addSuppressed(toRestore);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)0L, (long)status.size());
        status = this.mFileSystem.listStatus(new AlluxioURI(ROOT_DIR), ListStatusPOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemOptionsUtils.commonDefaults((AlluxioConfiguration)this.mFileSystem.getConf()).toBuilder().setSyncIntervalMs(-1L).build()).build());
        int TOTAL_FILE_COUNT = 20103;
        Assert.assertTrue((status.size() < 20103 ? 1 : 0) != 0);
        for (URIStatus stat : status) {
            Assert.assertTrue((boolean)stat.isCompleted());
        }
        status = this.mFileSystem.listStatus(new AlluxioURI(ROOT_DIR), ListStatusPOptions.newBuilder().setRecursive(true).setCommonOptions(PSYNC_ALWAYS).build());
        Assert.assertEquals((long)20103L, (long)status.size());
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.metadata.load.type", "NEVER"})
    @Test
    public void recursiveSync() throws Exception {
        new File(this.ufsPath("/dir1")).mkdirs();
        new File(this.ufsPath("/dir1/dir2")).mkdirs();
        new File(this.ufsPath("/dir1/dir2/dir3")).mkdirs();
        String fileA = "/dir1/dir2/fileA";
        String fileB = "/dir1/dir2/fileB";
        String fileC = "/dir1/dir2/fileC";
        this.writeUfsFile(this.ufsPath(fileA), 1);
        this.writeUfsFile(this.ufsPath(fileB), 1);
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(this.alluxioPath(fileA)), ExistsPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults((AlluxioConfiguration)this.mFileSystem.getConf()).toBuilder().setSyncIntervalMs(-1L).build()).build()));
        try {
            this.mFileSystem.setAttribute(new AlluxioURI(this.alluxioPath("/dir1")), SetAttributePOptions.newBuilder().setRecursive(true).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(55555L).setSyncIntervalMs(-1L)).build());
        }
        catch (FileDoesNotExistException fileDoesNotExistException) {
            // empty catch block
        }
        FileSystemMasterCommonPOptions ttlOption = FileSystemMasterCommonPOptions.newBuilder().setTtl(123456789L).setSyncIntervalMs(0L).build();
        this.mFileSystem.setAttribute(new AlluxioURI(this.alluxioPath("/dir1")), SetAttributePOptions.newBuilder().setRecursive(true).setCommonOptions(ttlOption).build());
        ttlOption = ttlOption.toBuilder().setSyncIntervalMs(-1L).build();
        URIStatus status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(fileA)));
        Assert.assertEquals((long)ttlOption.getTtl(), (long)status.getTtl());
        this.writeUfsFile(this.ufsPath(fileC), 1);
        Assert.assertTrue((boolean)new File(this.ufsPath(fileA)).delete());
        ttlOption = FileSystemMasterCommonPOptions.newBuilder().setTtl(987654321L).setSyncIntervalMs(0L).build();
        this.mFileSystem.setAttribute(new AlluxioURI(this.alluxioPath("/dir1")), SetAttributePOptions.newBuilder().setRecursive(true).setCommonOptions(ttlOption).build());
        ttlOption = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L).setTtl(987654321L).build();
        status = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(fileB)));
        Assert.assertEquals((long)ttlOption.getTtl(), (long)status.getTtl());
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(this.alluxioPath(fileA))));
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.metadata.load.type", "NEVER"})
    @Test
    public void recursiveSyncCacheDescendants() throws Exception {
        new File(this.ufsPath("/dir1")).mkdirs();
        new File(this.ufsPath("/dir1/dir2")).mkdirs();
        new File(this.ufsPath("/dir1/dir2/dir3")).mkdirs();
        String fileA = "/dir1/dir2/dir3/fileA";
        String fileB = "/dir1/dir2/dir3/fileB";
        String fileNew = "/dir1/dir2/dir3/fileNew";
        this.writeUfsFile(this.ufsPath(fileA), 1);
        this.writeUfsFile(this.ufsPath(fileB), 1);
        FileSystemMasterCommonPOptions longinterval = FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(3600000L).build();
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(this.alluxioPath(fileA)), ExistsPOptions.newBuilder().setCommonOptions(PSYNC_NEVER).build()));
        try {
            this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/dir1")), ListStatusPOptions.newBuilder().setCommonOptions(PSYNC_NEVER).build());
            Assert.fail((String)"paths are not expected to exist without sync");
        }
        catch (FileDoesNotExistException fileDoesNotExistException) {
            // empty catch block
        }
        List paths = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/dir1")), ListStatusPOptions.newBuilder().setCommonOptions(PSYNC_ALWAYS).setRecursive(true).build());
        Assert.assertEquals((long)4L, (long)paths.size());
        this.writeUfsFile(this.ufsPath(fileNew), 1);
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(this.alluxioPath(fileNew)), ExistsPOptions.newBuilder().setCommonOptions(longinterval).build()));
        paths = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/dir1/dir2/dir3")), ListStatusPOptions.newBuilder().setCommonOptions(longinterval).build());
        Assert.assertEquals((long)2L, (long)paths.size());
        new File(this.ufsPath("/dir1/dir2/dirNew")).mkdirs();
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(this.alluxioPath("/dir1/dir2/dirNew")), ExistsPOptions.newBuilder().setCommonOptions(longinterval).build()));
        paths = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/dir1/dir2")), ListStatusPOptions.newBuilder().setCommonOptions(longinterval).build());
        Assert.assertEquals((long)1L, (long)paths.size());
        paths = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/dir1")), ListStatusPOptions.newBuilder().setCommonOptions(longinterval).setRecursive(true).build());
        Assert.assertEquals((long)4L, (long)paths.size());
    }

    @Test
    public void deleteUfsFileGetStatus() throws Exception {
        new File(this.ufsPath("/delete")).mkdirs();
        this.writeUfsFile(this.ufsPath("/delete/file"), 10);
        List paths = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/delete")), ListStatusPOptions.newBuilder().setRecursive(false).setCommonOptions(PSYNC_ALWAYS).build());
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"file", (Object)((URIStatus)paths.get(0)).getName());
        new File(this.ufsPath("/delete/file")).delete();
        CommonUtils.sleepMs((long)3000L);
        this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath("/delete")), GetStatusPOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(2000L).build()).build());
        this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath("/delete")), ListStatusPOptions.newBuilder().setRecursive(false).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(2000L).build()).build());
        try {
            this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath("/delete/file")), GetStatusPOptions.newBuilder().setCommonOptions(PSYNC_NEVER).build());
            Assert.fail((String)"the ufs deleted file is not expected to exist after sync via getStatus");
        }
        catch (FileDoesNotExistException fileDoesNotExistException) {
            // empty catch block
        }
    }

    private String ufsPath(String path) {
        return this.mLocalUfsPath + path;
    }

    private String alluxioPath(String path) {
        return "/mnt/" + path;
    }

    private void writeUfsFile(String path, int sizeFactor) throws IOException {
        FileWriter fileWriter = new FileWriter(path);
        for (int i = 0; i < sizeFactor; ++i) {
            fileWriter.write("test");
        }
        fileWriter.close();
    }

    private void writeMustCacheFile(String path, int sizeFactor) throws Exception {
        CreateFilePOptions options = CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setRecursive(true).build();
        FileOutStream os = this.mFileSystem.createFile(new AlluxioURI(path), options);
        for (int i = 0; i < sizeFactor; ++i) {
            os.write("test".getBytes());
        }
        os.close();
    }

    private void checkGetStatus(String path, GetStatusPOptions options, boolean expectExists) throws Exception {
        block3: {
            try {
                URIStatus uriStatus = this.mFileSystem.getStatus(new AlluxioURI(this.alluxioPath(path)), options);
                if (!expectExists) {
                    Assert.fail((String)("Path is not expected to exist: " + this.alluxioPath(path)));
                }
                this.checkUriStatus(uriStatus);
            }
            catch (FileDoesNotExistException e) {
                if (!expectExists) break block3;
                throw e;
            }
        }
    }

    private void checkListStatus(String path, ListStatusPOptions options, boolean expectExists) throws Exception {
        block4: {
            try {
                List statusList = this.mFileSystem.listStatus(new AlluxioURI(this.alluxioPath(path)), options);
                if (!expectExists) {
                    Assert.fail((String)("Path is not expected to exist: " + this.alluxioPath(path)));
                }
                Assert.assertNotNull((Object)statusList);
                for (URIStatus uriStatus : statusList) {
                    this.checkUriStatus(uriStatus);
                }
                this.checkUfsListing(this.ufsPath(path), statusList);
            }
            catch (FileDoesNotExistException e) {
                if (!expectExists) break block4;
                throw e;
            }
        }
    }

    private void checkUriStatus(URIStatus uriStatus) {
        File ufsFile = new File(uriStatus.getUfsPath());
        if (uriStatus.isFolder() != ufsFile.isDirectory()) {
            Assert.fail((String)("Directory mismatch (Alluxio isDir: " + uriStatus.isFolder() + ") (ufs isDir: " + ufsFile.isDirectory() + ") path: " + uriStatus.getPath()));
        }
        if (!uriStatus.isFolder()) {
            String alluxioFingerprint;
            UnderFileSystem ufs;
            String ufsFingerprint;
            long alluxioLength;
            long ufsLength = ufsFile.length();
            if (ufsLength != (alluxioLength = uriStatus.getLength())) {
                Assert.fail((String)("Alluxio length (" + alluxioLength + ") and ufs length (" + ufsLength + ") are inconsistent. path: " + uriStatus.getPath()));
            }
            if (!(ufsFingerprint = (ufs = UnderFileSystem.Factory.create((String)uriStatus.getUfsPath(), (AlluxioConfiguration)Configuration.global())).getParsedFingerprint(uriStatus.getUfsPath()).serialize()).equals(alluxioFingerprint = uriStatus.getUfsFingerprint())) {
                Assert.fail((String)("Alluxio fingerprint (" + alluxioFingerprint + ") and ufs fingerprint (" + ufsFingerprint + ") are inconsistent. path: " + uriStatus.getPath()));
            }
        }
    }

    private void checkUfsListing(String ufsPath, List<URIStatus> statusList) {
        File ufsFile = new File(ufsPath);
        HashSet ufsFiles = Sets.newHashSet((Object[])ufsFile.list());
        HashSet<String> alluxioFiles = new HashSet<String>();
        for (URIStatus uriStatus : statusList) {
            alluxioFiles.add(uriStatus.getName());
        }
        ufsFiles.removeAll(alluxioFiles);
        if (!ufsFiles.isEmpty()) {
            Assert.fail((String)("UFS files are missing from Alluxio: " + ufsFiles));
        }
    }
}

