/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix ignored tests for UFS read")
public class UnderStorageReadIntegrationTest
extends BaseIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(UnderStorageReadIntegrationTest.class);
    private static final int MIN_LEN = 0;
    private static final int MAX_LEN = 255;
    private static final int DELTA = 33;
    private FileSystem mFileSystem = null;
    private CreateFilePOptions mWriteUnderStore;
    private OpenFilePOptions mReadNoCache;
    private OpenFilePOptions mReadCache;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES, "100").setProperty(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX, 2).build();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Before
    public final void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        this.mWriteUnderStore = CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).setRecursive(true).build();
        this.mReadCache = OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE_PROMOTE).build();
        this.mReadNoCache = OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build();
    }

    @Test
    public void read() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            if (k == 0) {
                Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
            } else {
                Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
            }
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            byte[] ret = new byte[k];
            int value = is.read();
            int cnt = 0;
            while (value != -1) {
                Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                ret[cnt++] = (byte)value;
                value = is.read();
            }
            Assert.assertEquals((long)cnt, (long)k);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            if (k == 0) {
                Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
            } else {
                Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
            }
            FileInStream isCache = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            value = isCache.read();
            cnt = 0;
            while (value != -1) {
                Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                ret[cnt++] = (byte)value;
                value = isCache.read();
            }
            Assert.assertEquals((long)cnt, (long)k);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            isCache.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            isCache = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            value = isCache.read();
            cnt = 0;
            while (value != -1) {
                Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                ret[cnt++] = (byte)value;
                value = isCache.read();
            }
            Assert.assertEquals((long)cnt, (long)k);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            isCache.close();
            Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
        }
    }

    @Test
    public void concurrentUfsRead() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        final AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + 255);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)255);
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        final AtomicInteger count = new AtomicInteger(0);
        final Random random = new Random();
        int expectedCount = 100;
        int i = 0;
        while (i < expectedCount) {
            final int index = i++;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(random.nextInt(100));
                        FileInStream isCache = UnderStorageReadIntegrationTest.this.mFileSystem.openFile(uri, UnderStorageReadIntegrationTest.this.mReadCache);
                        Thread.sleep(100L);
                        byte[] ret = new byte[255];
                        int value = isCache.read();
                        int cnt = 0;
                        while (value != -1) {
                            Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                            Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                            ret[cnt++] = (byte)value;
                            value = isCache.read();
                        }
                        isCache.close();
                        Assert.assertEquals((long)cnt, (long)255L);
                        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])ret));
                        while (UnderStorageReadIntegrationTest.this.mFileSystem.getStatus(uri).getInAlluxioPercentage() < 100) {
                            Thread.sleep(1000L);
                        }
                        Assert.assertEquals((long)100L, (long)UnderStorageReadIntegrationTest.this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
                        count.incrementAndGet();
                    }
                    catch (AssertionError e) {
                        Assert.fail((String)((Throwable)((Object)e)).getMessage());
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to read file {}.", (Object)index, (Object)e);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(300000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue(((double)count.get() >= (double)expectedCount * 0.99 ? 1 : 0) != 0);
    }

    @Test
    public void seek() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 33; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            Assert.assertEquals((long)0L, (long)is.read());
            is.seek((long)(k / 3));
            Assert.assertEquals((long)(k / 3), (long)is.read());
            is.seek((long)(k / 2));
            Assert.assertEquals((long)(k / 2), (long)is.read());
            is.seek((long)(k / 4));
            Assert.assertEquals((long)(k / 4), (long)is.read());
            is.close();
            FileInStream isCache = this.mFileSystem.openFile(uri, this.mReadCache);
            Assert.assertEquals((long)0L, (long)isCache.read());
            isCache.seek((long)(k / 3));
            Assert.assertEquals((long)(k / 3), (long)isCache.read());
            isCache.seek((long)(k / 2));
            Assert.assertEquals((long)(k / 2), (long)isCache.read());
            isCache.seek((long)(k / 4));
            Assert.assertEquals((long)(k / 4), (long)isCache.read());
            isCache.close();
        }
    }

    @Test
    public void skip() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 33; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            Assert.assertEquals((long)(k / 2), (long)is.skip((long)(k / 2)));
            Assert.assertEquals((long)(k / 2), (long)is.read());
            is.close();
            if (k >= 3) {
                is = this.mFileSystem.openFile(uri, this.mReadNoCache);
                int t = k / 3;
                Assert.assertEquals((long)t, (long)is.skip((long)t));
                Assert.assertEquals((long)t, (long)is.read());
                Assert.assertEquals((long)t, (long)is.skip((long)t));
                Assert.assertEquals((long)(2 * t + 1), (long)is.read());
                is.close();
            }
            FileInStream isCache = this.mFileSystem.openFile(uri, this.mReadCache);
            Assert.assertEquals((long)(k / 2), (long)isCache.skip((long)(k / 2)));
            Assert.assertEquals((long)(k / 2), (long)isCache.read());
            isCache.close();
            IntegrationTestUtils.waitForFileCached(this.mFileSystem, uri, 1000);
            if (k < 3) continue;
            isCache = this.mFileSystem.openFile(uri, this.mReadCache);
            int t = k / 3;
            Assert.assertEquals((long)t, (long)isCache.skip((long)t));
            Assert.assertEquals((long)t, (long)isCache.read());
            Assert.assertEquals((long)t, (long)isCache.skip((long)t));
            Assert.assertEquals((long)(2 * t + 1), (long)isCache.read());
            isCache.close();
            IntegrationTestUtils.waitForFileCached(this.mFileSystem, uri, 1000);
        }
    }

    @Test
    public void readMultiBlockFile() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        int blockSizeByte = 10;
        int numBlocks = 10;
        AlluxioURI uri = new AlluxioURI(uniqPath);
        FileOutStream os = this.mFileSystem.createFile(uri, this.mWriteUnderStore);
        for (int i = 0; i < numBlocks; ++i) {
            for (int j = 0; j < blockSizeByte; ++j) {
                os.write((int)((byte)(i * blockSizeByte + j)));
            }
        }
        os.close();
        FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
        for (int i = 0; i < blockSizeByte * numBlocks; ++i) {
            Assert.assertEquals((long)((byte)i), (long)is.read());
        }
        is.close();
        FileInStream isCache = this.mFileSystem.openFile(uri, this.mReadCache);
        for (int i = 0; i < blockSizeByte * numBlocks; ++i) {
            Assert.assertEquals((long)((byte)i), (long)isCache.read());
        }
        isCache.close();
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
    }
}

