/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="redefine behaviors")
public final class ConcurrentFileSystemIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private FileSystem mFileSystem;

    @Before
    public void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @Test
    public void listAndDeleteLargeDirectory() throws Exception {
        int numSubdirs = 100;
        AlluxioURI testDir = new AlluxioURI("/testDir");
        this.mFileSystem.createDirectory(testDir);
        for (int i = 0; i < numSubdirs; ++i) {
            this.mFileSystem.createDirectory(new AlluxioURI("/testDir/" + i));
        }
        Thread deleteThread = new Thread(() -> {
            for (int i = 0; i < numSubdirs; ++i) {
                try {
                    this.mFileSystem.delete(new AlluxioURI("/testDir/" + i));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        deleteThread.start();
        int prevCount = numSubdirs;
        while (deleteThread.isAlive()) {
            int count = this.mFileSystem.listStatus(testDir).size();
            Assert.assertThat((Object)count, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(prevCount)));
            prevCount = count;
        }
        deleteThread.join();
    }
}

