/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.concurrent.ConcurrentFileSystemMasterUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.WritePType;
import alluxio.master.file.meta.PersistenceState;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemFactory;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="redefine behaviors")
public class ConcurrentFileSystemMasterCreateIntegrationTest
extends BaseIntegrationTest {
    private static final String TEST_USER = "test";
    private static final int CONCURRENCY_FACTOR = 50;
    private static final long SLEEP_MS = 100L;
    private FileSystem mFileSystem;
    private String mLocalUfsPath = Files.createTempDir().getAbsolutePath();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "sleep://" + this.mLocalUfsPath).setProperty(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX, 50).setProperty(PropertyKey.USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MAX, 50).setProperty(PropertyKey.MASTER_RPC_EXECUTOR_CORE_POOL_SIZE, 50).build();
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new SleepingUnderFileSystemFactory(new SleepingUnderFileSystemOptions().setMkdirsMs(100L).setIsDirectoryMs(100L).setGetFileStatusMs(100L).setIsFileMs(100L)));

    @Before
    public void before() {
        this.mFileSystem = FileSystem.Factory.create();
        Configuration.set((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, (Object)"2b");
    }

    @After
    public void after() {
        Configuration.reloadProperties();
    }

    @Test
    public void concurrentCreate() throws Exception {
        int numThreads = 50;
        long limitMs = 35000L;
        AlluxioURI[] paths = new AlluxioURI[50];
        for (int i = 0; i < 50; ++i) {
            paths[i] = new AlluxioURI("/existing/path/dir/shared_dir/t_" + i + "/sub_dir1/sub_dir2/file" + i);
        }
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.CREATE, paths, 35000L);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0)));
        }
    }

    @Test
    public void concurrentCreateExistingDir() throws Exception {
        int numThreads = 50;
        long limitMs = 35000L;
        AlluxioURI[] paths = new AlluxioURI[50];
        this.mFileSystem.createDirectory(new AlluxioURI("/existing/path/dir/"), CreateDirectoryPOptions.newBuilder().setRecursive(true).setWriteType(WritePType.CACHE_THROUGH).build());
        for (int i = 0; i < 50; ++i) {
            paths[i] = new AlluxioURI("/existing/path/dir/shared_dir/t_" + i + "/sub_dir1/sub_dir2/file" + i);
        }
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.CREATE, paths, 35000L);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0)));
        }
    }

    @Test
    public void concurrentCreateNonPersistedDir() throws Exception {
        int numThreads = 50;
        long limitMs = 35000L;
        AlluxioURI[] paths = new AlluxioURI[50];
        this.mFileSystem.createDirectory(new AlluxioURI("/existing/path/dir/"), CreateDirectoryPOptions.newBuilder().setRecursive(true).setWriteType(WritePType.MUST_CACHE).build());
        for (int i = 0; i < 50; ++i) {
            paths[i] = new AlluxioURI("/existing/path/dir/shared_dir/t_" + i + "/sub_dir1/sub_dir2/file" + i);
        }
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.CREATE, paths, 35000L);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0)));
        }
    }

    @Test
    public void concurrentLoadFileMetadata() throws Exception {
        this.runLoadMetadata(null, false, true, false);
    }

    @Test
    public void concurrentLoadFileMetadataExistingDir() throws Exception {
        this.runLoadMetadata(WritePType.CACHE_THROUGH, false, true, false);
    }

    @Test
    public void concurrentLoadFileMetadataNonPersistedDir() throws Exception {
        this.runLoadMetadata(WritePType.MUST_CACHE, false, true, false);
    }

    @Test
    public void concurrentLoadSameFileMetadata() throws Exception {
        this.runLoadMetadata(null, true, true, false);
    }

    @Test
    public void concurrentLoadSameFileMetadataExistingDir() throws Exception {
        this.runLoadMetadata(WritePType.CACHE_THROUGH, true, true, false);
    }

    @Test
    public void concurrentLoadSameFileMetadataNonPersistedDir() throws Exception {
        this.runLoadMetadata(WritePType.MUST_CACHE, true, true, false);
    }

    @Test
    public void concurrentLoadDirMetadata() throws Exception {
        this.runLoadMetadata(null, false, false, false);
    }

    @Test
    public void concurrentLoadDirMetadataExistingDir() throws Exception {
        this.runLoadMetadata(WritePType.CACHE_THROUGH, false, false, false);
    }

    @Test
    public void concurrentLoadDirMetadataNonPersistedDir() throws Exception {
        this.runLoadMetadata(WritePType.MUST_CACHE, false, false, false);
    }

    @Test
    public void concurrentLoadSameDirMetadata() throws Exception {
        this.runLoadMetadata(null, true, false, false);
    }

    @Test
    public void concurrentLoadSameDirMetadataExistingDir() throws Exception {
        this.runLoadMetadata(WritePType.CACHE_THROUGH, true, false, false);
    }

    @Test
    public void concurrentLoadSameDirMetadataNonPersistedDir() throws Exception {
        this.runLoadMetadata(WritePType.MUST_CACHE, true, false, false);
    }

    @Test
    public void concurrentListDirs() throws Exception {
        this.runLoadMetadata(null, false, false, true);
    }

    @Test
    public void concurrentListDirsExistingDir() throws Exception {
        this.runLoadMetadata(WritePType.CACHE_THROUGH, false, false, true);
    }

    @Test
    public void concurrentListDirsNonPersistedDir() throws Exception {
        this.runLoadMetadata(WritePType.MUST_CACHE, false, false, true);
    }

    @Test
    public void concurrentListFiles() throws Exception {
        this.runLoadMetadata(null, false, true, true);
    }

    @Test
    public void concurrentListFilesExistingDir() throws Exception {
        this.runLoadMetadata(WritePType.CACHE_THROUGH, false, true, true);
    }

    @Test
    public void concurrentListFilesNonPersistedDir() throws Exception {
        this.runLoadMetadata(WritePType.MUST_CACHE, false, true, true);
    }

    private void runLoadMetadata(WritePType writeType, boolean useSinglePath, boolean createFiles, boolean listParentDir) throws Exception {
        int uniquePaths;
        int numThreads = 50;
        int bufferFactor = 25;
        long limitMs = 200L * (long)bufferFactor;
        int n = uniquePaths = useSinglePath ? 1 : numThreads;
        if (writeType != WritePType.CACHE_THROUGH) {
            limitMs = 300L * (long)bufferFactor;
        }
        if (listParentDir) {
            uniquePaths = 10;
            limitMs = 2L + (long)uniquePaths * 100L * (long)bufferFactor;
        }
        new File(this.mLocalUfsPath + "/existing/path/").mkdirs();
        for (int i = 0; i < uniquePaths; ++i) {
            if (createFiles) {
                FileWriter fileWriter = new FileWriter(this.mLocalUfsPath + "/existing/path/last_" + i);
                fileWriter.write("testtesttesttest");
                fileWriter.close();
                continue;
            }
            new File(this.mLocalUfsPath + "/existing/path/last_" + i).mkdirs();
        }
        if (writeType != null) {
            this.mFileSystem.createDirectory(new AlluxioURI("/existing/path/"), CreateDirectoryPOptions.newBuilder().setRecursive(true).setWriteType(writeType).build());
        }
        AlluxioURI[] paths = new AlluxioURI[numThreads];
        int fileId = 0;
        for (int i = 0; i < numThreads; ++i) {
            paths[i] = listParentDir ? new AlluxioURI("/existing/path/") : new AlluxioURI("/existing/path/last_" + fileId++ % uniquePaths);
        }
        List<Throwable> errors = listParentDir ? ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.LIST_STATUS, paths, limitMs) : ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.GET_FILE_INFO, paths, limitMs);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0) + "\n" + Throwables.getStackTraceAsString((Throwable)errors.get(0))));
        }
        ListStatusPOptions listOptions = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).build();
        List files = this.mFileSystem.listStatus(new AlluxioURI("/"), listOptions);
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertEquals((Object)"existing", (Object)((URIStatus)files.get(0)).getName());
        Assert.assertEquals((Object)PersistenceState.PERSISTED, (Object)PersistenceState.valueOf((String)((URIStatus)files.get(0)).getPersistenceState()));
        files = this.mFileSystem.listStatus(new AlluxioURI("/existing"), listOptions);
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertEquals((Object)"path", (Object)((URIStatus)files.get(0)).getName());
        Assert.assertEquals((Object)PersistenceState.PERSISTED, (Object)PersistenceState.valueOf((String)((URIStatus)files.get(0)).getPersistenceState()));
        files = this.mFileSystem.listStatus(new AlluxioURI("/existing/path/"), listOptions);
        Assert.assertEquals((long)uniquePaths, (long)files.size());
        Collections.sort(files, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (int i = 0; i < uniquePaths; ++i) {
            Assert.assertEquals((Object)("last_" + i), (Object)((URIStatus)files.get(i)).getName());
            Assert.assertEquals((Object)PersistenceState.PERSISTED, (Object)PersistenceState.valueOf((String)((URIStatus)files.get(i)).getPersistenceState()));
        }
    }
}

