/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.fs.concurrent.ConcurrentFileSystemMasterUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="redefine behaviors")
public final class ConcurrentFileSystemMasterLoadMetadataIntegrationTest {
    private static final int CONCURRENCY_FACTOR = 20;
    private FileSystem mFileSystem;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX, 20).setProperty(PropertyKey.USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MAX, 20).setProperty(PropertyKey.MASTER_RPC_EXECUTOR_CORE_POOL_SIZE, 20).build();

    @Before
    public void before() {
        this.mFileSystem = FileSystem.Factory.create();
    }

    @Test
    public void loadMetadataManyDirectories() throws Exception {
        String ufsPath = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        for (int i = 0; i < 5000; ++i) {
            Files.createDirectory(Paths.get(ufsPath, "a" + i), new FileAttribute[0]);
        }
        List<AlluxioURI> paths = Collections.nCopies(20, new AlluxioURI("/"));
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.LIST_STATUS, paths.toArray(new AlluxioURI[0]), 60000L);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, errors);
    }

    @Test
    public void loadMetadataManyFiles() throws Exception {
        String ufsPath = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        for (int i = 0; i < 5000; ++i) {
            Files.createFile(Paths.get(ufsPath, "a" + i), new FileAttribute[0]);
        }
        List<AlluxioURI> paths = Collections.nCopies(20, new AlluxioURI("/"));
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.LIST_STATUS, paths.toArray(new AlluxioURI[0]), 60000L);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, errors);
    }
}

