/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.master.journal.JournalType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="redefine behaviors")
public class ConcurrentRecursiveCreateIntegrationTest
extends BaseIntegrationTest {
    private static final int NUM_TOP_LEVEL_DIRS = 10;
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.UFS).build();

    @Test
    public void createDuringUfsRename() throws Exception {
        int i;
        FileSystem fs = this.mClusterResource.get().getClient();
        ExecutorService executor = Executors.newCachedThreadPool();
        UnderFileSystem ufs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
        String ufsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        ArrayList<String> paths = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            String alluxioPath = PathUtils.concatPath((Object)("/dir" + i), (Object[])new Object[]{"a", "b", "c"});
            ufs.mkdirs(PathUtils.concatPath((Object)ufsRoot, (Object)alluxioPath));
            paths.add(alluxioPath);
        }
        executor.submit(new UfsRenamer(ufs, ufsRoot));
        for (i = 0; i < 10; ++i) {
            executor.submit(new AlluxioCreator(fs, paths));
        }
        CommonUtils.sleepMs((long)2000L);
        executor.shutdownNow();
        TestCase.assertTrue((boolean)executor.awaitTermination(5L, TimeUnit.SECONDS));
        this.mClusterResource.get().restartMasters();
        fs = this.mClusterResource.get().getClient();
        fs.listStatus(new AlluxioURI("/"));
    }

    private static class AlluxioCreator
    implements Callable<Void> {
        private final FileSystem mFs;
        private final List<String> mPaths;

        public AlluxioCreator(FileSystem fs, List<String> paths) {
            this.mFs = fs;
            this.mPaths = paths;
        }

        @Override
        public Void call() {
            while (!Thread.interrupted()) {
                int ind = ThreadLocalRandom.current().nextInt(this.mPaths.size());
                String path = this.mPaths.get(ind);
                try {
                    this.mFs.createDirectory(new AlluxioURI(path), CreateDirectoryPOptions.newBuilder().setRecursive(true).setAllowExists(true).build());
                    while (!PathUtils.isRoot((String)PathUtils.getParent((String)path))) {
                        path = PathUtils.getParent((String)path);
                    }
                    this.mFs.delete(new AlluxioURI(path), DeletePOptions.newBuilder().setRecursive(true).build());
                }
                catch (Exception e) {}
            }
            return null;
        }
    }

    private static class UfsRenamer
    implements Callable<Void> {
        private final UnderFileSystem mUfs;
        private final String mUfsRoot;

        public UfsRenamer(UnderFileSystem ufs, String ufsRoot) {
            this.mUfs = ufs;
            this.mUfsRoot = ufsRoot;
        }

        @Override
        public Void call() throws Exception {
            while (!Thread.interrupted()) {
                String src = PathUtils.concatPath((Object)this.mUfsRoot, (Object)("dir" + ThreadLocalRandom.current().nextInt(10)));
                String dst = PathUtils.concatPath((Object)this.mUfsRoot, (Object)("dir" + ThreadLocalRandom.current().nextInt(10)));
                if (!this.mUfs.exists(src) || this.mUfs.exists(dst)) continue;
                this.mUfs.renameDirectory(src, dst);
            }
            return null;
        }
    }
}

